/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.model;

import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.Layout;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.util.List;

public class HangingProtocolSnapshotRuntime
extends AbstractSnapshotRuntime
implements ISnapshotDefinition {
    private static final ALogger log = ALogger.getLogger(HangingProtocolSnapshotRuntime.class);
    private boolean useRuntimeForSave = false;
    private LayoutRuntime layoutRuntime;
    private OrderHanging orderHanging;
    private ConditionalHanging conditionalHanging;
    private HangingDefinitionRuntime hangingDefinitionRuntime;
    private boolean hangingApplied;
    private boolean cacheDisplaySets = true;
    private boolean clearCachedDSAfterFirstUse = false;
    private boolean initedFromRuntime = false;

    public HangingProtocolSnapshotRuntime(Snapshot snapshot, HangingDefinitionRuntime hangingDefinitionRuntime) {
        super(snapshot);
        this.setHangingDefinitionRuntime(hangingDefinitionRuntime);
        this.setUseRuntimeForSave(false);
        this.layoutRuntime = new LayoutRuntime(snapshot.getLayout());
        this.layoutRuntime.setHangingSnapshot(this);
        if (snapshot.getConditionalHanging() != null) {
            this.setConditionalHanging(snapshot.getConditionalHanging().clone());
        }
        if (snapshot.getOrderHanging() != null) {
            this.setOrderHanging(snapshot.getOrderHanging().clone());
        }
    }

    public HangingProtocolSnapshotRuntime(String string, HangingDefinitionRuntime hangingDefinitionRuntime) {
        super(string);
        this.setHangingDefinitionRuntime(hangingDefinitionRuntime);
        this.setUseRuntimeForSave(false);
        Snapshot snapshot = new Snapshot();
        Layout layout = new Layout();
        snapshot.setLayout(layout);
        snapshot.setConditionalHanging(new ConditionalHanging());
        this.setDelegate(snapshot);
        this.setConditionalHanging(snapshot.getConditionalHanging().clone());
        this.layoutRuntime = new LayoutRuntime(layout);
        this.layoutRuntime.setHangingSnapshot(this);
    }

    public HangingProtocolSnapshotRuntime(HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime, HangingDefinitionRuntime hangingDefinitionRuntime) {
        this.setName(hangingProtocolSnapshotRuntime.getName());
        this.setHangingDefinitionRuntime(hangingDefinitionRuntime);
        this.setDelegate((Snapshot)hangingProtocolSnapshotRuntime.getDelegate());
        this.setUseRuntimeForSave(hangingProtocolSnapshotRuntime.getUseRuntimeForSave());
        this.layoutRuntime = new LayoutRuntime(hangingProtocolSnapshotRuntime.layoutRuntime);
        this.layoutRuntime.setHangingSnapshot(this);
        if (hangingProtocolSnapshotRuntime.getConditionalHanging() != null) {
            this.setConditionalHanging(hangingProtocolSnapshotRuntime.getConditionalHanging().clone());
        }
        if (hangingProtocolSnapshotRuntime.getOrderHanging() != null) {
            this.setOrderHanging(hangingProtocolSnapshotRuntime.getOrderHanging().clone());
        }
        this.initedFromRuntime = true;
    }

    public void capture() {
        this.capture(true);
    }

    public void captureAfterHangup() {
        this.capture(false);
    }

    private void capture(boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug("capturing snapshot " + this.getName() + " of hanging " + this.getHangingDefinitionRuntime().getHangingProtocolRuntime().getVisibleName());
        }
        MainLayoutType mainLayoutType = JVision2.getMainFrame().getLytMode();
        LayoutRuntime layoutRuntime = this.captureLayout();
        if (bl) {
            this.captureDisplayStatesFromVis(layoutRuntime);
        } else {
            this.captureDisplayStatesFromHanging(layoutRuntime);
        }
        layoutRuntime.setType(mainLayoutType);
        layoutRuntime.setHangingSnapshot(this);
        this.layoutRuntime = layoutRuntime;
        this.setHangingApplied(true);
    }

    private LayoutRuntime captureLayout() {
        LayoutRuntime layoutRuntime = new LayoutRuntime(new Layout());
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        int n = 0;
        while (n < list.size()) {
            VisScreen2 visScreen2 = list.get(n);
            ScreenLayoutRuntime screenLayoutRuntime = visScreen2.captureScreenLayout();
            layoutRuntime.addScreenLayoutRuntime(screenLayoutRuntime);
            ++n;
        }
        return layoutRuntime;
    }

    private void captureDisplayStatesFromVis(LayoutRuntime layoutRuntime) {
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        ScreenLayoutRuntime[] screenLayoutRuntimeArray = layoutRuntime.screenLayouts();
        int n = Math.min(list.size(), screenLayoutRuntimeArray.length);
        int n2 = 0;
        while (n2 < n) {
            List<VisDisplay2> list2 = list.get(n2).getDisplays();
            DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntimeArray[n2].displayLayouts();
            int n3 = Math.min(list2.size(), displayLayoutRuntimeArray.length);
            int n4 = 0;
            while (n4 < n3) {
                list2.get(n4).captureDisplayState(displayLayoutRuntimeArray[n4]);
                ++n4;
            }
            ++n2;
        }
    }

    private void captureDisplayStatesFromHanging(LayoutRuntime layoutRuntime) {
        ScreenLayoutRuntime[] screenLayoutRuntimeArray = this.layoutRuntime.screenLayouts();
        ScreenLayoutRuntime[] screenLayoutRuntimeArray2 = layoutRuntime.screenLayouts();
        int n = Math.min(screenLayoutRuntimeArray.length, screenLayoutRuntimeArray2.length);
        int n2 = 0;
        while (n2 < n) {
            DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntimeArray[n2].displayLayouts();
            DisplayLayoutRuntime[] displayLayoutRuntimeArray2 = screenLayoutRuntimeArray2[n2].displayLayouts();
            int n3 = Math.min(displayLayoutRuntimeArray.length, displayLayoutRuntimeArray2.length);
            int n4 = 0;
            while (n4 < n3) {
                displayLayoutRuntimeArray2[n4].setDisplayState(displayLayoutRuntimeArray[n4].getDisplayState().clone());
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isInitedFromRuntime() {
        return this.initedFromRuntime;
    }

    @Override
    public LayoutRuntime getLayout() {
        return this.layoutRuntime;
    }

    @Override
    public ConditionalHanging getConditionalHanging() {
        return this.conditionalHanging;
    }

    @Override
    public OrderHanging getOrderHanging() {
        return this.orderHanging;
    }

    @Override
    public void setConditionalHanging(ConditionalHanging conditionalHanging) {
        this.conditionalHanging = conditionalHanging;
    }

    @Override
    public void setOrderHanging(OrderHanging orderHanging) {
        this.orderHanging = orderHanging;
    }

    public void setUseRuntimeForSave(boolean bl) {
        this.useRuntimeForSave = bl;
    }

    public boolean getUseRuntimeForSave() {
        return this.useRuntimeForSave;
    }

    public void setHangingDefinitionRuntime(HangingDefinitionRuntime hangingDefinitionRuntime) {
        this.hangingDefinitionRuntime = hangingDefinitionRuntime;
    }

    public HangingDefinitionRuntime getHangingDefinitionRuntime() {
        return this.hangingDefinitionRuntime;
    }

    public void setHangingApplied(boolean bl) {
        this.hangingApplied = bl;
    }

    public boolean isHangingApplied() {
        return this.hangingApplied;
    }

    public void setClearCachedDSAfterFirstUse(boolean bl) {
        this.clearCachedDSAfterFirstUse = bl;
    }

    public boolean getClearCachedDSAfterFirstUse() {
        return this.clearCachedDSAfterFirstUse;
    }

    public void clearDisplaySetInfos() {
        if (this.layoutRuntime != null) {
            ScreenLayoutRuntime[] screenLayoutRuntimeArray = this.layoutRuntime.screenLayouts();
            int n = screenLayoutRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenLayoutRuntime screenLayoutRuntime = screenLayoutRuntimeArray[n2];
                DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntime.displayLayouts();
                int n3 = displayLayoutRuntimeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DisplayLayoutRuntime displayLayoutRuntime = displayLayoutRuntimeArray[n4];
                    displayLayoutRuntime.setDisplaySet(null);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void setCacheDisplaySets(boolean bl) {
        this.cacheDisplaySets = bl;
    }

    public boolean getCacheDisplaySets() {
        return this.cacheDisplaySets;
    }
}

