/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.Orientation;
import com.tiani.jvision.main.DisplaySetType;
import com.tiani.util.expressions.BooleanExpression;
import com.tiani.util.expressions.IEvaluableData;

public class MammoCREvaluation {
    private static final ALogger LOGGER = ALogger.getLogger(MammoCREvaluation.class);
    private BooleanExpression mainSelector;
    private BooleanExpression leftSelector;
    private BooleanExpression rightSelector;
    private BooleanExpression mloSelector;
    private BooleanExpression ccSelector;
    private boolean correctlyInitialised;

    public static MammoCREvaluation getInstance() {
        return Singleton.instance;
    }

    private MammoCREvaluation() {
        if (LicenseManager.getInstance().isLicenseIDSupported("IMPAXEE_MAMMO")) {
            try {
                this.mainSelector = new BooleanExpression(Config.impaxee.plugins.MammoPlugin.Main.MammoMainSelector.get());
                this.leftSelector = new BooleanExpression(Config.impaxee.plugins.MammoPlugin.Main.MammoLeftSelector.get());
                this.rightSelector = new BooleanExpression(Config.impaxee.plugins.MammoPlugin.Main.MammoRightSelector.get());
                this.ccSelector = new BooleanExpression(Config.impaxee.plugins.MammoPlugin.Main.MammoCCSelector.get());
                this.mloSelector = new BooleanExpression(Config.impaxee.plugins.MammoPlugin.Main.MammoMLOSelector.get());
                this.correctlyInitialised = true;
            }
            catch (Exception exception) {
                LOGGER.error("Could not initialise MAMMO CR Configuration", (Throwable)exception);
            }
        } else {
            LOGGER.info("MAMMO2 License not available");
        }
    }

    public boolean isMammoImage(IEvaluableData iEvaluableData) {
        if (this.correctlyInitialised) {
            return this.mainSelector.evaluate(iEvaluableData);
        }
        return false;
    }

    public DisplaySetType getDisplaySetType(IEvaluableData iEvaluableData) {
        if (this.correctlyInitialised) {
            if (this.mloSelector.evaluate(iEvaluableData)) {
                return DisplaySetType.MLO;
            }
            if (this.ccSelector.evaluate(iEvaluableData)) {
                return DisplaySetType.CC;
            }
        }
        return DisplaySetType.NONE;
    }

    public Orientation getDisplaySetOrientation(IEvaluableData iEvaluableData) {
        if (this.correctlyInitialised) {
            if (this.rightSelector.evaluate(iEvaluableData)) {
                return Orientation.RIGHT;
            }
            if (this.leftSelector.evaluate(iEvaluableData)) {
                return Orientation.LEFT;
            }
        }
        return Orientation.UNKNOWN;
    }

    /* synthetic */ MammoCREvaluation(MammoCREvaluation mammoCREvaluation) {
        this();
    }

    private static class Singleton {
        static final MammoCREvaluation instance = new MammoCREvaluation(null);

        private Singleton() {
        }
    }
}

