/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.logging.ALogger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractHangingSnapshotModel
implements IHanging.SnapshotModel {
    private static final ALogger log = ALogger.getLogger(AbstractHangingSnapshotModel.class);
    private List<IHanging.SnapshotModel.Listener> listeners = new CopyOnWriteArrayList<IHanging.SnapshotModel.Listener>();
    private int lastSelected = -1;

    @Override
    public void select(int n) {
        if (this.lastSelected != n) {
            this.lastSelected = n;
            this.fireSelectionEvent(n);
        }
    }

    @Override
    public int getSelected() {
        return this.lastSelected;
    }

    @Override
    public void addListener(IHanging.SnapshotModel.Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IHanging.SnapshotModel.Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected synchronized void fireAddEvent(final int n, final AbstractSnapshotRuntime abstractSnapshotRuntime) {
        for (final IHanging.SnapshotModel.Listener listener : this.listeners) {
            this.executeInEventThread(new Runnable(){

                @Override
                public void run() {
                    listener.snapshotAdded(n, abstractSnapshotRuntime);
                }
            });
        }
    }

    protected synchronized void fireRemoveEvent(final int n) {
        for (final IHanging.SnapshotModel.Listener listener : this.listeners) {
            this.executeInEventThread(new Runnable(){

                @Override
                public void run() {
                    listener.snapshotRemoved(n);
                }
            });
        }
    }

    protected synchronized void fireUpdateEvent(final int n) {
        for (final IHanging.SnapshotModel.Listener listener : this.listeners) {
            this.executeInEventThread(new Runnable(){

                @Override
                public void run() {
                    listener.snapshotUpdated(n);
                }
            });
        }
    }

    protected synchronized void fireSelectionEvent(final int n) {
        for (final IHanging.SnapshotModel.Listener listener : this.listeners) {
            this.executeInEventThread(new Runnable(){

                @Override
                public void run() {
                    listener.snapshotSelected(n);
                }
            });
        }
    }

    private void executeInEventThread(Runnable runnable) {
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

