/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.IMPAXEELossyInstanceInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.Orientation;
import com.tiani.base.data.SliceDistanceCalculator;
import com.tiani.jvision.main.DisplaySetType;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractDisplaySet
implements IDisplaySet {
    private static final ALogger log = ALogger.getLogger(AbstractDisplaySet.class);
    protected static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    private static final IDicomCache cache = DicomCacheFactory.getInstance().getDicomCache();
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private final int id = idCounter.incrementAndGet();
    private ISplitAndSortRuntime decompositionRuntime;
    private AtomicInteger loaded = new AtomicInteger(0);
    private byte currentPriority = (byte)5;
    private boolean loadBySeries = false;
    private List<IFetchable> fetchables;
    private final List<IDisplaySet.ILoadStatusListener> listeners = new CopyOnWriteArrayList<IDisplaySet.ILoadStatusListener>();
    protected IFrameObjectData[] frameObjects;
    protected double[] relativeFrameLocations;
    private Set<ISeriesData> allSeriesCached = null;
    private String frameOfReferenceUID;
    private String studyIUID;
    private DisplaySetType type;
    private Orientation orientation;
    private ISUVData suvData;

    AbstractDisplaySet(ISplitAndSortRuntime iSplitAndSortRuntime) {
        this.decompositionRuntime = iSplitAndSortRuntime;
    }

    @Override
    public DisplaySetType getDisplaySetType() {
        if (this.type == null) {
            this.type = this.determineDisplaySetType();
        }
        return this.type;
    }

    @Override
    public Orientation getDisplaySetOrientation() {
        if (this.orientation == null) {
            IImageInformation iImageInformation = this.getOneObject().getImageInformation();
            this.orientation = Orientation.getOrientation(iImageInformation);
        }
        return this.orientation;
    }

    private DisplaySetType determineDisplaySetType() {
        IImageInformation iImageInformation = this.getOneObject().getImageInformation();
        Set<ImageType> set = iImageInformation.getImageType();
        if (iImageInformation.getImageClass() == IImageInformation.ImageClass.CT && set.contains(ImageType.PRIMARY) && set.contains(ImageType.ORIGINAL) && iImageInformation.getDataset().containsValue(0x180010)) {
            int n = this.countContrastSeriesBeforeThis();
            switch (n) {
                case 0: {
                    return DisplaySetType.CTA_ARTERIAL;
                }
                case 1: {
                    return DisplaySetType.CTA_PORTAL_VEIN;
                }
            }
            return DisplaySetType.CTA_VEIN;
        }
        return DisplaySetType.getDisplaySetType(iImageInformation);
    }

    private int countContrastSeriesBeforeThis() {
        int n = 0;
        IDisplaySet[] iDisplaySetArray = this.decompositionRuntime.getDisplaySets();
        int n2 = iDisplaySetArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n3];
            if (iDisplaySet == this) break;
            IFrameObjectData iFrameObjectData = iDisplaySet.getOneObject();
            IImageInformation iImageInformation = iFrameObjectData.getImageInformation();
            if (iImageInformation.getImageType().contains(ImageType.PRIMARY) && iImageInformation.getImageType().contains(ImageType.ORIGINAL) && iImageInformation.getDataset().containsValue(0x180010)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    @Override
    public String getFrameOfReferenceUID() {
        return this.frameOfReferenceUID;
    }

    private static boolean isCGETLoadable(IInstanceInfo iInstanceInfo) {
        if (iInstanceInfo == null) {
            return false;
        }
        return iInstanceInfo.getType().equals("CGET");
    }

    @Override
    public synchronized List<IFetchable> getLoadable() {
        if (this.fetchables == null) {
            return Collections.emptyList();
        }
        this.actualizeFetchables();
        return this.fetchables;
    }

    @Override
    public IStudyData getStudy() {
        IFrameObjectData iFrameObjectData = this.getOneObject();
        if (iFrameObjectData != null) {
            return iFrameObjectData.getParent().getParent();
        }
        return null;
    }

    @Override
    public boolean isLoadedBySeries() {
        return this.loadBySeries;
    }

    protected void init(IFrameObjectData[] iInstanceInfo) {
        Object object;
        IInstanceInfo iInstanceInfo2;
        int n;
        IDataObject iDataObject;
        int n2;
        Object object2;
        if (((IFrameObjectData[])iInstanceInfo).length > 50 && (object2 = iInstanceInfo[0]).getMainFrame().getFrameCount() == 1 && (n2 = (iDataObject = object2.getMainFrame().getParent()).getNumberOfFrames()) == ((IFrameObjectData[])iInstanceInfo).length && (n = iDataObject.getDicomObject().getInt(2101769, -1)) > 0 && ((IFrameObjectData[])iInstanceInfo).length == n && AbstractDisplaySet.isCGETLoadable(iInstanceInfo2 = object2.getMainFrame().getLoadableDataInfo().getInstanceInfo()) && !cache.hasDataset((String)(object = object2.getLoadableDataInfo().getStudyUID()), iInstanceInfo[40].getSOPInstanceUID())) {
            this.loadBySeries = true;
        }
        if (this.loadBySeries) {
            this.fetchables = new ArrayList<IFetchable>(2);
            this.fetchables.add(iInstanceInfo[0].getMainFrame().getParent());
        } else {
            object2 = new LinkedHashSet(((IFrameObjectData[])iInstanceInfo).length);
            iInstanceInfo2 = iInstanceInfo;
            n = ((IFrameObjectData[])iInstanceInfo2).length;
            n2 = 0;
            while (n2 < n) {
                iDataObject = iInstanceInfo2[n2];
                object = iDataObject.getMainFrame();
                if (!fetcher.isIgnoredSOPClass(object.getSOPClassUID())) {
                    IObjectInfo iObjectInfo;
                    if (object.isPrefetchingLossyImageEnabled() && ((iObjectInfo = (IObjectInfo)object.getQueryObject()).getInstanceInfo().getType().contains("WADO") || IMPAXEELossyInstanceInfo.singleton.equals(iObjectInfo.getInstanceInfo())) && iDataObject.setLossyFetching()) {
                        iObjectInfo.setInstanceInfo((IInstanceInfo)IMPAXEELossyInstanceInfo.singleton);
                    }
                    ((HashSet)object2).add(object);
                }
                ++n2;
            }
            this.fetchables = new ArrayList<IFetchable>((Collection<IFetchable>)object2);
        }
        if (((IFrameObjectData[])iInstanceInfo).length > 0) {
            this.frameOfReferenceUID = iInstanceInfo[0].getImageInformation().getFrameOfReferenceUID();
            this.studyIUID = iInstanceInfo[0].getImageInformation().getStudyInstanceUID();
            this.relativeFrameLocations = this.calculateAbsoluteDistances((IFrameObjectData[])iInstanceInfo);
            if (this.relativeFrameLocations != null && iInstanceInfo[0].getImageInformation().getSliceThickness() == null) {
                int n3 = 0;
                while (n3 < ((IInstanceInfo)iInstanceInfo).length - 1) {
                    iInstanceInfo[n3].getImageInformation().setSliceThickness(this.getSliceDistance(n3));
                    ++n3;
                }
            }
        }
    }

    @Override
    public boolean hasLocationInformation() {
        return this.relativeFrameLocations != null;
    }

    @Override
    public SliceDistanceCalculator.SliceDistanceType getUniqueSliceDistances(double[] dArray, double d) {
        return SliceDistanceCalculator.getUniqueSliceDistances(this.relativeFrameLocations, dArray, d);
    }

    @Override
    public double getRelativeSliceLocation(int n) {
        if (this.relativeFrameLocations != null) {
            return this.relativeFrameLocations[n];
        }
        return -1.0;
    }

    @Override
    public double getSliceDistance(int n) {
        if (n == 0) {
            return Math.abs(this.relativeFrameLocations[0] - this.relativeFrameLocations[1]);
        }
        if (n == this.getFrameCount() - 1) {
            return Math.abs(this.relativeFrameLocations[n - 1] - this.relativeFrameLocations[n]);
        }
        return (Math.abs(this.relativeFrameLocations[n] - this.relativeFrameLocations[n - 1]) + Math.abs(this.relativeFrameLocations[n] - this.relativeFrameLocations[n + 1])) / 2.0;
    }

    private double[] calculateAbsoluteDistances(IFrameObjectData[] iFrameObjectDataArray) {
        double[] dArray = null;
        double d = Double.MAX_VALUE;
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        while (n < iFrameObjectDataArray.length) {
            IImageInformation iImageInformation = iFrameObjectDataArray[n].getImageInformation();
            if (iImageInformation == null) {
                return null;
            }
            double[] dArray2 = iImageInformation.getImagePosition();
            if (dArray2 == null || dArray2.length != 3) {
                bl = false;
                break;
            }
            ++n;
        }
        if (!bl) {
            bl2 = true;
            n = 0;
            while (n < iFrameObjectDataArray.length) {
                if (!iFrameObjectDataArray[n].getDicomObject().containsValue(2101313)) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
        }
        dArray = new double[this.getFrameCount()];
        if (bl) {
            n = 1;
            int n2 = 0;
            while (n2 < iFrameObjectDataArray.length) {
                if (!iFrameObjectDataArray[n2].getImageInformation().getImageType().contains(ImageType.LOCALIZER) && !iFrameObjectDataArray[n2].getImageInformation().getImageType().contains(ImageType.SCOUT)) break;
                ++n2;
            }
            if (n2 == iFrameObjectDataArray.length) {
                return null;
            }
            double[] dArray3 = iFrameObjectDataArray[n2].getImageInformation().getImagePosition();
            int n3 = 0;
            while (n3 < iFrameObjectDataArray.length) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n3];
                double[] dArray4 = iFrameObjectData.getImageInformation().getImagePosition();
                dArray[n3] = Math.sqrt((dArray4[0] - dArray3[0]) * (dArray4[0] - dArray3[0]) + (dArray4[1] - dArray3[1]) * (dArray4[1] - dArray3[1]) + (dArray4[2] - dArray3[2]) * (dArray4[2] - dArray3[2]));
                if (dArray[n3] != 0.0) {
                    n = 0;
                }
                ++n3;
            }
            if (n != 0) {
                return null;
            }
            return dArray;
        }
        if (bl2) {
            try {
                n = 0;
                while (n < iFrameObjectDataArray.length) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n];
                    dArray[n] = iFrameObjectData.getImageInformation().getSliceLocation();
                    if (dArray[n] < d) {
                        d = dArray[n];
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                log.warn("Slice location not available.", (Throwable)exception);
                return null;
            }
        }
        if (bl2) {
            n = 0;
            while (n < this.getFrameCount()) {
                int n4 = n++;
                dArray[n4] = dArray[n4] - d;
            }
            return dArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void actualizeFetchables() {
        if (this.fetchables.isEmpty()) return;
        DataFlavor dataFlavor = AbstractDisplaySet.dataFlavor;
        // MONITORENTER : dataFlavor
        // MONITOREXIT : dataFlavor
        Iterator<IFetchable> iterator = this.fetchables.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isStartedBeingLoaded()) continue;
            iterator.remove();
        }
    }

    @Override
    public IFrameObjectData getOneObject() {
        IFrameObjectData[] iFrameObjectDataArray = this.getObjects();
        if (iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0) {
            int n = iFrameObjectDataArray.length;
            return iFrameObjectDataArray[n > 2 ? 2 : 0];
        }
        return null;
    }

    @Override
    public int getFrameCount() {
        IFrameObjectData[] iFrameObjectDataArray = this.getObjects();
        return iFrameObjectDataArray != null ? iFrameObjectDataArray.length : 0;
    }

    @Override
    public boolean isLossyData() {
        IFrameObjectData[] iFrameObjectDataArray = this.getObjects();
        if (iFrameObjectDataArray != null) {
            IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
                if (iFrameObjectData.isLossyData()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isFilterMarkedEnabled() {
        return false;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getStudyUID() {
        return this.studyIUID;
    }

    @Override
    public void decrementLoadCount() {
        if (this.loaded.decrementAndGet() == 0) {
            this.notifyListeners();
        }
    }

    @Override
    public boolean isBeingLoaded() {
        return true;
    }

    @Override
    public boolean isBeingLossyPrefetched() {
        IFrameObjectData[] iFrameObjectDataArray = this.getObjects();
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
            if (iFrameObjectData.isBeingLossyPrefetched()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public synchronized void cancelRetrieve() {
        this.actualizeFetchables();
        if (!this.fetchables.isEmpty()) {
            fetcher.removeDatas(this.fetchables);
        }
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (!iSeriesData.isSecondaryCapture() || iSeriesData.isSecondaryCaptureSaved()) continue;
            iSeriesData.setSecondaryCaptureSaved(true);
        }
    }

    @Override
    public void incrementLoadCount() {
        if (this.loaded.incrementAndGet() == 1) {
            this.higherPriorize();
            this.notifyListeners();
        }
    }

    @Override
    public synchronized void setIsActive(boolean bl, boolean bl2) {
        byte by;
        byte by2 = by = bl ? (byte)2 : 4;
        if (bl && bl2) {
            by = 1;
        }
        if (this.currentPriority == by) {
            return;
        }
        this.currentPriority = by;
        if (this.loadBySeries || bl2) {
            this.actualizeFetchables();
            if (this.fetchables.isEmpty()) {
                return;
            }
            List<IFetchable> list = this.fetchables;
            if (bl2) {
                list = new ArrayList<IFetchable>(this.fetchables);
                Collections.reverse(list);
            }
            fetcher.changePriorityIfExists(list, this.currentPriority);
        }
    }

    private synchronized void higherPriorize() {
        this.actualizeFetchables();
        int n = this.fetchables.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        ArrayList<IFetchable> arrayList = new ArrayList<IFetchable>(16);
        ArrayList<IFetchable> arrayList2 = new ArrayList<IFetchable>(64);
        boolean bl = !this.loadBySeries && n > 300;
        int n3 = VisDisplayData.getKeyFrameDistance(n);
        int n4 = n - 1;
        while (n4 >= 0) {
            if (bl) {
                if (n2 % n3 == 0) {
                    arrayList.add(this.fetchables.get(n4));
                } else {
                    arrayList2.add(this.fetchables.get(n4));
                }
            } else {
                arrayList2.add(this.fetchables.get(n4));
            }
            ++n2;
            --n4;
        }
        if (!arrayList.isEmpty()) {
            fetcher.changeToHigherPriorityIfExists(arrayList, (byte)3);
        }
        if (!arrayList2.isEmpty()) {
            fetcher.changeToHigherPriorityIfExists(arrayList2, (byte)4);
        }
    }

    @Override
    public boolean isDisplayedInImageArea() {
        return this.loaded.get() > 0;
    }

    @Override
    public void addLoadStatusListener(IDisplaySet.ILoadStatusListener iLoadStatusListener) {
        this.listeners.add(iLoadStatusListener);
    }

    @Override
    public void removeLoadStatusListener(IDisplaySet.ILoadStatusListener iLoadStatusListener) {
        this.listeners.remove(iLoadStatusListener);
    }

    private void notifyListeners() {
        for (IDisplaySet.ILoadStatusListener iLoadStatusListener : this.listeners) {
            iLoadStatusListener.notifyLoadStatusChange();
        }
    }

    @Override
    public ISplitAndSortRuntime getSplitAndSortRuntime() {
        return this.decompositionRuntime;
    }

    private Collection<ISeriesData> getSeriesData() {
        if (this.allSeriesCached != null) {
            return this.allSeriesCached;
        }
        this.allSeriesCached = new HashSet<ISeriesData>();
        IFrameObjectData[] iFrameObjectDataArray = this.getObjects();
        if (iFrameObjectDataArray != null) {
            IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
                this.allSeriesCached.add(iFrameObjectData.getParent());
                ++n2;
            }
        }
        return this.allSeriesCached;
    }

    @Override
    public boolean isSecondaryCaptureSaved() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (iSeriesData.isSecondaryCaptureSaved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSecondaryCapture() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (!iSeriesData.isSecondaryCapture()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSetLiveSecondaryCapture() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (!iSeriesData.isSetLiveSecondaryCapture()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSecondaryCaptureSaved(boolean bl) {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            iSeriesData.setSecondaryCaptureSaved(bl);
        }
    }

    @Override
    public void setSecondaryCapture() {
    }

    @Override
    public void setSetLiveSecondaryCapture() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            iSeriesData.setSetLiveSecondaryCapture();
        }
    }

    @Override
    public void setSUVData(ISUVData iSUVData) {
        this.suvData = iSUVData;
    }

    @Override
    public ISUVData getSUVData() {
        return this.suvData;
    }
}

