/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationHandler;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.IActivationStateTreeListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotSettingsPanel;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.ILayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHangingScreen;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.tiani.jvision.plugin.PluginName;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class SnapshotTreeNode
extends ActivationStateTreeNode
implements IHangingProtocolManipulationListener,
IActivationStateTreeListener {
    private SnapshotSettingsPanel snapshotSettingsPanel;
    private ISnapshotDefinition snapshot;
    private ConditionalHanging conditionalHanging;
    private OrderHanging orderHanging;
    private boolean isOrderHanging;
    private Window parentWindow;
    private HangingProtocolManipulationHandler hangingProtocolManipulationHandler;
    private boolean addToParentFinished = false;

    public SnapshotTreeNode(Window window, IHangingProtocolDefinition iHangingProtocolDefinition, ISnapshotDefinition iSnapshotDefinition, HangingProtocolManipulationHandler hangingProtocolManipulationHandler, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        this.snapshot = iSnapshotDefinition;
        this.parentWindow = window;
        this.hangingProtocolManipulationHandler = hangingProtocolManipulationHandler;
        this.hangingProtocolManipulationHandler.registerListener(this);
        this.conditionalHanging = iSnapshotDefinition.getConditionalHanging();
        if (this.conditionalHanging != null) {
            this.isOrderHanging = false;
        } else {
            this.conditionalHanging = new ConditionalHanging();
            iSnapshotDefinition.setConditionalHanging(this.conditionalHanging);
            this.isOrderHanging = true;
        }
        this.orderHanging = iSnapshotDefinition.getOrderHanging();
        if (this.orderHanging == null) {
            this.orderHanging = new OrderHanging();
            iSnapshotDefinition.setOrderHanging(this.orderHanging);
        }
        ILayoutDefinition iLayoutDefinition = iSnapshotDefinition.getLayout();
        IScreenLayoutDefinition[] iScreenLayoutDefinitionArray = iLayoutDefinition.screenLayouts();
        int n = 0;
        while (n < iScreenLayoutDefinitionArray.length) {
            ConditionalHangingScreen conditionalHangingScreen;
            IScreenLayoutDefinition iScreenLayoutDefinition = iScreenLayoutDefinitionArray[n];
            OrderHangingScreen orderHangingScreen = this.orderHanging.getOrderHangingScreen(n);
            if (orderHangingScreen == null) {
                orderHangingScreen = new OrderHangingScreen();
                this.orderHanging.addOrderHangingScreen(orderHangingScreen);
            }
            if ((conditionalHangingScreen = this.conditionalHanging.getConditionalHangingScreen(n)) == null) {
                conditionalHangingScreen = new ConditionalHangingScreen();
                this.conditionalHanging.addConditionalHangingScreen(conditionalHangingScreen);
            }
            ScreenTreeNode screenTreeNode = new ScreenTreeNode(window, iSnapshotDefinition.getLayout().getType(), iScreenLayoutDefinition, orderHangingScreen, conditionalHangingScreen, this.isOrderHanging, n + 1, hangingProtocolManipulationHandler, iComponentFactory);
            this.add(screenTreeNode);
            screenTreeNode.addActivationStateTreeListener(this);
            ++n;
        }
        this.snapshotSettingsPanel = new SnapshotSettingsPanel(iHangingProtocolDefinition, iSnapshotDefinition, this.isOrderHanging, hangingProtocolManipulationHandler, iComponentFactory);
        this.snapshotSettingsPanel.setOwner(this);
    }

    public SnapshotSettingsPanel getSnapshotSettingsPanel() {
        return this.snapshotSettingsPanel;
    }

    @Override
    public String toString() {
        boolean bl = false;
        if (this.snapshot instanceof HangingProtocolSnapshotRuntime) {
            bl = ((HangingProtocolSnapshotRuntime)this.snapshot).isInitedFromRuntime();
        }
        return String.valueOf(Messages.getString("HangingDefinitionConfigurationSavePanel.Snapshot")) + (bl ? "*" : "") + ": " + this.snapshot.getName();
    }

    @Override
    public JPanel getPanel() {
        return this.snapshotSettingsPanel;
    }

    public void screenLayoutTypeChanged(MainLayoutType mainLayoutType) {
        int n = 0;
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof ScreenTreeNode)) continue;
                if (mainLayoutType != MainLayoutType.variable && n > 0) {
                    ((ScreenTreeNode)e).setActive(false);
                } else {
                    ((ScreenTreeNode)e).setActive(true);
                }
                ((ScreenTreeNode)e).screenLayoutTypeChanged(mainLayoutType);
                ++n;
                if (this.model == null) continue;
                this.model.nodeChanged((TreeNode)e);
            }
        }
    }

    public void kindOfHangingChanged(boolean bl) {
        if (this.isOrderHanging != bl) {
            if (this.children != null) {
                for (Object e : this.children) {
                    if (!(e instanceof ScreenTreeNode)) continue;
                    ((ScreenTreeNode)e).kindOfHangingChanged(bl);
                }
            }
            this.isOrderHanging = bl;
        }
    }

    public String getSnapshotName() {
        return this.snapshot.getName();
    }

    public void addScreen(MainLayoutType mainLayoutType, IScreenLayoutDefinition iScreenLayoutDefinition, IComponentFactory iComponentFactory) {
        OrderHangingScreen orderHangingScreen = new OrderHangingScreen();
        ConditionalHangingScreen conditionalHangingScreen = new ConditionalHangingScreen();
        this.orderHanging.addOrderHangingScreen(orderHangingScreen);
        this.conditionalHanging.addConditionalHangingScreen(conditionalHangingScreen);
        ScreenTreeNode screenTreeNode = new ScreenTreeNode(this.parentWindow, mainLayoutType, iScreenLayoutDefinition, orderHangingScreen, conditionalHangingScreen, this.isOrderHanging, this.getChildCount() + 1, this.hangingProtocolManipulationHandler, iComponentFactory);
        screenTreeNode.setModel(this.model);
        screenTreeNode.addDisplay(mainLayoutType, "1x1", PluginName.DEFAULT.getPluginName());
        this.model.insertNodeInto(screenTreeNode, this, this.getChildCount());
        screenTreeNode.addActivationStateTreeListener(this);
    }

    public ISnapshotDefinition getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void activationChanged(ActivationStateTreeNode activationStateTreeNode) {
        if (activationStateTreeNode instanceof ScreenTreeNode) {
            for (Object e : this.children) {
                if (e != activationStateTreeNode) continue;
                if (!activationStateTreeNode.isActive()) {
                    this.orderHanging.removeOrderHangingScreen(((ScreenTreeNode)activationStateTreeNode).getOrderScreen());
                    this.conditionalHanging.removeConditionalHangingScreen(((ScreenTreeNode)activationStateTreeNode).getConditionalHangingScreen());
                    this.snapshot.getLayout().removeScreenLayout(((ScreenTreeNode)activationStateTreeNode).getScreenLayout());
                    continue;
                }
                this.orderHanging.addOrderHangingScreen(((ScreenTreeNode)activationStateTreeNode).getOrderScreen());
                this.conditionalHanging.addConditionalHangingScreen(((ScreenTreeNode)activationStateTreeNode).getConditionalHangingScreen());
                this.snapshot.getLayout().appendScreenLayout(((ScreenTreeNode)activationStateTreeNode).getScreenLayout());
            }
        }
    }

    @Override
    public void hangingChanged() {
        if (this.addToParentFinished) {
            this.model.nodeChanged(this);
        }
    }

    public void setAddToParentFinished(boolean bl) {
        this.addToParentFinished = bl;
    }
}

