/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotTreeNode;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class SnapshotSettingsPanel
extends JPanel {
    private JToggleButton filmLayoutButton;
    private JToggleButton stripeLayoutButton;
    private JToggleButton variableLayoutButton;
    private JRadioButton radioButtonOrderHanging;
    private JRadioButton radioButtonConditionalHanging;
    private JCheckBox checkBoxMultipleHangupPossible;
    private JCheckBox checkBoxFillEmptyDisplays;
    private JCheckBox checkBoxStartQuadrantViewing;
    private JCheckBox checkBoxInverseOrder;
    private JTextField textFieldSnapshotName;
    private final Icon iconFilmLayout;
    private final Icon iconStripeLayout;
    private final Icon iconVariableLayout;
    private ButtonGroup buttonGroupScreenLayout;
    private ButtonGroup buttonGroupKindOfHanging;
    private SnapshotTreeNode owner;
    private IHangingProtocolManipulationListener hangingProtocolManipulationListener;
    private ISnapshotDefinition snapshot;
    private OrderHanging orderHanging;
    private ConditionalHanging conditionalHanging;

    public SnapshotSettingsPanel(final IHangingProtocolDefinition iHangingProtocolDefinition, ISnapshotDefinition iSnapshotDefinition, boolean bl, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IComponentFactory iComponentFactory) {
        this.snapshot = iSnapshotDefinition;
        this.orderHanging = iSnapshotDefinition.getOrderHanging();
        this.conditionalHanging = iSnapshotDefinition.getConditionalHanging();
        this.hangingProtocolManipulationListener = iHangingProtocolManipulationListener;
        this.setBorder(iComponentFactory.createTitledBorder(Messages.getString("SnapshotSettingsPanel.SnapshotSettings")));
        this.setLayout(new FlowLayout(0));
        this.setOpaque(false);
        JPanel jPanel = ComponentFactory.instance.createPanel();
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new GridBagLayout());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.textFieldSnapshotName = iComponentFactory.createTextField(iSnapshotDefinition.getName());
        this.textFieldSnapshotName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = SnapshotSettingsPanel.this.textFieldSnapshotName.getText();
                String string2 = SnapshotSettingsPanel.this.snapshot.getName();
                if (!iHangingProtocolDefinition.isUniqueSnapshotName(string, SnapshotSettingsPanel.this.snapshot)) {
                    Message.warning(Messages.getString("SnapshotSettingsPanel.ErrorTitleAmbiguousSnapshotName"), Messages.getString("SnapshotSettingsPanel.ErrorMessageAmbiguousSnapshotName"));
                    SnapshotSettingsPanel.this.textFieldSnapshotName.setText(string2);
                } else if (!string.equals(string2)) {
                    SnapshotSettingsPanel.this.snapshot.setName(string);
                    SnapshotSettingsPanel.this.hangingProtocolManipulationListener.hangingChanged();
                }
            }
        });
        IAIconFactory iAIconFactory = new IAIconFactory(iComponentFactory, 32);
        this.iconFilmLayout = iAIconFactory.loadIcon("layout_type_film.svg");
        this.iconStripeLayout = iAIconFactory.loadIcon("layout_type_stripe.svg");
        this.iconVariableLayout = iAIconFactory.loadIcon("layout_type_variable.svg");
        this.filmLayoutButton = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.iconFilmLayout);
        this.stripeLayoutButton = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.iconStripeLayout);
        this.variableLayoutButton = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.iconVariableLayout);
        this.radioButtonConditionalHanging = iComponentFactory.createRadioButton(Messages.getString("SnapshotSettingsPanel.ConditionalHanging"));
        this.radioButtonOrderHanging = iComponentFactory.createRadioButton(Messages.getString("SnapshotSettingsPanel.OrderHanging"));
        this.radioButtonConditionalHanging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SnapshotSettingsPanel.this.snapshot.getConditionalHanging() != SnapshotSettingsPanel.this.conditionalHanging) {
                    SnapshotSettingsPanel.this.snapshot.setConditionalHanging(SnapshotSettingsPanel.this.conditionalHanging);
                    SnapshotSettingsPanel.this.snapshot.setOrderHanging(null);
                    SnapshotSettingsPanel.this.informListener();
                    SnapshotSettingsPanel.this.owner.kindOfHangingChanged(false);
                    SnapshotSettingsPanel.this.checkBoxInverseOrder.setVisible(false);
                    SnapshotSettingsPanel.this.checkBoxMultipleHangupPossible.setVisible(true);
                    SnapshotSettingsPanel.this.checkBoxFillEmptyDisplays.setVisible(true);
                }
            }
        });
        this.radioButtonOrderHanging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SnapshotSettingsPanel.this.snapshot.getOrderHanging() != SnapshotSettingsPanel.this.orderHanging) {
                    SnapshotSettingsPanel.this.snapshot.setConditionalHanging(null);
                    SnapshotSettingsPanel.this.snapshot.setOrderHanging(SnapshotSettingsPanel.this.orderHanging);
                    SnapshotSettingsPanel.this.informListener();
                    SnapshotSettingsPanel.this.owner.kindOfHangingChanged(true);
                    SnapshotSettingsPanel.this.checkBoxInverseOrder.setVisible(true);
                    SnapshotSettingsPanel.this.checkBoxMultipleHangupPossible.setVisible(false);
                    SnapshotSettingsPanel.this.checkBoxFillEmptyDisplays.setVisible(false);
                }
            }
        });
        this.checkBoxInverseOrder = iComponentFactory.createCheckBox(Messages.getString("SnapshotSettingsPanel.InverseOrder"));
        this.checkBoxInverseOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl = SnapshotSettingsPanel.this.orderHanging.getIsReverseDisplayOrder();
                Boolean bl2 = SnapshotSettingsPanel.this.checkBoxInverseOrder.isSelected();
                if (!bl2.equals(bl)) {
                    SnapshotSettingsPanel.this.orderHanging.setIsReverseDisplayOrder(bl2);
                    SnapshotSettingsPanel.this.informListener();
                }
            }
        });
        this.checkBoxMultipleHangupPossible = iComponentFactory.createCheckBox(Messages.getString("SnapshotSettingsPanel.DSMultipleTimes"));
        this.checkBoxMultipleHangupPossible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl = SnapshotSettingsPanel.this.conditionalHanging.getMultipleHangupPossible();
                Boolean bl2 = SnapshotSettingsPanel.this.checkBoxMultipleHangupPossible.isSelected();
                if (!bl2.equals(bl)) {
                    SnapshotSettingsPanel.this.conditionalHanging.setMultipleHangupPossible(bl2);
                    SnapshotSettingsPanel.this.informListener();
                }
            }
        });
        this.checkBoxFillEmptyDisplays = iComponentFactory.createCheckBox(Messages.getString("SnapshotSettingsPanel.FillEmptyDisplays"));
        this.checkBoxFillEmptyDisplays.setToolTipText(Messages.getString("SnapshotSettingsPanel.FillEmptyDisplays.Tooltip"));
        this.checkBoxFillEmptyDisplays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl = SnapshotSettingsPanel.this.conditionalHanging.getFillEmptyDisplays();
                Boolean bl2 = SnapshotSettingsPanel.this.checkBoxFillEmptyDisplays.isSelected();
                if (!bl2.equals(bl)) {
                    SnapshotSettingsPanel.this.conditionalHanging.setFillEmptyDisplays(bl2);
                    SnapshotSettingsPanel.this.informListener();
                }
            }
        });
        this.checkBoxStartQuadrantViewing = iComponentFactory.createCheckBox(Messages.getString("SnapshotSettingsPanel.StartQuadrantViewing.Label"), Messages.getString("SnapshotSettingsPanel.StartQuadrantViewing.ToolTip"), this.conditionalHanging.getStartQuadrantViewing());
        this.checkBoxStartQuadrantViewing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl = SnapshotSettingsPanel.this.conditionalHanging.getStartQuadrantViewing();
                Boolean bl2 = SnapshotSettingsPanel.this.checkBoxStartQuadrantViewing.isSelected();
                if (!bl2.equals(bl)) {
                    SnapshotSettingsPanel.this.conditionalHanging.setStartQuadrantViewing(bl2);
                    SnapshotSettingsPanel.this.informListener();
                }
            }
        });
        this.filmLayoutButton.setToolTipText(Messages.getString("SnapshotSettingsPanel.FilmLayout"));
        this.stripeLayoutButton.setToolTipText(Messages.getString("SnapshotSettingsPanel.StripeLayout"));
        this.variableLayoutButton.setToolTipText(Messages.getString("SnapshotSettingsPanel.VariableLayout"));
        this.filmLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotSettingsPanel.this.setMainLayout(MainLayoutType.film);
            }
        });
        this.stripeLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotSettingsPanel.this.setMainLayout(MainLayoutType.stripe);
            }
        });
        this.variableLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotSettingsPanel.this.setMainLayout(MainLayoutType.variable);
            }
        });
        this.buttonGroupScreenLayout = new ButtonGroup();
        this.buttonGroupKindOfHanging = new ButtonGroup();
        this.buttonGroupKindOfHanging.add(this.radioButtonConditionalHanging);
        this.buttonGroupKindOfHanging.add(this.radioButtonOrderHanging);
        this.buttonGroupScreenLayout.add(this.filmLayoutButton);
        this.buttonGroupScreenLayout.add(this.stripeLayoutButton);
        this.buttonGroupScreenLayout.add(this.variableLayoutButton);
        jPanel.add(this.filmLayoutButton);
        jPanel.add(this.stripeLayoutButton);
        jPanel.add(this.variableLayoutButton);
        if (iSnapshotDefinition.getLayout().getType() == MainLayoutType.film) {
            this.filmLayoutButton.setSelected(true);
        } else if (iSnapshotDefinition.getLayout().getType() == MainLayoutType.stripe) {
            this.stripeLayoutButton.setSelected(true);
        } else {
            this.variableLayoutButton.setSelected(true);
        }
        jPanel2.add((Component)iComponentFactory.createLabel("Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("SnapshotSettingsPanel.LayoutType")) + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("SnapshotSettingsPanel.KindOfHanging")) + ":"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.checkBoxInverseOrder, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.checkBoxMultipleHangupPossible, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.checkBoxFillEmptyDisplays, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.checkBoxStartQuadrantViewing, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.textFieldSnapshotName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.radioButtonConditionalHanging, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.radioButtonOrderHanging, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (!bl) {
            this.radioButtonConditionalHanging.setSelected(true);
            this.checkBoxInverseOrder.setVisible(false);
            this.checkBoxMultipleHangupPossible.setVisible(true);
            this.checkBoxMultipleHangupPossible.setSelected(iSnapshotDefinition.getConditionalHanging().getMultipleHangupPossible());
            this.checkBoxFillEmptyDisplays.setVisible(true);
            this.checkBoxFillEmptyDisplays.setSelected(iSnapshotDefinition.getConditionalHanging().getFillEmptyDisplays());
            this.checkBoxStartQuadrantViewing.setSelected(iSnapshotDefinition.getConditionalHanging().getStartQuadrantViewing());
            iSnapshotDefinition.setOrderHanging(null);
        } else {
            this.radioButtonOrderHanging.setSelected(true);
            this.checkBoxMultipleHangupPossible.setVisible(false);
            this.checkBoxFillEmptyDisplays.setVisible(false);
            this.checkBoxInverseOrder.setSelected(iSnapshotDefinition.getOrderHanging().getIsReverseDisplayOrder());
            iSnapshotDefinition.setConditionalHanging(null);
        }
        this.add(jPanel2);
    }

    static JToggleButton createToggleButtonWithScaledIcon(IComponentFactory iComponentFactory, Icon icon) {
        JToggleButton jToggleButton = iComponentFactory.createToggleButton(null);
        jToggleButton.setIcon(icon);
        return jToggleButton;
    }

    public void setOwner(SnapshotTreeNode snapshotTreeNode) {
        this.owner = snapshotTreeNode;
    }

    public MainLayoutType getScreenLayoutType() {
        if (this.filmLayoutButton.isSelected()) {
            return MainLayoutType.film;
        }
        if (this.stripeLayoutButton.isSelected()) {
            return MainLayoutType.stripe;
        }
        return MainLayoutType.variable;
    }

    public boolean isConditionalHanging() {
        return this.radioButtonConditionalHanging.isSelected();
    }

    public Boolean isReverseDisplayOrder() {
        return this.checkBoxInverseOrder.isSelected();
    }

    private void informListener() {
        if (this.hangingProtocolManipulationListener != null) {
            this.hangingProtocolManipulationListener.hangingChanged();
        }
    }

    private void setMainLayout(MainLayoutType mainLayoutType) {
        if (this.snapshot.getLayout().getType() != mainLayoutType) {
            if (this.owner != null) {
                this.owner.screenLayoutTypeChanged(mainLayoutType);
            }
            this.snapshot.getLayout().setType(mainLayoutType);
            this.informListener();
        }
    }
}

