/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.ui.DropDownButton;
import com.agfa.pacs.impaxee.actions.ui.LayoutChooserPopupMenu;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.IActivationStateTreeListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotSettingsPanel;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.OrderHangingScreenStartDSStrategy;
import com.agfa.pacs.impaxee.hanging.model.enums.VariableLayout;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHangingScreen;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.tools.CompareUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ScreenSettingsPanel
extends JPanel
implements IActivationStateTreeListener {
    private JToggleButton[] stripeLayoutButtons;
    private JToggleButton[] stripeLayoutColsButtons;
    private JToggleButton[] variableLayoutButtons;
    private DropDownButton variableLayoutDropdown;
    private JComboBox orderHangingComboBox;
    private ScreenTreeNode owner;
    private final Icon[] stripeLayoutIcons;
    private final Icon[] stripeLayoutColsIcons;
    private final Icon[] variableLayoutIcons;
    private static VariableLayout[] variableLayouts = new VariableLayout[]{VariableLayout.LAYOUT_1x1, VariableLayout.LAYOUT_1x2, VariableLayout.LAYOUT_2x1, VariableLayout.LAYOUT_1plus2, VariableLayout.LAYOUT_2plus1, VariableLayout.LAYOUT_2x2};
    private static String[] stripeLayouts = new String[]{"1x1", "1x2", "1x3", "1x4", "1x5", "1x6", "1x7", "1x8"};
    private static String[] stripeCols = new String[]{"1x1", "2x1", "3x1", "4x1", "5x1", "6x1", "7x1", "8x1"};
    private static String[] oldStripeLayouts = new String[]{"1x1", "2x1", "3x1", "4x1", "5x1", "6x1", "7x1", "8x1"};
    private static String[] oldStripeCols = new String[]{"1x1", "1x2", "1x3", "1x4", "1x5", "1x6", "1x7", "1x8"};
    private ButtonGroup buttonGroupStripeLayout;
    private ButtonGroup buttonGroupStripeCols;
    private ButtonGroup buttonGroupVariableLayout;
    private IScreenLayoutDefinition screenLayout;
    private JPanel panelStripeLayoutButtons;
    private JPanel panelStripeColsButtons;
    private JPanel panelVariableLayoutButtons;
    private MainLayoutType currentScreenLayoutType;
    private JLabel labelStripeScreenLayout;
    private JLabel labelStripeDisplayLayout;
    private JLabel labelVariableScreenLayout;
    private static OrderHangingScreenStartDSStrategyWrapper[] orderHangingScreenStartDSStrategies = new OrderHangingScreenStartDSStrategyWrapper[]{new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.CURRENT_DISPLAY_SET), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.CURRENT_STUDY), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.BASE_STUDY), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.FIRST_PRIOR), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.SECOND_PRIOR), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.THIRD_PRIOR), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.FOURTH_PRIOR), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.FIFTH_PRIOR), new OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy.OLDEST_PRIOR)};
    private JLabel labelOrderHanging;
    private IHangingProtocolManipulationListener imageHangingChangeListener;
    private Boolean isOrderHanging;
    private OrderHangingScreen orderHangingScreen;

    public ScreenSettingsPanel(ISnapshotDefinition iSnapshotDefinition, IScreenLayoutDefinition iScreenLayoutDefinition, OrderHangingScreen orderHangingScreen, boolean bl, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IComponentFactory iComponentFactory) {
        this(iSnapshotDefinition.getLayout().getType(), iScreenLayoutDefinition, orderHangingScreen, bl, iHangingProtocolManipulationListener, iComponentFactory);
    }

    public ScreenSettingsPanel(MainLayoutType mainLayoutType, IScreenLayoutDefinition iScreenLayoutDefinition, OrderHangingScreen orderHangingScreen, boolean bl, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IComponentFactory iComponentFactory) {
        this.screenLayout = iScreenLayoutDefinition;
        this.orderHangingScreen = orderHangingScreen;
        this.imageHangingChangeListener = iHangingProtocolManipulationListener;
        this.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ScreenSettingsPanel.ScreenSettings")));
        this.setLayout(new FlowLayout(0));
        this.setOpaque(false);
        JPanel jPanel = ComponentFactory.instance.createPanel(new GridBagLayout());
        this.panelStripeLayoutButtons = ComponentFactory.instance.createPanel();
        this.panelStripeColsButtons = ComponentFactory.instance.createPanel();
        this.panelVariableLayoutButtons = ComponentFactory.instance.createPanel();
        this.panelStripeLayoutButtons.setLayout(new BoxLayout(this.panelStripeLayoutButtons, 0));
        this.panelStripeColsButtons.setLayout(new BoxLayout(this.panelStripeColsButtons, 0));
        this.panelVariableLayoutButtons.setLayout(new BoxLayout(this.panelVariableLayoutButtons, 0));
        IAIconFactory iAIconFactory = new IAIconFactory(iComponentFactory, 32);
        this.stripeLayoutIcons = new Icon[stripeLayouts.length];
        int n = 0;
        while (n < stripeLayouts.length) {
            this.stripeLayoutIcons[n] = iAIconFactory.loadIcon("icon_stripe_layout_rows" + stripeLayouts[n].charAt(stripeLayouts[n].length() - 1) + ".svg");
            ++n;
        }
        this.stripeLayoutColsIcons = new Icon[stripeCols.length];
        n = 0;
        while (n < stripeCols.length) {
            this.stripeLayoutColsIcons[n] = iAIconFactory.loadIcon("icon_stripe_layout_cols" + stripeCols[n].charAt(0) + ".svg");
            ++n;
        }
        this.variableLayoutIcons = new Icon[variableLayouts.length];
        n = 0;
        while (n < variableLayouts.length) {
            this.variableLayoutIcons[n] = iAIconFactory.loadIcon("icon_variable_layout_" + variableLayouts[n].getID() + ".svg");
            ++n;
        }
        this.stripeLayoutButtons = new JToggleButton[this.stripeLayoutIcons.length];
        this.stripeLayoutColsButtons = new JToggleButton[this.stripeLayoutColsIcons.length];
        this.variableLayoutButtons = new JToggleButton[this.variableLayoutIcons.length];
        this.orderHangingComboBox = iComponentFactory.createComboBox((Object[])orderHangingScreenStartDSStrategies);
        this.buttonGroupStripeLayout = new ButtonGroup();
        this.buttonGroupStripeCols = new ButtonGroup();
        this.buttonGroupVariableLayout = new ButtonGroup();
        ScreenLayoutActionListener screenLayoutActionListener = new ScreenLayoutActionListener();
        int n2 = 0;
        while (n2 < this.stripeLayoutIcons.length) {
            this.stripeLayoutButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.stripeLayoutIcons[n2]);
            this.stripeLayoutButtons[n2].addActionListener(screenLayoutActionListener);
            this.buttonGroupStripeLayout.add(this.stripeLayoutButtons[n2]);
            this.panelStripeLayoutButtons.add(this.stripeLayoutButtons[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.stripeLayoutColsIcons.length) {
            this.stripeLayoutColsButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.stripeLayoutColsIcons[n2]);
            this.stripeLayoutColsButtons[n2].addActionListener(screenLayoutActionListener);
            this.buttonGroupStripeCols.add(this.stripeLayoutColsButtons[n2]);
            this.panelStripeColsButtons.add(this.stripeLayoutColsButtons[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.variableLayoutIcons.length) {
            this.variableLayoutButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.variableLayoutIcons[n2]);
            this.variableLayoutButtons[n2].addActionListener(screenLayoutActionListener);
            this.buttonGroupVariableLayout.add(this.variableLayoutButtons[n2]);
            this.panelVariableLayoutButtons.add(this.variableLayoutButtons[n2]);
            ++n2;
        }
        this.variableLayoutDropdown = new DropDownButton("", null, LayoutChooserPopupMenu.createPopupMenu(new LayoutChooserPopupMenu.ILayoutSelectionHandler(){

            @Override
            public void layoutSelected(LayoutChooserPopupMenu.ILayoutSelectionSource iLayoutSelectionSource) {
                String string = iLayoutSelectionSource.toLayoutString();
                ScreenSettingsPanel.this.setScreenLayout(MainLayoutType.variable, string, null, true);
                if (ScreenSettingsPanel.this.owner != null) {
                    ScreenSettingsPanel.this.owner.screenLayoutChanged(string);
                }
            }
        }), DropDownButton.Orientation.bottom);
        this.panelVariableLayoutButtons.add(this.variableLayoutDropdown);
        this.variableLayoutDropdown.setPreferredSize(new Dimension(GUI.getScaledInt((int)100), (int)this.variableLayoutButtons[0].getPreferredSize().getHeight()));
        this.variableLayoutDropdown.setIcon((Icon)iAIconFactory.loadIcon("layout-configuration.svg"));
        this.labelStripeScreenLayout = iComponentFactory.createLabel(String.valueOf(Messages.getString("ScreenSettingsPanel.ScreenLayout")) + ":");
        this.labelStripeDisplayLayout = iComponentFactory.createLabel(String.valueOf(Messages.getString("ScreenSettingsPanel.DisplayLayout")) + ":");
        this.labelVariableScreenLayout = iComponentFactory.createLabel(String.valueOf(Messages.getString("ScreenSettingsPanel.Layout")) + ":");
        this.labelOrderHanging = iComponentFactory.createLabel(String.valueOf(Messages.getString("ScreenSettingsPanel.OrderHangingDisplayedStudy")) + ":");
        jPanel.add((Component)this.labelStripeScreenLayout, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.labelStripeDisplayLayout, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.labelVariableScreenLayout, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.panelStripeLayoutButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.panelStripeColsButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.panelVariableLayoutButtons, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.labelOrderHanging, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.orderHangingComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(jPanel);
        String string = null;
        if (iScreenLayoutDefinition.displayLayoutCount() > 0) {
            string = iScreenLayoutDefinition.getDisplayLayout(0).getHorizontalXVertical();
        }
        this.setScreenLayout(mainLayoutType, iScreenLayoutDefinition.getHorizontalXVertical(), string, false);
        this.orderHangingComboBox.setSelectedItem(this.getRightWrapper(orderHangingScreen.getOrderHangingScreenStartDSStrategy()));
        this.orderHangingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OrderHangingScreenStartDSStrategy orderHangingScreenStartDSStrategy = ScreenSettingsPanel.this.orderHangingScreen.getOrderHangingScreenStartDSStrategy();
                Object object = ScreenSettingsPanel.this.orderHangingComboBox.getSelectedItem();
                if (object instanceof OrderHangingScreenStartDSStrategyWrapper) {
                    OrderHangingScreenStartDSStrategy orderHangingScreenStartDSStrategy2 = ((OrderHangingScreenStartDSStrategyWrapper)object).getDelegate();
                    if (!orderHangingScreenStartDSStrategy2.equals((Object)orderHangingScreenStartDSStrategy)) {
                        ScreenSettingsPanel.this.orderHangingScreen.setOrderHangingScreenStartDSStrategy(orderHangingScreenStartDSStrategy2);
                        ScreenSettingsPanel.this.informListener();
                    }
                } else if (orderHangingScreenStartDSStrategy != null) {
                    ScreenSettingsPanel.this.orderHangingScreen.setOrderHangingScreenStartDSStrategy(null);
                    ScreenSettingsPanel.this.informListener();
                }
            }
        });
        this.kindOfHangingChanged(bl);
    }

    @Override
    public void activationChanged(ActivationStateTreeNode activationStateTreeNode) {
        if (CompareUtils.equals((Object)activationStateTreeNode, (Object)this.owner)) {
            JToggleButton jToggleButton;
            boolean bl = activationStateTreeNode.isActive();
            JToggleButton[] jToggleButtonArray = this.stripeLayoutButtons;
            int n = this.stripeLayoutButtons.length;
            int n2 = 0;
            while (n2 < n) {
                jToggleButton = jToggleButtonArray[n2];
                jToggleButton.setEnabled(bl);
                ++n2;
            }
            jToggleButtonArray = this.stripeLayoutColsButtons;
            n = this.stripeLayoutColsButtons.length;
            n2 = 0;
            while (n2 < n) {
                jToggleButton = jToggleButtonArray[n2];
                jToggleButton.setEnabled(bl);
                ++n2;
            }
            jToggleButtonArray = this.variableLayoutButtons;
            n = this.variableLayoutButtons.length;
            n2 = 0;
            while (n2 < n) {
                jToggleButton = jToggleButtonArray[n2];
                jToggleButton.setEnabled(bl);
                ++n2;
            }
            this.orderHangingComboBox.setEnabled(bl);
        }
    }

    public void setScreenLayout(MainLayoutType mainLayoutType, String string, String string2, boolean bl) {
        if (mainLayoutType == this.currentScreenLayoutType && CompareUtils.equals((Object)string, (Object)this.screenLayout.getHorizontalXVertical())) {
            return;
        }
        this.currentScreenLayoutType = mainLayoutType;
        if (mainLayoutType == MainLayoutType.variable) {
            String string3;
            this.panelStripeColsButtons.setVisible(false);
            this.panelStripeLayoutButtons.setVisible(false);
            this.panelVariableLayoutButtons.setVisible(true);
            this.labelStripeDisplayLayout.setVisible(false);
            this.labelStripeScreenLayout.setVisible(false);
            this.labelVariableScreenLayout.setVisible(true);
            int n = this.getIndexOfVariableLayout(string);
            this.buttonGroupVariableLayout.clearSelection();
            if (n >= 0) {
                this.variableLayoutButtons[n].setSelected(true);
                string3 = variableLayouts[n].getDescription();
            } else {
                string3 = string;
            }
            this.variableLayoutDropdown.setText(string3);
        } else if (mainLayoutType == MainLayoutType.film) {
            this.panelStripeColsButtons.setVisible(false);
            this.panelStripeLayoutButtons.setVisible(false);
            this.panelVariableLayoutButtons.setVisible(false);
            this.labelStripeDisplayLayout.setVisible(false);
            this.labelStripeScreenLayout.setVisible(false);
            this.labelVariableScreenLayout.setVisible(false);
        } else if (mainLayoutType == MainLayoutType.stripe) {
            this.panelStripeColsButtons.setVisible(true);
            this.panelStripeLayoutButtons.setVisible(true);
            this.panelVariableLayoutButtons.setVisible(false);
            this.labelStripeDisplayLayout.setVisible(true);
            this.labelStripeScreenLayout.setVisible(true);
            this.labelVariableScreenLayout.setVisible(false);
            int n = this.getIndexOfStripeLayout(string);
            if (this.buttonGroupStripeLayout.getSelection() != null) {
                this.buttonGroupStripeLayout.getSelection().setSelected(false);
            }
            if (n >= 0) {
                this.stripeLayoutButtons[n].setSelected(true);
            } else {
                this.stripeLayoutButtons[0].setSelected(true);
            }
            if (string2 == null) {
                string2 = string;
            }
            n = ScreenSettingsPanel.getIndexOfStripeCols(string2);
            if (this.buttonGroupStripeCols.getSelection() != null) {
                this.buttonGroupStripeCols.getSelection().setSelected(false);
            }
            if (n >= 0) {
                this.stripeLayoutColsButtons[n].setSelected(true);
            } else {
                this.stripeLayoutColsButtons[0].setSelected(true);
            }
        }
        if (bl) {
            this.storeScreenLayout();
        }
    }

    private int getIndexOfVariableLayout(String string) {
        if (string != null) {
            int n = 0;
            while (n < variableLayouts.length) {
                if (variableLayouts[n].getType().equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private int getIndexOfStripeLayout(String string) {
        if (string != null) {
            int n = 0;
            while (n < stripeLayouts.length) {
                if (stripeLayouts[n].equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
            n = 0;
            while (n < oldStripeLayouts.length) {
                if (oldStripeLayouts[n].equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private static int getIndexOfStripeCols(String string) {
        if (string != null) {
            int n = 0;
            while (n < stripeCols.length) {
                if (stripeCols[n].equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
            n = 0;
            while (n < oldStripeCols.length) {
                if (oldStripeCols[n].equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public void setOwner(ScreenTreeNode screenTreeNode) {
        this.owner = screenTreeNode;
    }

    public MainLayoutType getCurrentScreenLayoutType() {
        return this.currentScreenLayoutType;
    }

    private void storeScreenLayout() {
        String string = null;
        if (this.currentScreenLayoutType == MainLayoutType.film) {
            string = "1x1";
        } else if (this.currentScreenLayoutType == MainLayoutType.stripe) {
            string = stripeLayouts[0];
            int n = 0;
            while (n < this.stripeLayoutButtons.length) {
                if (this.stripeLayoutButtons[n].isSelected()) {
                    string = stripeLayouts[n];
                    break;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.variableLayoutButtons.length) {
                if (this.variableLayoutButtons[n].isSelected()) {
                    string = variableLayouts[n].getType();
                    break;
                }
                ++n;
            }
            if (string == null) {
                string = this.variableLayoutDropdown.getText();
            }
            if (string == null || string.isEmpty()) {
                string = variableLayouts[0].getType();
            }
        }
        this.storeScreenLayout(string);
    }

    private void storeScreenLayout(String string) {
        String string2 = this.screenLayout.getHorizontalXVertical();
        if (!string.equals(string2)) {
            this.screenLayout.setHorizontalXVertical(string);
            this.informListener();
        }
    }

    private void informListener() {
        if (this.imageHangingChangeListener != null) {
            this.imageHangingChangeListener.hangingChanged();
        }
    }

    public String getSelectedStripeDisplayLayout() {
        if (this.currentScreenLayoutType == MainLayoutType.stripe) {
            int n = 0;
            while (n < this.stripeLayoutColsButtons.length) {
                if (this.stripeLayoutColsButtons[n].isSelected()) {
                    return stripeCols[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static String correctStripeCols(String string) {
        int n = ScreenSettingsPanel.getIndexOfStripeCols(string);
        if (n >= 0 && n < stripeCols.length) {
            return stripeCols[n];
        }
        return string;
    }

    public void kindOfHangingChanged(boolean bl) {
        if (this.isOrderHanging == null || !this.isOrderHanging.equals(bl)) {
            this.orderHangingComboBox.setVisible(bl);
            this.labelOrderHanging.setVisible(bl);
            this.isOrderHanging = bl;
        }
    }

    private OrderHangingScreenStartDSStrategyWrapper getRightWrapper(OrderHangingScreenStartDSStrategy orderHangingScreenStartDSStrategy) {
        OrderHangingScreenStartDSStrategyWrapper[] orderHangingScreenStartDSStrategyWrapperArray = orderHangingScreenStartDSStrategies;
        int n = orderHangingScreenStartDSStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            OrderHangingScreenStartDSStrategyWrapper orderHangingScreenStartDSStrategyWrapper = orderHangingScreenStartDSStrategyWrapperArray[n2];
            if (orderHangingScreenStartDSStrategyWrapper.getDelegate() == orderHangingScreenStartDSStrategy) {
                return orderHangingScreenStartDSStrategyWrapper;
            }
            ++n2;
        }
        return orderHangingScreenStartDSStrategies[0];
    }

    private static class OrderHangingScreenStartDSStrategyWrapper {
        private OrderHangingScreenStartDSStrategy delegate;

        public OrderHangingScreenStartDSStrategyWrapper(OrderHangingScreenStartDSStrategy orderHangingScreenStartDSStrategy) {
            this.delegate = orderHangingScreenStartDSStrategy;
        }

        public String toString() {
            return this.delegate.getDescription();
        }

        public OrderHangingScreenStartDSStrategy getDelegate() {
            return this.delegate;
        }
    }

    private class ScreenLayoutActionListener
    implements ActionListener {
        private ScreenLayoutActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScreenSettingsPanel.this.storeScreenLayout();
            if (ScreenSettingsPanel.this.owner == null) {
                return;
            }
            Object object = actionEvent.getSource();
            int n = 0;
            while (n < ScreenSettingsPanel.this.stripeLayoutButtons.length) {
                if (object == ScreenSettingsPanel.this.stripeLayoutButtons[n]) {
                    ScreenSettingsPanel.this.owner.screenLayoutChanged(stripeLayouts[n]);
                }
                ++n;
            }
            n = 0;
            while (n < ScreenSettingsPanel.this.variableLayoutButtons.length) {
                if (object == ScreenSettingsPanel.this.variableLayoutButtons[n]) {
                    ScreenSettingsPanel.this.owner.screenLayoutChanged(variableLayouts[n].getType());
                    ScreenSettingsPanel.this.variableLayoutDropdown.setText(variableLayouts[n].getDescription());
                }
                ++n;
            }
            n = 0;
            while (n < ScreenSettingsPanel.this.stripeLayoutColsButtons.length) {
                if (object == ScreenSettingsPanel.this.stripeLayoutColsButtons[n]) {
                    ScreenSettingsPanel.this.owner.displayLayoutChanged(MainLayoutType.stripe, stripeCols[n]);
                }
                ++n;
            }
        }
    }
}

