/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationHandler;
import com.agfa.pacs.impaxee.hanging.HangingRuntimeManager;
import com.agfa.pacs.impaxee.hanging.IConditionEvaluator;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.CreateAbstractConditionPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingProtocolSettingsPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingProtocolWarningUtil;
import com.agfa.pacs.impaxee.hanging.gui.advanced.IActivationStateTreeListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotTreeNode;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;

public class HangingProtocolTreeNode
extends ActivationStateTreeNode
implements IHangingProtocolManipulationListener,
IActivationStateTreeListener,
IConditionEvaluator {
    private List<CreateAbstractConditionPanel> createAbstractConditionPanels;
    private List<String> hangingConditionNames;
    private HangingProtocolSettingsPanel hangingProtocolSettingsPanel;
    private JPanel panelContent;
    private IHangingProtocolDefinition hangingProtocolDefinition;
    private JTabbedPane tabbedPane;
    private IComponentFactory componentFactory;
    private Window parentWindow;
    private HangingProtocolManipulationHandler hangingProtocolManipulationHandler;
    private boolean isDefaultHanging;

    public HangingProtocolTreeNode(Window window, IHangingProtocolDefinition iHangingProtocolDefinition, IComponentFactory iComponentFactory, HangingProtocolManipulationHandler hangingProtocolManipulationHandler, boolean bl) {
        super(iComponentFactory);
        ISnapshotDefinition[] iSnapshotDefinitionArray;
        Object object;
        this.hangingProtocolDefinition = iHangingProtocolDefinition;
        this.componentFactory = iComponentFactory;
        this.parentWindow = window;
        this.hangingProtocolManipulationHandler = hangingProtocolManipulationHandler;
        this.isDefaultHanging = bl;
        this.panelContent = new JPanel(new BorderLayout());
        this.panelContent.setOpaque(false);
        this.tabbedPane = iComponentFactory.createTabbedPane(Integer.valueOf(1), Integer.valueOf(1));
        this.createAbstractConditionPanels = new ArrayList<CreateAbstractConditionPanel>();
        this.hangingConditionNames = new ArrayList<String>();
        if (iHangingProtocolDefinition.getHangingApplicability() != null) {
            HangingCondition[] hangingConditionArray = iHangingProtocolDefinition.getHangingApplicability().hangingConditions();
            int n = hangingConditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = hangingConditionArray[n2];
                this.addHangingCondition((HangingCondition)object);
                ++n2;
            }
        }
        hangingProtocolManipulationHandler.registerListener(this);
        this.hangingProtocolSettingsPanel = new HangingProtocolSettingsPanel(iHangingProtocolDefinition, iComponentFactory, hangingProtocolManipulationHandler, bl);
        object = new JPanel(new GridLayout(1, 0, 10, 0));
        ((JComponent)object).setOpaque(false);
        ((JComponent)object).setBorder(new EmptyBorder(5, 5, 5, 5));
        ((Container)object).add(iComponentFactory.createButton((Action)new AddHangingConditionAction()));
        ((Container)object).add(iComponentFactory.createButton((Action)new DeleteHangingConditionAction()));
        if (!bl) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)this.tabbedPane, "Center");
            jPanel.add((Component)object, "South");
            JSplitPane jSplitPane = new JSplitPane(0, this.hangingProtocolSettingsPanel, jPanel);
            this.panelContent.add((Component)jSplitPane, "Center");
        } else {
            this.panelContent.add((Component)this.hangingProtocolSettingsPanel, "North");
        }
        ISnapshotDefinition[] iSnapshotDefinitionArray2 = iSnapshotDefinitionArray = iHangingProtocolDefinition.getHangingDefinition().snapshots();
        int n = iSnapshotDefinitionArray.length;
        int n3 = 0;
        while (n3 < n) {
            ISnapshotDefinition iSnapshotDefinition = iSnapshotDefinitionArray2[n3];
            SnapshotTreeNode snapshotTreeNode = new SnapshotTreeNode(window, iHangingProtocolDefinition, iSnapshotDefinition, hangingProtocolManipulationHandler, iComponentFactory);
            snapshotTreeNode.addActivationStateTreeListener(this);
            this.add(snapshotTreeNode);
            ++n3;
        }
        this.checkWarningAndErrorState();
    }

    private void addHangingCondition(HangingCondition hangingCondition2) {
        CreateAbstractConditionPanel createAbstractConditionPanel = new CreateAbstractConditionPanel(this.parentWindow, Messages.getString("HangingProtocolTreeNode.HangingProtocolConditionSets"), hangingCondition2, this.componentFactory, this.hangingProtocolManipulationHandler, this);
        this.createAbstractConditionPanels.add(createAbstractConditionPanel);
        this.tabbedPane.add((Component)createAbstractConditionPanel, hangingCondition2.getName());
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        this.hangingConditionNames.add(hangingCondition2.getName());
    }

    private void deleteHangingCondition(int n) {
        CreateAbstractConditionPanel createAbstractConditionPanel = (CreateAbstractConditionPanel)this.tabbedPane.getComponentAt(n);
        createAbstractConditionPanel.deregisterListener();
        this.tabbedPane.remove(n);
        this.hangingConditionNames.remove(n);
        this.hangingProtocolDefinition.getHangingApplicability().removeHangingCondition(n);
    }

    private boolean isNameAllowedForHangingCondition(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        for (String string2 : this.hangingConditionNames) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "HP: " + this.hangingProtocolDefinition.getName();
    }

    @Override
    public JPanel getPanel() {
        return this.panelContent;
    }

    @Override
    public void deregisterListeners() {
        super.deregisterListeners();
        Component[] componentArray = this.tabbedPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof CreateAbstractConditionPanel) {
                ((CreateAbstractConditionPanel)component).deregisterListener();
            }
            ++n2;
        }
    }

    @Override
    public boolean isEvaluationPossible() {
        return this.hangingProtocolDefinition instanceof IHanging;
    }

    @Override
    public boolean meetsConditions(Iterable<Condition> iterable) {
        if (this.isEvaluationPossible()) {
            return HangingRuntimeManager.getInstance().meetsConditions(iterable, (IHanging)((Object)this.hangingProtocolDefinition));
        }
        return true;
    }

    @Override
    public void hangingChanged() {
        this.checkWarningAndErrorState();
        this.model.nodeChanged(this);
    }

    @Override
    public void activationChanged(ActivationStateTreeNode activationStateTreeNode) {
        int n = 0;
        if (activationStateTreeNode instanceof SnapshotTreeNode) {
            for (Object e : this.children) {
                if (e == activationStateTreeNode) {
                    if (!activationStateTreeNode.isActive()) {
                        this.hangingProtocolDefinition.getHangingDefinition().removeSnapshot(((SnapshotTreeNode)activationStateTreeNode).getSnapshot());
                        break;
                    }
                    this.hangingProtocolDefinition.getHangingDefinition().insertSnapshot(n, ((SnapshotTreeNode)activationStateTreeNode).getSnapshot());
                    break;
                }
                if (!(e instanceof ActivationStateTreeNode) || !((ActivationStateTreeNode)e).isActive()) continue;
                ++n;
            }
        }
    }

    private void checkWarningAndErrorState() {
        List<String> list = new ArrayList<String>();
        boolean bl = false;
        if (!this.isDefaultHanging) {
            list = HangingProtocolWarningUtil.getWarnings(this.hangingProtocolDefinition);
            bl = !list.isEmpty();
        }
        this.setWarningMessagesSelf(list);
        this.setHasWarningSelf(bl);
    }

    TreeNode[] getFirstRuntimeSnapshotTreeNode() {
        if (this.children != null) {
            for (Object e : this.children) {
                ISnapshotDefinition iSnapshotDefinition;
                if (!(e instanceof SnapshotTreeNode) || !((iSnapshotDefinition = ((SnapshotTreeNode)e).getSnapshot()) instanceof HangingProtocolSnapshotRuntime) || !((HangingProtocolSnapshotRuntime)iSnapshotDefinition).isInitedFromRuntime()) continue;
                return ((SnapshotTreeNode)e).getPath();
            }
        }
        return null;
    }

    private class AddHangingConditionAction
    extends AbstractAction {
        public AddHangingConditionAction() {
            super(Messages.getString("HangingProtocolTreeNode.AddHangingRule"));
            this.putValue("ShortDescription", Messages.getString("HangingProtocolTreeNode.AddHangingRuleToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(Messages.getString("HangingProtocolTreeNode.NameOfNewhangingCondition"));
            if (string != null && string.trim().length() > 0) {
                if (HangingProtocolTreeNode.this.isNameAllowedForHangingCondition(string)) {
                    HangingCondition hangingCondition2 = new HangingCondition();
                    hangingCondition2.setName(string);
                    HangingProtocolTreeNode.this.hangingProtocolDefinition.getHangingApplicability().addHangingCondition(hangingCondition2);
                    HangingProtocolTreeNode.this.hangingProtocolManipulationHandler.hangingChanged();
                    HangingProtocolTreeNode.this.addHangingCondition(hangingCondition2);
                } else {
                    HangingProtocolTreeNode.this.componentFactory.showErrorDialog(Messages.getString("ERROR"), Messages.getString("HangingProtocolTreeNode.ErrorMessageNonUniqueHangingConditionName"), (Component)HangingProtocolTreeNode.this.panelContent);
                }
            }
        }
    }

    private class DeleteHangingConditionAction
    extends AbstractAction {
        public DeleteHangingConditionAction() {
            super(Messages.getString("HangingProtocolTreeNode.DeleteHangingRule"));
            this.putValue("ShortDescription", Messages.getString("HangingProtocolTreeNode.DeleteHangingRuleToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (Message.okCancel(Messages.getString("HangingUtil.ConfirmDeletionDialogTitle"), Messages.getString("HangingProtocolTreeNode.DeleteHangingRuleQuestion")) == 0 && (n = HangingProtocolTreeNode.this.tabbedPane.getSelectedIndex()) >= 0) {
                HangingProtocolTreeNode.this.deleteHangingCondition(n);
                HangingProtocolTreeNode.this.hangingProtocolManipulationHandler.hangingChanged();
            }
        }
    }
}

