/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataDialog;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataElement;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedSelectableDataElement;
import com.agfa.pacs.impaxee.hanging.model.PatientsUnsavedDataMapping;
import com.tiani.gui.util.TIcon;
import com.tiani.gui.util.togglebutton.CustomLabelCheckBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class UnsavedDataTree
extends JTree {
    private static final Icon stopSignIcon = new TIcon("/icons/stopp.gif");
    private UnsavedDataDialog dialog;

    UnsavedDataTree(PatientsUnsavedDataMapping patientsUnsavedDataMapping, UnsavedDataDialog unsavedDataDialog) {
        this.setModel(new UnsavedDataTreeModel(patientsUnsavedDataMapping));
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new UnsavedDataTreeRenderer());
        this.addMouseListener(new NodeSelectionListener(this));
        this.dialog = unsavedDataDialog;
    }

    private class NodeSelectionListener
    extends MouseAdapter {
        private JTree tree;

        public NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TreePath treePath = this.tree.getPathForLocation(n, n2);
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof UnsavedDataElement) {
                    UnsavedDataElement unsavedDataElement = (UnsavedDataElement)object;
                    CustomLabelCheckBox customLabelCheckBox = ((UnsavedDataTreeRenderer)this.tree.getCellRenderer()).getCheckBox();
                    Rectangle rectangle = this.tree.getPathBounds(treePath);
                    if (unsavedDataElement instanceof UnsavedSelectableDataElement && n >= rectangle.x && n < rectangle.x + customLabelCheckBox.getToggleControlWidth()) {
                        UnsavedSelectableDataElement unsavedSelectableDataElement;
                        unsavedSelectableDataElement.setMarkedForSave(!(unsavedSelectableDataElement = (UnsavedSelectableDataElement)unsavedDataElement).getMarkedForSave());
                        this.tree.revalidate();
                        this.tree.repaint();
                        UnsavedDataTree.this.dialog.treeNodeToggleControlAction(unsavedSelectableDataElement);
                    } else if (n >= rectangle.x + customLabelCheckBox.getToggleControlWidth() && (double)n < (double)rectangle.x + rectangle.getWidth()) {
                        if (this.tree.getSelectionPath() == treePath) {
                            UnsavedDataTree.this.dialog.treeNodeButtonAction(unsavedDataElement);
                        } else {
                            UnsavedDataTree.this.dialog.treeNodeButtonAction(null);
                        }
                    }
                } else {
                    UnsavedDataTree.this.dialog.treeNodeButtonAction(null);
                }
            }
        }
    }

    private static class UnsavedDataTreeModel
    implements TreeModel {
        private PatientsUnsavedDataMapping unsavedData;
        private Vector<TreeModelListener> treeModelListeners = new Vector();

        public UnsavedDataTreeModel(PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
            this.unsavedData = patientsUnsavedDataMapping;
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.add(treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object instanceof PatientsUnsavedDataMapping) {
                return ((PatientsUnsavedDataMapping)object).keySet().toArray()[n];
            }
            if (object instanceof IPatientRepresentation) {
                IPatientRepresentation iPatientRepresentation = (IPatientRepresentation)object;
                List<UnsavedDataElement> list = this.unsavedData.get(iPatientRepresentation);
                return list.get(n);
            }
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            if (object instanceof PatientsUnsavedDataMapping) {
                return ((PatientsUnsavedDataMapping)object).size();
            }
            if (object instanceof IPatientRepresentation) {
                IPatientRepresentation iPatientRepresentation = (IPatientRepresentation)object;
                List<UnsavedDataElement> list = this.unsavedData.get(iPatientRepresentation);
                return list.size();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            IPatientRepresentation iPatientRepresentation = (IPatientRepresentation)object;
            List<UnsavedDataElement> list = this.unsavedData.get(iPatientRepresentation);
            return list.indexOf(object2);
        }

        @Override
        public Object getRoot() {
            return this.unsavedData;
        }

        @Override
        public boolean isLeaf(Object object) {
            return object instanceof UnsavedDataElement;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.removeElement(treeModelListener);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private static class UnsavedDataTreeRenderer
    extends JPanel
    implements TreeCellRenderer {
        private CustomLabelCheckBox checkBox;
        private JLabel stopSignLabel = ComponentFactory.instance.createLabel(UnsavedDataTree.access$0());

        public UnsavedDataTreeRenderer() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.checkBox = new CustomLabelCheckBox(null);
            this.add((Component)this.checkBox, "Center");
            this.add((Component)this.stopSignLabel, "East");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width + stopSignIcon.getIconWidth() + 5, dimension.height);
        }

        public CustomLabelCheckBox getCheckBox() {
            return this.checkBox;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof IPatientRepresentation) {
                this.checkBox.setText(((IPatientRepresentation)object).toString());
                this.checkBox.setIcon(null);
                this.checkBox.setToggleControlVisible(false);
                this.checkBox.setBorder(null);
                this.stopSignLabel.setVisible(false);
            } else if (object instanceof UnsavedDataElement) {
                UnsavedDataElement unsavedDataElement = (UnsavedDataElement)object;
                this.checkBox.setToggleControlVisible(false);
                if (object instanceof UnsavedSelectableDataElement) {
                    UnsavedSelectableDataElement unsavedSelectableDataElement = (UnsavedSelectableDataElement)object;
                    this.checkBox.setToggleControlVisible(true);
                    this.checkBox.setSelected(unsavedSelectableDataElement.getMarkedForSave());
                }
                this.checkBox.setText(unsavedDataElement.getSaveItemFactory().getVisibleName());
                this.checkBox.setIcon(unsavedDataElement.getSaveItemFactory().getIcon());
                if (unsavedDataElement.getSaveItem() == null || unsavedDataElement.getSaveItem().isSaveable()) {
                    this.stopSignLabel.setVisible(false);
                } else {
                    this.stopSignLabel.setVisible(true);
                }
                if (bl) {
                    this.checkBox.setBorder(BorderFactory.createLineBorder((Color)UIManager.getDefaults().get("Tree.textForeground")));
                } else {
                    this.checkBox.setBorder(null);
                }
            }
            return this;
        }
    }
}

