/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataElement;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataTree;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedSelectableDataElement;
import com.agfa.pacs.impaxee.hanging.model.PatientsUnsavedDataMapping;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveItemFactory;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;

class UnsavedDataDialog
extends StandardDialog
implements ISaveManager {
    private JSplitPane splitPane;
    private JTree mainTree;
    PatientsUnsavedDataMapping unsavedData;
    private final List<ISaveItem> saveItems;

    UnsavedDataDialog(Frame frame, PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        super(frame, Messages.getString("UnsavedDataDialog.Title"));
        assert (patientsUnsavedDataMapping.size() > 0) : "no unsaved data passed, omitting save dialog";
        this.unsavedData = patientsUnsavedDataMapping;
        this.saveItems = new ArrayList<ISaveItem>();
        this.addOKButton(new OKAction());
        this.addCancelButton(new CancelAction());
        this.setContent(this.createMainPanel());
        this.pack();
        this.initLocation();
        this.registerSaveManager();
    }

    private void setModelMarkedForSaveStatus(boolean bl) {
        for (UnsavedDataElement unsavedDataElement : this.unsavedData.getAllUnsavedData()) {
            if (!(unsavedDataElement instanceof UnsavedSelectableDataElement)) continue;
            ((UnsavedSelectableDataElement)unsavedDataElement).setMarkedForSave(bl);
        }
    }

    private void registerSaveManager() {
        for (UnsavedDataElement unsavedDataElement : this.unsavedData.getAllUnsavedData()) {
            if (unsavedDataElement.getSaveItem() == null) continue;
            unsavedDataElement.getSaveItem().setSaveManager(this);
        }
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, true);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        this.mainTree = this.createUnsavedDataTree();
        JScrollPane jScrollPane = ComponentFactory.instance.createScrollPane(this.mainTree);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        JButton jButton = ComponentFactory.instance.createButton(Messages.getString("SelectAll"));
        JButton jButton2 = ComponentFactory.instance.createButton(Messages.getString("DeselectAll"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnsavedDataDialog.this.setModelMarkedForSaveStatus(true);
                UnsavedDataDialog.this.mainTree.revalidate();
                UnsavedDataDialog.this.mainTree.repaint();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnsavedDataDialog.this.setModelMarkedForSaveStatus(false);
                UnsavedDataDialog.this.mainTree.revalidate();
                UnsavedDataDialog.this.mainTree.repaint();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "South");
        this.splitPane.setLeftComponent(jPanel2);
        jPanel.add(this.splitPane);
        return jPanel;
    }

    private JTree createUnsavedDataTree() {
        assert (this.unsavedData != null) : "no unsaved Data available";
        UnsavedDataTree unsavedDataTree = new UnsavedDataTree(this.unsavedData, this);
        int n = unsavedDataTree.getRowCount() - 1;
        while (n >= 0) {
            unsavedDataTree.expandRow(n);
            --n;
        }
        this.treeNodeButtonAction((UnsavedDataElement)unsavedDataTree.getPathForRow(1).getLastPathComponent());
        unsavedDataTree.setSelectionPath(unsavedDataTree.getPathForRow(1));
        return unsavedDataTree;
    }

    public void treeNodeToggleControlAction(UnsavedDataElement unsavedDataElement) {
    }

    private JPanel createEmptyPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        JLabel jLabel = new JLabel(Messages.getString("UnsavedDataDialog.NoData"));
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        return jPanel;
    }

    public void treeNodeButtonAction(UnsavedDataElement unsavedDataElement) {
        Component component = unsavedDataElement == null || unsavedDataElement.getSaveItem() == null ? this.createEmptyPanel() : unsavedDataElement.getSaveItem().getComponent();
        this.splitPane.setRightComponent(component);
    }

    @Override
    public void updateItems() {
        this.mainTree.revalidate();
        this.mainTree.repaint();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    Iterable<ISaveItem> getSaveItems() {
        return this.saveItems;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", Messages.getString("UnsavedDataDialog.CancelTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnsavedDataDialog.this.setVisible(false);
            UnsavedDataDialog.this.setDialogResult(2);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("ShortDescription", Messages.getString("UnsavedDataDialog.OKTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<ISaveItemFactory> arrayList = new ArrayList<ISaveItemFactory>();
            Object object = UnsavedDataDialog.this.unsavedData.getAllUnsavedData().iterator();
            while (object.hasNext()) {
                UnsavedSelectableDataElement unsavedSelectableDataElement;
                UnsavedDataElement unsavedDataElement = object.next();
                if (!(unsavedDataElement instanceof UnsavedSelectableDataElement) || !(unsavedSelectableDataElement = (UnsavedSelectableDataElement)unsavedDataElement).getMarkedForSave() || unsavedSelectableDataElement.getSaveItem() == null) continue;
                UnsavedDataDialog.this.saveItems.add(unsavedSelectableDataElement.getSaveItem());
                if (unsavedSelectableDataElement.getSaveItem().save(false)) continue;
                arrayList.add(unsavedSelectableDataElement.getSaveItemFactory());
            }
            int n = 0;
            if (arrayList.size() > 0 && ((SaveFailedDialog)(object = new SaveFailedDialog(arrayList))).getDialogResult() == 1) {
                n = 2;
            }
            UnsavedDataDialog.this.setDialogResult(n);
            UnsavedDataDialog.this.setVisible(false);
        }
    }

    private static class SaveFailedDialog {
        private List<ISaveItemFactory> failedItems;
        private int dialogResult;

        public SaveFailedDialog(List<ISaveItemFactory> list) {
            this.failedItems = list;
            this.dialogResult = Message.yesNo(this.createDialogPanel());
        }

        public int getDialogResult() {
            return this.dialogResult;
        }

        private JPanel createDialogPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 10));
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (ISaveItemFactory object2 : this.failedItems) {
                defaultListModel.addElement(object2.getVisibleName());
            }
            JList jList = new JList(defaultListModel);
            JScrollPane jScrollPane = ComponentFactory.instance.createScrollPane(jList);
            jScrollPane.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("UnsavedDataDialog.ErrorDescriptionText")));
            jScrollPane.setPreferredSize(ComponentFactory.instance.scaleDimension(300, jScrollPane.getPreferredSize().height));
            JLabel jLabel = new JLabel(Messages.getString("UnsavedDataDialog.ErrorQuestionText"));
            jPanel.add((Component)jScrollPane, "North");
            jPanel.add((Component)jLabel, "Center");
            return jPanel;
        }
    }
}

