/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.selection;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.selection.AbstractSelectionData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import com.tiani.base.data.TokenOwner;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.patinfo.SeqLabelMapping;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DisplaySetSelectionData
extends AbstractSelectionData<IDisplaySet> {
    public DisplaySetSelectionData(IDisplaySet iDisplaySet) {
        super(iDisplaySet);
    }

    @Override
    public Iterable<IDisplaySet> getAllData() {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(((IDisplaySet)this.getLoadedData()).getOneObject().getDicomObject());
        ISplitAndSortRuntime iSplitAndSortRuntime = iPatientRepresentation.getDecompositionRuntime();
        return Arrays.asList(iSplitAndSortRuntime.getDisplaySets());
    }

    @Override
    public String getLoadedDataTitle() {
        return Messages.getString("DisplaySetSelectionData.LoadedData.Title");
    }

    @Override
    public String getAdditionalDataTitle() {
        return Messages.getString("DisplaySetSelectionData.AdditionalData.Title");
    }

    @Override
    public JComponent getIcon(IDisplaySet iDisplaySet) {
        return DisplaySetSelectionData.getDisplaySetIcon(iDisplaySet, this.isLastModified(iDisplaySet), false);
    }

    @Override
    protected String getLabelPrefixImpl(IDisplaySet iDisplaySet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html> [<b>");
        stringBuilder.append(iDisplaySet.getFrameCount());
        stringBuilder.append("</b>] </html>");
        return stringBuilder.toString();
    }

    @Override
    public String getLabel(IDisplaySet iDisplaySet) {
        return DisplaySetSelectionData.getDisplaySetLabel(iDisplaySet);
    }

    public static String getDisplaySetLabel(IDisplaySet iDisplaySet) {
        return DisplaySetSelectionData.getSeriesLabel(iDisplaySet.getOneObject());
    }

    public static String getSeriesLabel(IEvaluationContext iEvaluationContext) {
        SeqLabelMapping seqLabelMapping = new SeqLabelMapping(iEvaluationContext);
        seqLabelMapping.updateContent(true, true);
        List<String> list = seqLabelMapping.getMappingRowsAsStrings();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            String string = list.get(n);
            if (string != null && !string.isEmpty()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("<br>");
                }
                stringBuffer.append(string);
            }
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(stringBuffer.toString());
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static JComponent getDisplaySetIcon(IDisplaySet iDisplaySet, boolean bl, boolean bl2) {
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        IFrameObjectData iFrameObjectData = Config.impaxee.jvision.SEQLABEL.UseFirstImagesForTokens.get() ? iFrameObjectDataArray[0] : iFrameObjectDataArray[iFrameObjectDataArray.length / 2];
        boolean bl3 = false;
        Integer n = null;
        if (bl2) {
            n = iDisplaySet.getFrameCount();
            bl3 = iDisplaySet.isDisplayedInImageArea();
        }
        return new ImagePanel(iFrameObjectData, bl, n, bl3, Mapping.getMappingColor(iFrameObjectData));
    }

    public static JComponent getDisplaySetIcon(TokenOwner tokenOwner, boolean bl, Integer n, boolean bl2) {
        return new ImagePanel(tokenOwner, bl, n, bl2, null);
    }

    protected boolean isLastModified(IDisplaySet iDisplaySet) {
        return false;
    }

    private static class ImagePanel
    extends JPanel
    implements TokenListener {
        BufferedImage image;
        private final boolean isLastModified;
        private final boolean isDisplayedInImageArea;
        private final Integer frameCount;
        private static final String FOUR_DIGITS = "0000";
        private static final int PADDING = GUI.getScaledDiagnosticInt((int)4);
        private Color foreground;

        public ImagePanel(TokenOwner tokenOwner, boolean bl, Integer n, boolean bl2, Color color) {
            this.isLastModified = bl;
            this.frameCount = n;
            this.isDisplayedInImageArea = bl2;
            this.foreground = color != null ? color : new Color((int)Config.impaxee.jvision.MAPPING.MappingColor.get());
            TokenData tokenData = tokenOwner.getTokenData();
            this.createImage(tokenData);
            if (!tokenData.isFinalToken() && tokenOwner instanceof IFrameObjectData) {
                ((IFrameObjectData)tokenOwner).setRawDataContainerToken();
                tokenData = tokenOwner.getTokenData();
                if (tokenData instanceof RawDataContainerTokenData) {
                    RawDataContainerTokenCreator.getInstance().addTokenData((RawDataContainerTokenData)tokenData);
                }
            }
            this.paintToken(tokenData, this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.image, 0, 0, this);
            if (this.isLastModified) {
                DisplaySetLabel.paintLastModBorder(graphics2D, new Rectangle(this.image.getWidth(), this.image.getHeight()), 0);
            }
            Color color = graphics2D.getColor();
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(FOUR_DIGITS, graphics2D);
            int n = (int)rectangle2D.getHeight() + PADDING;
            int n2 = (int)rectangle2D.getWidth() + PADDING * 2;
            if (this.frameCount != null && this.frameCount > 0) {
                String string = this.frameCount.toString();
                Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                int n3 = (int)rectangle2D2.getWidth();
                int n4 = (int)rectangle2D2.getHeight();
                int n5 = n2 - n3;
                if (n5 < 2) {
                    n5 = 4;
                }
                if (n5 % 2 != 0) {
                    ++n5;
                }
                graphics2D.setColor(new Color(0, 0, 0, 120));
                graphics2D.fillRect(2, 2, n2, n);
                graphics2D.setColor(this.foreground);
                graphics2D.drawRect(2, 2, n2, n);
                if (this.isDisplayedInImageArea) {
                    graphics2D.drawRect(4, 4, n2 - 4, n - 4);
                }
                int n6 = n5 / 2;
                graphics2D.drawString(string, 2 + n6, 2 + n4 + PADDING - graphics2D.getFontMetrics().getDescent());
            }
            graphics2D.setColor(color);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }

        @Override
        public void tokenChanged(TokenData tokenData) {
            this.createImage(tokenData);
            this.repaint();
        }

        private void createImage(TokenData tokenData) {
            this.image = new BufferedImage(DisplaySetLabel.tokenSize, DisplaySetLabel.tokenSize, 1);
            this.paintToken(tokenData, null);
        }

        private void paintToken(TokenData tokenData, TokenListener tokenListener) {
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            tokenData.paintToken(graphics2D, 0, 0, this.image.getWidth(), this.image.getHeight(), tokenListener);
        }
    }
}

