/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.chart;

import com.agfa.pacs.impaxee.gui.chart.AbstractAxisData;

public class FixedLabelAxisData
extends AbstractAxisData {
    private final String[] tickMarkLabels;

    public FixedLabelAxisData(long[] lArray, int n) {
        this(FixedLabelAxisData.calculateXTickMarks(lArray, n));
    }

    public FixedLabelAxisData(double[] dArray) {
        this(FixedLabelAxisData.roundXTickMarks(dArray));
    }

    public FixedLabelAxisData(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("No tick mark labels specified.");
        }
        this.tickMarkLabels = (String[])stringArray.clone();
    }

    private static double[] calculateXTickMarks(long[] lArray, int n) {
        if (lArray == null) {
            return null;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d = (double)n2 / ((double)n - 1.0) * ((double)lArray.length - 1.0);
            int n3 = (int)d;
            int n4 = n3 + 1;
            if (n4 >= lArray.length) {
                dArray[n2] = lArray[lArray.length - 1];
            } else {
                double d2;
                double d3 = d - (double)n3;
                double d4 = (double)n4 - d;
                dArray[n2] = d2 = d4 * (double)lArray[n3] + d3 * (double)lArray[n4];
            }
            ++n2;
        }
        return dArray;
    }

    private static String[] roundXTickMarks(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        String[] stringArray = new String[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            stringArray[n] = String.valueOf(FixedLabelAxisData.roundToOneDecimal(dArray[n]));
            ++n;
        }
        return stringArray;
    }

    @Override
    public int getTickMarkCount() {
        return this.tickMarkLabels.length;
    }

    @Override
    public String getTickMarkLabel(int n) {
        return this.tickMarkLabels[n];
    }

    @Override
    public void setMinimum(double d) {
    }

    @Override
    public void setMaximum(double d) {
    }
}

