/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gsts;

import com.agfa.pacs.impaxee.gsts.ILUT;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import java.io.Serializable;

class LUT
implements ILUT,
Serializable {
    protected short[] data;
    protected final int bitsOut;
    protected final int bitsIn;
    private String desc;
    private final boolean isSigned;

    LUT(ILUT iLUT) {
        this.data = (short[])iLUT.getData().clone();
        this.bitsOut = iLUT.getBitsStored();
        this.bitsIn = iLUT.getBitsOfIndex();
        this.desc = iLUT.getDescription();
        this.isSigned = iLUT.isSigned();
    }

    LUT(ILookupTable iLookupTable, int n, boolean bl) {
        this(iLookupTable, n, bl, false, false);
    }

    LUT(ILookupTable iLookupTable, int n, boolean bl, boolean bl2, boolean bl3) {
        this(iLookupTable.getOutputBits(), n, bl, iLookupTable.getLUTDescription());
        int[] nArray = iLookupTable.getFullLUT(n, bl);
        this.data = new short[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.data[n2] = (short)nArray[n2];
            ++n2;
        }
        if (this.data.length > 0) {
            int n3;
            n2 = this.data[0] & 0xFFFF;
            int n4 = 1;
            while (n4 < this.data.length) {
                if ((this.data[n4] & 0xFFFF) > n2) {
                    n2 = this.data[n4] & 0xFFFF;
                }
                ++n4;
            }
            if (bl2 && this.bitsOut == 16 && this.bitsIn < 16 && n2 <= 1 << this.bitsIn) {
                n4 = 16 - this.bitsIn;
                n3 = 0;
                while (n3 < this.data.length) {
                    int n5 = n3++;
                    this.data[n5] = (short)(this.data[n5] << n4);
                }
            }
            if (bl3 && n2 > 1 << this.bitsOut) {
                n4 = 1;
                while (n2 >> n4 > 1 << this.bitsOut) {
                    ++n4;
                }
                n3 = 0;
                while (n3 < this.data.length) {
                    int n6 = n3++;
                    this.data[n6] = (short)(this.data[n6] >> n4);
                }
            }
        }
    }

    LUT(int n, int n2, boolean bl, String string) {
        this.bitsOut = n;
        this.bitsIn = n2;
        this.desc = string;
        this.isSigned = bl;
    }

    @Override
    public boolean isMonotoneous() {
        int n = 0;
        int n2 = -1;
        int n3 = 1;
        while (n3 < this.data.length) {
            int n4 = (this.data[n3] & 0xFFFF) - (this.data[n3 - 1] & 0xFFFF);
            n |= n4;
            n2 &= n4 - 1;
            ++n3;
        }
        return (n & Integer.MIN_VALUE) == 0 || (n2 & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void setDescription(String string) {
        this.desc = string;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public short[] getData() {
        return this.data;
    }

    @Override
    public int getBitsStored() {
        return this.bitsOut;
    }

    @Override
    public int getBitsOfIndex() {
        return this.bitsIn;
    }

    @Override
    public int[] getLUTDescriptor() {
        return new int[]{this.data.length, this.getFirstValueMapped(), this.bitsOut};
    }

    @Override
    public byte[] getLUTData() {
        int n = this.data.length;
        if (n == 65536) {
            n = 0;
        }
        byte[] byArray = new byte[this.data.length * 2];
        int n2 = 0;
        while (n2 < this.data.length) {
            byArray[n2 * 2] = (byte)(this.data[n2] & 0xFF);
            byArray[n2 * 2 + 1] = (byte)(this.data[n2] >> 8 & 0xFF);
            ++n2;
        }
        return byArray;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    private int getFirstValueMapped() {
        return this.isSigned ? -(1 << this.bitsIn - 1) : 0;
    }
}

