/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.descriptors.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.lists.models.ComparatorAdapter;
import com.agfa.pacs.base.swing.lists.models.ExternDataComboBoxModel;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.descriptors.gui.ConditionPanel;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.logging.ALogger;
import com.tiani.util.expressions.OperatorEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DescriptorEditPanel
extends JPanel {
    private static final ALogger log = ALogger.getLogger(DescriptorEditPanel.class);
    private ConditionPanel conditionPanel;
    private JComboBox comboBoxSelectCondition;
    private ExternDataComboBoxModel<Condition> comboBoxModel;
    private JTextField textFieldDescriptorName;
    private boolean ignoreItemStateChangeEvents = false;
    private JLabel delayCausedByChosenTagHelp;

    public DescriptorEditPanel(IComponentFactory iComponentFactory, final Descriptor descriptor, boolean bl) {
        this.comboBoxModel = new ExternDataComboBoxModel(descriptor.conditions(), (Comparator)new ComparatorAdapter());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel3 = new JPanel(gridBagLayout);
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel3.setBorder(iComponentFactory.createTitledBorder(Messages.getString("DescriptorEditPanel.EditConditionSet")));
        this.comboBoxSelectCondition = iComponentFactory.createComboBox(this.comboBoxModel);
        this.textFieldDescriptorName = iComponentFactory.createTextField();
        this.textFieldDescriptorName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                descriptor.setName(DescriptorEditPanel.this.textFieldDescriptorName.getText());
            }
        });
        this.conditionPanel = new ConditionPanel(iComponentFactory, bl);
        this.conditionPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Condition condition = DescriptorEditPanel.this.conditionPanel.getCondition();
                if (condition != null) {
                    DescriptorEditPanel.this.ignoreItemStateChangeEvents = true;
                    DescriptorEditPanel.this.comboBoxModel.removeElement((Object)condition);
                    DescriptorEditPanel.this.comboBoxModel.addElement((Object)condition);
                    DescriptorEditPanel.this.ignoreItemStateChangeEvents = false;
                } else {
                    log.warn("Condition is null");
                }
                DescriptorEditPanel.this.warnOnDelayCausedByTag();
            }
        });
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        jPanel4.setOpaque(false);
        this.conditionPanel.setOpaque(false);
        jPanel2.add(iComponentFactory.createButton((Action)new AddConditionAction()));
        jPanel2.add(iComponentFactory.createButton((Action)new DeleteConditionAction()));
        jPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DescriptorEditPanel.Condition")) + ": "), "West");
        jPanel.add((Component)this.comboBoxSelectCondition, "Center");
        jPanel.add((Component)jPanel2, "East");
        jPanel4.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DescriptorEditPanel.NameConditionSet")) + ": "), "West");
        jPanel4.add((Component)this.textFieldDescriptorName, "Center");
        this.delayCausedByChosenTagHelp = iComponentFactory.createLabel("<html>" + Messages.getString("DicomTagDelayExplanationTitle") + "<br><br>" + Messages.getString("DicomTagDelayExplanationText") + "</html>", GUI.getScaledDimension((int)50, (int)400));
        this.delayCausedByChosenTagHelp.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 15, 5), 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 15, 5), 0, 0);
        gridBagLayout.setConstraints(this.conditionPanel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 15, 5), 0, 0);
        gridBagLayout.setConstraints(this.delayCausedByChosenTagHelp, gridBagConstraints3);
        jPanel3.add(this.conditionPanel);
        jPanel3.add(this.delayCausedByChosenTagHelp);
        jPanel3.add(jPanel);
        this.add((Component)jPanel4, "North");
        this.add((Component)jPanel3, "Center");
        this.comboBoxSelectCondition.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (DescriptorEditPanel.this.ignoreItemStateChangeEvents) {
                    return;
                }
                Object object = DescriptorEditPanel.this.comboBoxSelectCondition.getSelectedItem();
                if (object instanceof Condition) {
                    DescriptorEditPanel.this.conditionPanel.setCondition((Condition)object);
                    DescriptorEditPanel.this.conditionPanel.setEnabled(true);
                } else {
                    DescriptorEditPanel.this.conditionPanel.setCondition(null);
                    DescriptorEditPanel.this.conditionPanel.setEnabled(false);
                }
                DescriptorEditPanel.this.warnOnDelayCausedByTag();
            }
        });
        this.conditionPanel.setEnabled(false);
    }

    private void warnOnDelayCausedByTag() {
        Condition condition = this.conditionPanel.getCondition();
        if (condition != null) {
            if (DescriptorRegistry.getInstance().checkLoadingDelay(condition)) {
                this.delayCausedByChosenTagHelp.setVisible(true);
            } else {
                this.delayCausedByChosenTagHelp.setVisible(false);
            }
        } else {
            this.delayCausedByChosenTagHelp.setVisible(false);
        }
    }

    private class AddConditionAction
    extends AbstractAction {
        public AddConditionAction() {
            super("+");
            super.putValue("ShortDescription", Messages.getString("DescriptorEditPanel.AddNewCondition"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Condition condition = new Condition();
            condition.setTag(528432);
            condition.setOperator(OperatorEnum.EQUAL);
            condition.setValue("...");
            DescriptorEditPanel.this.comboBoxModel.addElement((Object)condition);
            DescriptorEditPanel.this.comboBoxSelectCondition.setSelectedItem(condition);
            DescriptorEditPanel.this.conditionPanel.triggerGrabbingOfFocusByTextField();
            DescriptorEditPanel.this.warnOnDelayCausedByTag();
        }
    }

    private class DeleteConditionAction
    extends AbstractAction {
        public DeleteConditionAction() {
            super("-");
            super.putValue("ShortDescription", Messages.getString("DescriptorEditPanel.DeleteCondition"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = DescriptorEditPanel.this.comboBoxSelectCondition.getSelectedItem();
            if (object instanceof Condition) {
                Condition condition = (Condition)object;
                DescriptorEditPanel.this.comboBoxModel.removeElement((Object)condition);
                if (DescriptorEditPanel.this.comboBoxModel.getSize() > 0) {
                    DescriptorEditPanel.this.comboBoxSelectCondition.setSelectedItem(DescriptorEditPanel.this.comboBoxModel.getElementAt(0));
                } else {
                    DescriptorEditPanel.this.comboBoxSelectCondition.setSelectedItem(null);
                }
                DescriptorEditPanel.this.warnOnDelayCausedByTag();
            }
        }
    }
}

