/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.impaxee.demographics.model.AbstractDemographicsContainerElement;
import com.agfa.pacs.impaxee.demographics.model.DemographicsParagraph;
import com.agfa.pacs.impaxee.demographics.model.DemographicsWordGroup;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsDefinitonChangeListener;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsElementListener;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsLineListener;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.Line;
import com.tiani.config.mappingfonts.model.Wordgroup;

public class DemographicsLine
extends AbstractDemographicsContainerElement<IDemographicsLineListener>
implements IDemographicsElementListener,
IDemographicsDefinitonChangeListener {
    private Line line;
    private DemographicsParagraph parent;

    public DemographicsLine(Line line, DemographicsParagraph demographicsParagraph) {
        super(line.getFont(), demographicsParagraph.getMergedFont(), demographicsParagraph.isQuadMapping());
        this.line = line;
        this.setParent(demographicsParagraph);
    }

    public DemographicsWordGroup[] createMappingWordGroups() {
        DemographicsWordGroup[] demographicsWordGroupArray = new DemographicsWordGroup[this.line.wordgroupCount()];
        int n = 0;
        while (n < demographicsWordGroupArray.length) {
            demographicsWordGroupArray[n] = new DemographicsWordGroup(this.line.getWordgroup(n), this);
            demographicsWordGroupArray[n].registerDemographicsDefinitonChangeListener(this);
            ++n;
        }
        return demographicsWordGroupArray;
    }

    public DemographicsParagraph getParent() {
        return this.parent;
    }

    public void removeWordgroup(DemographicsWordGroup demographicsWordGroup) {
        int n = this.line.indexOf(demographicsWordGroup.getWordgroup());
        if (n >= 0) {
            demographicsWordGroup.removeDemographicsDefinitonChangeListener(this);
            this.line.removeWordgroup(demographicsWordGroup.getWordgroup());
            for (IDemographicsLineListener iDemographicsLineListener : this.mappingElementlisteners) {
                iDemographicsLineListener.wordGroupDeleted(n);
            }
            this.informListenersContentChanged();
        }
    }

    public void addWordgroup(int n, DemographicsWordGroup demographicsWordGroup) {
        demographicsWordGroup.registerDemographicsDefinitonChangeListener(this);
        demographicsWordGroup.setParent(this);
        this.line.addWordgroup(n, demographicsWordGroup.getWordgroup());
        for (IDemographicsLineListener iDemographicsLineListener : this.mappingElementlisteners) {
            iDemographicsLineListener.wordGroupAdded(demographicsWordGroup, n);
        }
        this.informListenersContentChanged();
    }

    public int wordgroupCount() {
        return this.line.wordgroupCount();
    }

    Line getLine() {
        return this.line;
    }

    public String toString() {
        return this.line.toString();
    }

    public int getIndexOf(DemographicsWordGroup demographicsWordGroup) {
        return this.line.indexOf(demographicsWordGroup.getWordgroup());
    }

    public void exchange(int n, int n2) {
        Wordgroup wordgroup = this.line.getWordgroup(n);
        Wordgroup wordgroup2 = this.line.getWordgroup(n2);
        this.line.setWordgroup(n, wordgroup2);
        this.line.setWordgroup(n2, wordgroup);
        for (IDemographicsLineListener iDemographicsLineListener : this.mappingElementlisteners) {
            iDemographicsLineListener.wordGroupsExchanged(n, n2);
        }
        this.informListenersContentChanged();
    }

    @Override
    protected Font createLevelFont() {
        this.line.setFont(new Font());
        return this.line.getFont();
    }

    @Override
    public void mappingDefinitionChanged(Object object) {
        this.informListenersContentChanged();
    }

    public void setParent(DemographicsParagraph demographicsParagraph) {
        this.parent = demographicsParagraph;
    }
}

