/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.base.swing.lists.models.GenericDataMutableListModel;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.demographics.model.DemographicsConfigListEntry;
import com.agfa.pacs.impaxee.demographics.model.DemographicsConfigListEntryComparator;
import com.agfa.pacs.impaxee.utils.FontUtils;
import com.tiani.config.mappingfonts.model.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DemographicsConfigAccess
extends GenericDataMutableListModel<DemographicsConfigListEntry> {
    private static final String DEMOGRAPHICSKEY = Config.impaxee.jvision.MAPPING.demographics.getKey();
    private static final String SEQLABEL_DEMOGRAPHICSKEY = Config.impaxee.jvision.SEQLABEL.demographics.getKey();
    private static final String DEFAULT_ID = "0";
    private IConfigurationList configList;
    private final boolean isQuadMapping;
    private final Font generalMappingFont;
    private final IConfigurationProvider configProvider;

    public DemographicsConfigAccess(IConfigurationProvider iConfigurationProvider, boolean bl) {
        super(new ArrayList(), (Comparator)new DemographicsConfigListEntryComparator());
        this.isQuadMapping = bl;
        this.configProvider = iConfigurationProvider;
        this.generalMappingFont = new Font();
        FontUtils.correctWithConfig(this.generalMappingFont, iConfigurationProvider);
        this.loadData();
        MyConfigurationChangeListener myConfigurationChangeListener = new MyConfigurationChangeListener();
        iConfigurationProvider.registerConfigurationChangeListener(Config.impaxee.jvision.MAPPING.MappingColor.getKey(), (IConfigurationChangeListener)myConfigurationChangeListener);
        iConfigurationProvider.registerConfigurationChangeListener(Config.impaxee.jvision.MAPPING.DisplayFontFace.getKey(), (IConfigurationChangeListener)myConfigurationChangeListener);
        iConfigurationProvider.registerConfigurationChangeListener(Config.impaxee.jvision.MAPPING.DisplayFontSize.getKey(), (IConfigurationChangeListener)myConfigurationChangeListener);
        iConfigurationProvider.registerConfigurationChangeListener(Config.impaxee.jvision.MAPPING.DisplayFontStyle.getKey(), (IConfigurationChangeListener)myConfigurationChangeListener);
    }

    private void loadData() {
        this.configList = this.configProvider.getList(this.isQuadMapping ? DEMOGRAPHICSKEY : SEQLABEL_DEMOGRAPHICSKEY);
        List<Map.Entry<String, IConfigurationProvider>> list = this.cleanAndCompleteConfigList(this.configList);
        for (Map.Entry<String, IConfigurationProvider> entry : list) {
            this.addElementInternal(0, new DemographicsConfigListEntry(entry.getValue(), entry.getKey(), this.isQuadMapping, this.generalMappingFont));
        }
    }

    public void reloadAllEntries() {
        this.removeAll();
        this.loadData();
    }

    private List<Map.Entry<String, IConfigurationProvider>> cleanAndCompleteConfigList(IConfigurationList iConfigurationList) {
        ArrayList<Map.Entry<String, IConfigurationProvider>> arrayList = new ArrayList<Map.Entry<String, IConfigurationProvider>>();
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            if (!iConfigurationProvider.exists("name")) {
                iConfigurationList.remove((String)entry.getKey());
                continue;
            }
            arrayList.add(entry);
        }
        return arrayList;
    }

    public boolean removeElement(DemographicsConfigListEntry demographicsConfigListEntry) {
        if (super.removeElement((Object)demographicsConfigListEntry)) {
            this.configList.remove(demographicsConfigListEntry.getConfigListItemId());
            return true;
        }
        return false;
    }

    public DemographicsConfigListEntry removeElementAt(int n) {
        DemographicsConfigListEntry demographicsConfigListEntry = (DemographicsConfigListEntry)super.removeElementAt(n);
        if (demographicsConfigListEntry != null) {
            this.configList.remove(demographicsConfigListEntry.getConfigListItemId());
        }
        return demographicsConfigListEntry;
    }

    public DemographicsConfigListEntry getNewListItem() {
        IConfigurationProvider iConfigurationProvider = this.configList.appendItem();
        return new DemographicsConfigListEntry(this.makeNameUnique(Messages.getString("Demographics.NewName")), this.isQuadMapping, this.generalMappingFont, iConfigurationProvider, this.configList.getIdOfLastNewElement());
    }

    public DemographicsConfigListEntry addNewListItem(String string) {
        IConfigurationProvider iConfigurationProvider = this.configList.appendItem();
        DemographicsConfigListEntry demographicsConfigListEntry = new DemographicsConfigListEntry(this.makeNameUnique(string), this.isQuadMapping, this.generalMappingFont, iConfigurationProvider, this.configList.getIdOfLastNewElement());
        this.addElement(demographicsConfigListEntry);
        return demographicsConfigListEntry;
    }

    public DemographicsConfigListEntry getNewListItem(DemographicsConfigListEntry demographicsConfigListEntry) {
        IConfigurationProvider iConfigurationProvider = this.configList.appendItem();
        return new DemographicsConfigListEntry(demographicsConfigListEntry, this.makeNameUnique(demographicsConfigListEntry.getName()), iConfigurationProvider, this.configList.getIdOfLastNewElement());
    }

    public DemographicsConfigListEntry getOrCreateNewListItem(String string, String string2) {
        DemographicsConfigListEntry demographicsConfigListEntry = null;
        if (string2 == null || string2.length() == 0) {
            demographicsConfigListEntry = this.getDefaultDemographics();
        }
        if (demographicsConfigListEntry == null) {
            demographicsConfigListEntry = this.addNewListItem(string);
        }
        return demographicsConfigListEntry;
    }

    private DemographicsConfigListEntry getDefaultDemographics() {
        for (DemographicsConfigListEntry demographicsConfigListEntry : this.getAll()) {
            if (!DEFAULT_ID.equals(demographicsConfigListEntry.getConfigListItemId().trim())) continue;
            return demographicsConfigListEntry;
        }
        return null;
    }

    public DemographicsConfigListEntry getExistingListItem(String string) {
        for (DemographicsConfigListEntry demographicsConfigListEntry : this.getAll()) {
            if (!string.equals(demographicsConfigListEntry.getName())) continue;
            return demographicsConfigListEntry;
        }
        return null;
    }

    public boolean isNameUnique(String string) {
        return this.getExistingListItem(string) == null;
    }

    public String makeNameUnique(String string) {
        String string2 = string;
        int n = 0;
        while (!this.isNameUnique(string2)) {
            string2 = String.valueOf(string) + "(" + n + ")";
            ++n;
        }
        return string2;
    }

    public IConfigurationProvider getConfiguration() {
        return this.configProvider;
    }

    public String getListConfigurationKey() {
        return DEMOGRAPHICSKEY;
    }

    private class MyConfigurationChangeListener
    implements IConfigurationChangeListener {
        private MyConfigurationChangeListener() {
        }

        public void configurationChanged(String string) {
            FontUtils.correctWithConfig(DemographicsConfigAccess.this.generalMappingFont, DemographicsConfigAccess.this.configProvider);
            for (DemographicsConfigListEntry demographicsConfigListEntry : DemographicsConfigAccess.this.getAll()) {
                demographicsConfigListEntry.mappingFontChanged();
            }
        }
    }
}

