/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.demographics.model.DemographicsConfigAccess;
import com.agfa.pacs.impaxee.demographics.model.DemographicsConfigListEntry;
import com.agfa.pacs.impaxee.demographics.model.xml.Demographics;
import com.agfa.pacs.impaxee.demographics.model.xml.DemographicsImportExport;
import com.tiani.config.xml.minijaxb.AbstractXmlFileLoader;
import com.tiani.config.xml.minijaxb.ExportParameter;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class DemographicsXmlLoader
extends AbstractXmlFileLoader {
    public static final String FILE_EXTENSION = ".AGM";
    protected final DemographicsConfigAccess demographicsConfigAccess;
    protected final boolean isQuadMapping;

    public DemographicsXmlLoader(DemographicsConfigAccess demographicsConfigAccess, boolean bl) {
        super(ExportParameter.Q1_2009, FILE_EXTENSION);
        this.demographicsConfigAccess = demographicsConfigAccess;
        this.isQuadMapping = bl;
    }

    private DemographicsXmlLoader(boolean bl) {
        this(new DemographicsConfigAccess(ConfigurationProviderFactory.getConfig(), bl), bl);
    }

    public static boolean overloadDemographicsFromFile(File file) {
        return new DemographicsXmlLoader(true).overloadFromFile(file);
    }

    public boolean overloadFromFile(File file) {
        if (file.exists()) {
            int n = this.demographicsConfigAccess.getSize();
            int n2 = n - 1;
            while (n2 >= 0) {
                DemographicsConfigListEntry demographicsConfigListEntry = (DemographicsConfigListEntry)this.demographicsConfigAccess.getElementAt(n2);
                String string = demographicsConfigListEntry.getCondition();
                if (string != null && string.length() > 0) {
                    this.demographicsConfigAccess.removeElementAt(n2);
                }
                --n2;
            }
            return this.importFromFile(file);
        }
        return false;
    }

    protected void saveImportedEntries(Component component, Map<Demographics, DemographicsConfigListEntry> map, boolean bl) {
        ArrayList<DemographicsConfigListEntry> arrayList = new ArrayList<DemographicsConfigListEntry>(map.size());
        ArrayList<DemographicsConfigListEntry> arrayList2 = new ArrayList<DemographicsConfigListEntry>(map.size());
        for (Map.Entry<Demographics, DemographicsConfigListEntry> object : map.entrySet()) {
            DemographicsConfigListEntry demographicsConfigListEntry = object.getValue();
            String string = demographicsConfigListEntry.getName();
            demographicsConfigListEntry.initFrom(object.getKey());
            demographicsConfigListEntry.setName(string);
            switch (demographicsConfigListEntry.saveMappingConfiguration()) {
                case MISSING_PATIENT_NAME: {
                    arrayList.add(demographicsConfigListEntry);
                    break;
                }
                case CANNOT_CREATE_XML: {
                    arrayList2.add(demographicsConfigListEntry);
                    break;
                }
            }
        }
        if (!(!bl || arrayList.isEmpty() && arrayList2.isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            this.appendImportErrors(stringBuilder, Messages.getString("GeneralConfigDemographicsPanel.Import.Error.PatientnameMustBePartOfDemographics"), arrayList);
            this.appendImportErrors(stringBuilder, Messages.getString("GeneralConfigDemographicsPanel.Import.Error.Xml"), arrayList2);
            stringBuilder.append("</html>");
            JOptionPane.showMessageDialog(component, stringBuilder.toString(), Messages.getString("DemographicsXmlLoader.CannotSave"), 0);
        }
    }

    private void appendImportErrors(StringBuilder stringBuilder, String string, Collection<DemographicsConfigListEntry> collection) {
        if (!collection.isEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append("<ul>");
            for (DemographicsConfigListEntry demographicsConfigListEntry : collection) {
                stringBuilder.append("<li>");
                stringBuilder.append(demographicsConfigListEntry.getName());
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</ul>");
        }
    }

    @Override
    protected Class<? extends XmlLoadable> getXmlLoadableClass() {
        return DemographicsImportExport.class;
    }

    @Override
    protected final boolean importSelectedXmlData(Component component, XmlLoadable xmlLoadable, boolean bl) {
        DemographicsImportExport demographicsImportExport = (DemographicsImportExport)xmlLoadable;
        boolean bl2 = Boolean.TRUE.equals(demographicsImportExport.getIsQuadMapping());
        if (bl2 == this.isQuadMapping || bl && JOptionPane.showConfirmDialog(component, Messages.getString("GeneralConfigDemographicsPanel.Import.Warning")) == 0) {
            this.importSelectedDataImpl(component, bl, demographicsImportExport);
        }
        return true;
    }

    protected void importSelectedDataImpl(Component component, boolean bl, DemographicsImportExport demographicsImportExport) {
        HashMap<Demographics, DemographicsConfigListEntry> hashMap = new HashMap<Demographics, DemographicsConfigListEntry>();
        int n = 0;
        while (demographicsImportExport.getDemographics(n) != null) {
            Demographics demographics2 = demographicsImportExport.getDemographics(n);
            if (demographics2 != null) {
                hashMap.put(demographics2, this.demographicsConfigAccess.getOrCreateNewListItem(demographics2.getName(), demographics2.getCondition()));
            }
            ++n;
        }
        this.saveImportedEntries(component, hashMap, bl);
    }
}

