/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.manager;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.HangingEvaluation;
import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.data.manager.IDisplaySetListener;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.hanging.HangingRuntimeManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.ISinglePatientHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.PatientRepresentationComparator;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedHangingsManager;
import com.agfa.pacs.impaxee.hanging.impl.PatientRepresentationFactory;
import com.agfa.pacs.impaxee.hanging.impl.SimpleStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.runtime.DefaultHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortManager;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.IDisposable;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.toptoolbar.PatientInfoAction;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class DataManager {
    private static final ALogger log = ALogger.getLogger(DataManager.class);
    public static final int MAXIMAL_NUMBER_OF_PATIENTS_IN_MEMORY = 2;
    public static volatile boolean RETRIEVE_LOSSY = false;
    private static final String MIX_CR_MODALITY = "CR";
    private static final boolean mergeCRStudies = Config.impaxee.jvision.HANGMAN.MergeCRStudiesOfSameDate.get();
    public static final boolean NEW_STUDIES_GET_ACTIVATED = Config.impaxee.jvision.HANGMAN.NewLoadedStudiesWillBeSelected.get();
    private static final DataManager instance = new DataManager();
    private static IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private IFetcher fetcher = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getFetcher();
    private Map<String, IPatientRepresentation> patientMap;
    private Map<String, IPatientData> patientDataMap;
    private final List<IPatientRepresentation> patients = new ArrayList<IPatientRepresentation>();
    private Set<IDataManagerListener> listeners;
    private List<IDisplaySetListener> displaySetListeners;
    private Map<String, String> temporaryMergedPatients = new HashMap<String, String>();
    private boolean prefLoadKeyImages;
    private volatile boolean isBeingCleared;

    public static DataManager getInstance() {
        return instance;
    }

    private DataManager() {
        this.patientMap = new Hashtable<String, IPatientRepresentation>();
        this.patientDataMap = new Hashtable<String, IPatientData>();
        this.listeners = new CopyOnWriteArraySet<IDataManagerListener>();
        this.displaySetListeners = new ArrayList<IDisplaySetListener>();
    }

    public List<String> getNotLoadedSOPInstanceUIDs(List<String> list, IPatientRepresentation iPatientRepresentation) {
        if (iPatientRepresentation == null) {
            return list;
        }
        for (ISeriesData iSeriesData : iPatientRepresentation.getPatientData().getSeries()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iSeriesData.getObjectsByUID(iterator.next()) == null) continue;
                iterator.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFrameObjectData[] getFrameObjectData(String string, IPatientRepresentation iPatientRepresentation) {
        List<IPatientRepresentation> list;
        assert (string != null) : "No valid sopInstanceUID provided!";
        if (iPatientRepresentation == null) {
            List<IPatientRepresentation> object = this.patients;
            synchronized (object) {
                list = this.getPatientRepresentations();
            }
        } else {
            list = Collections.singletonList(iPatientRepresentation);
        }
        for (IPatientRepresentation iPatientRepresentation2 : list) {
            List<ISeriesData> list2 = iPatientRepresentation2.getPatientData().getSeries();
            for (ISeriesData iSeriesData : list2) {
                IImageObjectData iImageObjectData = iSeriesData.getObjectsByUID(string);
                if (iImageObjectData == null || !(iImageObjectData instanceof IImageObjectData)) continue;
                return iImageObjectData.frames();
            }
        }
        return null;
    }

    public long getRequiredMemory(int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = n;
        long l = 0L;
        long l2 = 0L;
        if (!Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get() && !Product.isReducedVersion()) {
            for (IPatientRepresentation iPatientRepresentation : this.patients) {
                n2 += iPatientRepresentation.getNumberOfStudieContainers();
                n3 += iPatientRepresentation.getNumberOfInstances();
                if (iPatientRepresentation.getNumberOfInstances() <= n4) continue;
                n4 = iPatientRepresentation.getNumberOfInstances();
            }
            l = (long)n2 * Config.impaxee.jvision.memory.StudySize.get();
            l2 = this.patients.size() > 2 ? Config.impaxee.jvision.memory.ObjectSize.get() : Config.impaxee.jvision.memory.ObjectSizeNotInCache.get();
        }
        l += (long)(n3 -= n4) * l2;
        l += (long)n4 * Config.impaxee.jvision.memory.ObjectSizeOfLoadedPatient.get();
        if (log.isDebugEnabled()) {
            log.debug("Currently in IA:" + n2 + " studies," + n4 + " largest Patient," + n3 + " instances in " + this.patients.size() + " patients. Together:" + l);
        }
        return l;
    }

    public IHanging addHangingProtocol(HangingProtocol hangingProtocol, IStudyContainer iStudyContainer) {
        IPatientRepresentation iPatientRepresentation = iStudyContainer.getPatientRepresentation();
        IHanging iHanging = iPatientRepresentation.applyHangingProtocol(hangingProtocol, iStudyContainer);
        this.notifyPatientRepresentationModified(iPatientRepresentation);
        return iHanging;
    }

    public void addSeries(Collection<ISeriesData> collection, boolean bl, boolean bl2) {
        this.addSeriesImpl(collection, bl);
    }

    public List<IDisplaySet> addSeriesAsSingleDisplaySet(Collection<ISeriesData> collection, Object object, boolean bl) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        List<IDisplaySet> list = this.addSeriesImpl(collection, false);
        ISeriesData iSeriesData = collection.iterator().next();
        IPatientRepresentation iPatientRepresentation = this.getPatientRepresentation(iSeriesData.getParent().getParent().getKey());
        IHanging iHanging = iPatientRepresentation.getActiveHanging();
        if (iHanging != null) {
            if (!list.isEmpty()) {
                this.notifyDisplaySetAdded(iPatientRepresentation, list);
            }
            DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
        } else {
            IStudyData iStudyData = iSeriesData.getParent();
            SimpleStudyContainer simpleStudyContainer = new SimpleStudyContainer(iStudyData);
            iPatientRepresentation.addStudyContainer(simpleStudyContainer);
            DefaultHangingProtocolRuntime defaultHangingProtocolRuntime = new DefaultHangingProtocolRuntime(simpleStudyContainer, iPatientRepresentation.getDecompositionRuntime());
            iPatientRepresentation.addHanging(defaultHangingProtocolRuntime);
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, defaultHangingProtocolRuntime, true, true);
            DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
        }
        if (object != null && object instanceof VisDisplay2 && !list.isEmpty()) {
            ((VisDisplay2)object).initVisDisplay(list.get(0), null, true, ActivationMode.MANUAL);
        }
        return list;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private List<IDisplaySet> addSeriesImpl(Collection<ISeriesData> var1_1, boolean var2_2) {
        if (this.isBeingCleared || this.checkRemoveOtherPatients(var1_1)) {
            return Collections.emptyList();
        }
        var3_3 = new HashSet<IPatientRepresentation>();
        var4_4 = new ArrayList<IPatientRepresentation>();
        var5_5 = new HashMap<IPatientRepresentation, ArrayList<Object>>();
        var6_6 = new ArrayList<Iterator<E>>();
        for (Object var7_8 : var1_1) {
            var9_9 = var7_8.getParent();
            var10_10 = var9_9.getParent();
            var11_11 = this.getPatient((IPatientData)var10_10);
            if (var11_11 == null) {
                var11_11 = this.addPatient((IPatientData)var10_10, var2_2);
                var4_4.add(var11_11);
            }
            var3_3.add(var11_11);
            var12_13 = (List)var5_5.get(var11_11);
            if (var12_13 == null) {
                var12_13 = new ArrayList<Object>(20);
                var5_5.put(var11_11, var12_13);
            }
            var12_13.add(var7_8);
            var11_11.getPatientData().touchStudy((IStudyData)var9_9);
        }
        for (Object var7_8 : var3_3) {
            var9_9 = var7_8.getPatientModificationLock();
            var9_9.lock();
            var6_6.add(var9_9);
            var7_8.updateObjectCount();
        }
        var7_8 = null;
        try {
            var9_9 = var5_5.entrySet().iterator();
            if (var9_9.hasNext()) {
                var8_7 = (Map.Entry)var9_9.next();
                var10_10 = (IPatientRepresentation)var8_7.getKey();
                var7_8 = var10_10.getDecompositionRuntime().addSeries((Collection)var8_7.getValue());
            }
            this.applySplitAndSortChange((SplitAndSortChangeSet)var7_8);
        }
        finally {
            ** for (var12_13 : var6_6)
        }
lbl-1000:
        // 1 sources

        {
            var12_13.unlock();
            continue;
        }
lbl46:
        // 1 sources

        if (var4_4.size() > 0) {
            for (Object var8_7 : var4_4) {
                this.notifyPatientAdded((IPatientRepresentation)var8_7);
            }
        }
        return var7_8 != null ? var7_8.getDisplaySetsAdded() : null;
    }

    public IHanging refreshHangings(IPatientRepresentation iPatientRepresentation, boolean bl, boolean bl2) {
        if (!iPatientRepresentation.hasUncheckedStudyContainers()) {
            return null;
        }
        HangingEvaluation hangingEvaluation = HangingRuntimeManager.getInstance().triggerHangingProtocolEvaluation(iPatientRepresentation, !bl2);
        IHanging iHanging = null;
        if (hangingEvaluation == null) {
            boolean bl3;
            boolean bl4 = bl3 = iPatientRepresentation.getActiveHanging() != null;
            if (!bl3) {
                iHanging = this.createDefaultHangingState(iPatientRepresentation.getStudyContainers().get(0));
                iPatientRepresentation.addHanging(iHanging);
                boolean bl5 = bl3 = iPatientRepresentation.getActiveHanging() != null;
                if (!bl3) {
                    DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging, true, false);
                }
            }
        } else {
            iHanging = iPatientRepresentation.applyHangingProtocol(hangingEvaluation.hp, hangingEvaluation.container);
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging, true, false);
        }
        if (bl) {
            this.notifyPatientRepresentationModified(iPatientRepresentation);
        }
        return iHanging;
    }

    private boolean checkRemoveOtherPatients(Collection<ISeriesData> collection) {
        if (Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get() && collection.size() > 0) {
            ISeriesData iSeriesData = collection.iterator().next();
            String string = iSeriesData.getParent().getParent().getKey();
            for (IPatientRepresentation iPatientRepresentation : this.getPatientRepresentations()) {
                if (string.equals(iPatientRepresentation.getPatientKey()) || !this.removePatient(iPatientRepresentation, true, true)) continue;
                return true;
            }
        }
        return false;
    }

    private IPatientRepresentation getPatient(IPatientData iPatientData) {
        return this.patientMap.get(iPatientData.getKey());
    }

    public IPatientData getLoadedPatientData(String string) {
        return this.patientDataMap.get(string);
    }

    private String getSimpleID(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (!attributes.containsValue(0x100021)) {
            return null;
        }
        return String.valueOf(attributes.getString(0x100020)) + "\u00a7" + attributes.getString(0x100021);
    }

    public IPatientData getSimilarPatient(Attributes attributes, Collection<IPatientData> collection) {
        String string;
        Sequence sequence = attributes.getSequence(0x101002);
        HashSet<String> hashSet = new HashSet<String>();
        if (sequence != null && !sequence.isEmpty()) {
            int n = 0;
            while (n < sequence.size()) {
                string = (Attributes)sequence.get(n);
                String string2 = this.getSimpleID((Attributes)string);
                if (string2 != null) {
                    hashSet.add(string2);
                }
                ++n;
            }
        }
        if ((string = this.getSimpleID(attributes)) != null) {
            hashSet.add(string);
        }
        for (IPatientRepresentation iPatientRepresentation : this.patients) {
            if (!this.samePatient(iPatientRepresentation.getPatientData(), hashSet)) continue;
            return iPatientRepresentation.getPatientData();
        }
        if (collection != null) {
            for (IPatientData iPatientData : collection) {
                if (!this.samePatient(iPatientData, hashSet)) continue;
                return iPatientData;
            }
        }
        return null;
    }

    private boolean samePatient(IPatientData iPatientData, Set<String> set) {
        String string = this.getSimpleID(iPatientData.getDicomObject());
        if (string != null && set.contains(string)) {
            return true;
        }
        Sequence sequence = iPatientData.getDicomObject().getSequence(0x101002);
        if (sequence != null && !sequence.isEmpty()) {
            int n = 0;
            while (n < sequence.size()) {
                Attributes attributes = (Attributes)sequence.get(n);
                String string2 = this.getSimpleID(attributes);
                if (string2 != null && set.contains(string2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPatientData getMergedPatient(String string) {
        if (this.temporaryMergedPatients.isEmpty()) {
            return null;
        }
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            String string2;
            block5: {
                string2 = this.temporaryMergedPatients.get(string);
                if (string2 != null) break block5;
                return null;
            }
            return this.patientDataMap.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markTemporaryMerged(String string, List<String> list) {
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            for (String string2 : list) {
                this.temporaryMergedPatients.put(string2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemporaryMergeActiveForPatient(String string) {
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            return this.temporaryMergedPatients.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPatientMergedTo(String string, String string2) {
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            return CompareUtils.equals((Object)this.temporaryMergedPatients.get(string2), (Object)string);
        }
    }

    public boolean isStudyMerged(IStudyData iStudyData) {
        if (iStudyData != null) {
            String string;
            String string2 = iStudyData.getQueryObject().getTreeParent().getKey();
            return !string2.equals(string = iStudyData.getParent().getKey());
        }
        return false;
    }

    private IPatientRepresentation addPatient(IPatientData iPatientData, boolean bl) {
        AbstractPAction.notifyNonPActionPerformed("ADD_PATIENT");
        IPatientRepresentation iPatientRepresentation = PatientRepresentationFactory.getInstance().newPatientRepresentation(iPatientData);
        iPatientRepresentation.setDecompositionRuntime(SplitAndSortManager.getInstance().getAppropriateSplitAndSortRuntime(iPatientRepresentation));
        this.patientMap.put(iPatientRepresentation.getPatientData().getKey(), iPatientRepresentation);
        this.patients.add(iPatientRepresentation);
        this.patientDataMap.put(iPatientData.getKey(), iPatientData);
        if (!bl && this.patients.size() > 2) {
            iPatientData.storeToCache();
        }
        if (this.patients.size() == 2) {
            iPatientRepresentation.setLoadPriority((byte)6);
        }
        return iPatientRepresentation;
    }

    public void updatePatientInfo() {
        VisData visData = VisData.getLastModified();
        if (visData != null) {
            VisData.patientInfoUpdate(visData.getParent().getDisplaySet());
        }
    }

    public List<IPatientData> getPatientDatas() {
        return new ArrayList<IPatientData>(this.patientDataMap.values());
    }

    public int getPatientCount() {
        return this.patients.size();
    }

    public int getPatientPosition(IPatientRepresentation iPatientRepresentation) {
        return this.patients.indexOf(iPatientRepresentation);
    }

    public IPatientRepresentation getPatientOnPosition(int n) {
        if (n < 0 || n >= this.patients.size()) {
            return null;
        }
        return this.patients.get(n);
    }

    public List<IPatientRepresentation> getPatientRepresentations() {
        return new ArrayList<IPatientRepresentation>(this.patients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IPatientRepresentation, List<IHanging>> getUnsavedHangings() {
        List<IPatientRepresentation> list = this.getPatientRepresentations();
        if (list == null || list.size() == 0) {
            return null;
        }
        HashMap<IPatientRepresentation, List<IHanging>> hashMap = new HashMap<IPatientRepresentation, List<IHanging>>();
        List<IPatientRepresentation> list2 = this.patients;
        synchronized (list2) {
            for (IPatientRepresentation iPatientRepresentation : list) {
                int n = iPatientRepresentation.countHangings();
                ArrayList<IHanging> arrayList = null;
                int n2 = 0;
                while (n2 < n) {
                    IHanging iHanging = iPatientRepresentation.getHanging(n2);
                    if (!(iHanging == null || iHanging instanceof HangingProtocolRuntime || iHanging instanceof Session && !Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions") || iHanging.isSaved())) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<IHanging>(n);
                        }
                        arrayList.add(iHanging);
                    }
                    ++n2;
                }
                if (arrayList == null) continue;
                hashMap.put(iPatientRepresentation, arrayList);
            }
        }
        return hashMap;
    }

    public IPatientRepresentation getPatientRepresentation(String string) {
        return this.patientMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPatientRepresentation getPatientRepresentation(Attributes attributes) {
        String string = PatientKeyUtils.generatePatientKey((Attributes)attributes);
        List<IPatientRepresentation> list = this.getPatientRepresentations();
        List<IPatientRepresentation> list2 = this.patients;
        synchronized (list2) {
            for (IPatientRepresentation iPatientRepresentation : list) {
                if (!PatientKeyUtils.patientKeysEquals((String)string, (String)iPatientRepresentation.getPatientKey())) continue;
                return iPatientRepresentation;
            }
        }
        return null;
    }

    public IPatientRepresentation getPatientRepresentationWeakMatch(Attributes attributes) {
        try {
            String string = attributes.getString(0x100010);
            String string2 = attributes.getString(0x100030);
            List<IPatientRepresentation> list = this.getPatientRepresentations();
            for (IPatientRepresentation iPatientRepresentation : list) {
                Attributes attributes2 = iPatientRepresentation.getPatientData().getDicomObject();
                if (!string.equals(attributes2.getString(0x100010)) || string2 != null && !string2.equals(attributes2.getString(0x100030))) continue;
                return iPatientRepresentation;
            }
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
        }
        return null;
    }

    public ISeriesData getSerie(String string) {
        ISeriesData iSeriesData = null;
        for (IPatientData iPatientData : this.getPatientDatas()) {
            iSeriesData = iPatientData.getSerie(string);
            if (iSeriesData == null) continue;
            return iSeriesData;
        }
        return null;
    }

    public IDataObject removePatient(String string, boolean bl) {
        IPatientRepresentation iPatientRepresentation = this.getPatientRepresentation(string);
        if (iPatientRepresentation != null) {
            this.removePatient(iPatientRepresentation, bl, true);
            return iPatientRepresentation.getPatientData();
        }
        return null;
    }

    private boolean removePatient(IPatientRepresentation iPatientRepresentation, boolean bl, boolean bl2) {
        assert (iPatientRepresentation != null) : "can not remove null patient: " + iPatientRepresentation;
        if (bl) {
            try {
                if (!new UnsavedHangingsManager().manageSave(JVision2.getMainFrame(), iPatientRepresentation, null)) {
                    return true;
                }
            }
            catch (Exception exception) {
                log.error(null, (Throwable)exception);
                return true;
            }
        }
        if (this.patientMap.remove(iPatientRepresentation.getPatientData().getKey()) != null) {
            this.patients.remove(iPatientRepresentation);
            this.patientDataMap.remove(iPatientRepresentation.getPatientData().getKey());
            this.cleanMergedMap(iPatientRepresentation.getPatientData().getKey());
            if (bl) {
                this.notifyPatientRemoved(iPatientRepresentation);
            }
            if (bl2) {
                iPatientRepresentation.cleanUp();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMergedMap(String string) {
        if (this.temporaryMergedPatients.isEmpty()) {
            return;
        }
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            Iterator<Map.Entry<String, String>> iterator = this.temporaryMergedPatients.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(string)) continue;
                iterator.remove();
            }
        }
    }

    public void removeHangingState(IHanging iHanging) {
        Collection<IPatientRepresentation> collection;
        boolean bl = true;
        if (iHanging instanceof ISinglePatientHanging) {
            IPatientRepresentation iPatientRepresentation = ((ISinglePatientHanging)iHanging).getPatient();
            bl = this.removeHangingStateFromPatient(iPatientRepresentation, iHanging);
        } else if (iHanging instanceof IMultiplePatientHanging && (collection = ((IMultiplePatientHanging)iHanging).getPatients()) != null) {
            for (IPatientRepresentation iPatientRepresentation : collection) {
                bl &= this.removeHangingStateFromPatient(iPatientRepresentation, iHanging);
            }
        }
        if (bl) {
            this.notifyHangingStateRemoved(iHanging);
        }
    }

    private boolean removeHangingStateFromPatient(IPatientRepresentation iPatientRepresentation, IHanging iHanging) {
        if (iPatientRepresentation.removeHanging(iHanging.getIdentifier()) != null) {
            if (iPatientRepresentation.countHangings() <= 0) {
                iPatientRepresentation.addHanging(this.createDefaultHangingState(iHanging.getStudyContainer()));
            }
            return true;
        }
        return false;
    }

    public IStudyData getStudyByStudyInstanceUID(String string) {
        for (IPatientData iPatientData : this.getPatientDatas()) {
            for (IStudyData iStudyData : iPatientData.getStudies()) {
                if (!iStudyData.getStudyInstanceUID().equals(string)) continue;
                return iStudyData;
            }
        }
        return null;
    }

    public synchronized IStudyData createStudy(IStudyInfo iStudyInfo, IPatientData iPatientData, int n, Class<? extends IStudyData> clazz) {
        IStudyData iStudyData = this.getStudy(iStudyInfo, iPatientData);
        try {
            if (iStudyData == null) {
                Constructor<? extends IStudyData> constructor = clazz.getConstructor(IStudyInfo.class, Integer.TYPE);
                iStudyData = constructor.newInstance(iStudyInfo, n);
                iStudyData.setParent(iPatientData);
                iPatientData.addStudy(iStudyData, false);
            }
        }
        catch (Exception exception) {
            log.error("Could not create a new study", (Throwable)exception);
        }
        return iStudyData;
    }

    public IStudyData getStudy(IStudyInfo iStudyInfo, IPatientData iPatientData) {
        IStudyData iStudyData = null;
        String string = iStudyInfo.getKey();
        iStudyData = iPatientData.getStudy(string);
        if (iStudyData != null) {
            return iStudyData;
        }
        if (iStudyInfo.getModalitiesInStudy().contains(MIX_CR_MODALITY) && mergeCRStudies) {
            Date date = DateTimeUtils.getStudyDateTime((IDataInfo)iStudyInfo);
            if (date == null) {
                return null;
            }
            for (IStudyData iStudyData2 : iPatientData.getStudies()) {
                Date date2 = DateTimeUtils.getStudyDateTime((Attributes)iStudyData2.getDicomObject());
                if (!CompareUtils.equals((Object)date, (Object)date2) || !((IStudyInfo)iStudyData2.getQueryObject()).getModalitiesInStudy().contains(MIX_CR_MODALITY)) continue;
                return iStudyData2;
            }
        }
        return null;
    }

    public IStudyData getStudy(String string) {
        IStudyData iStudyData = null;
        for (IPatientData iPatientData : this.getPatientDatas()) {
            iStudyData = iPatientData.getStudy(string);
            if (iStudyData == null) continue;
            return iStudyData;
        }
        return null;
    }

    public List<IStudyData> getAllStudies() {
        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
        ArrayList<IPatientData> arrayList2 = new ArrayList<IPatientData>(this.patientDataMap.values());
        for (IPatientData iPatientData : arrayList2) {
            arrayList.addAll(iPatientData.getStudies());
        }
        return arrayList;
    }

    public void clearAllData() {
        try {
            this.isBeingCleared = true;
            this.removeAllPatients(false);
        }
        finally {
            this.isBeingCleared = false;
        }
    }

    public void removeAllPatients(boolean bl) {
        if (bl && !new UnsavedHangingsManager().manageSave(JVision2.getMainFrame(), null, null)) {
            return;
        }
        for (IPatientRepresentation iPatientRepresentation : this.getPatientRepresentations()) {
            this.removePatient(iPatientRepresentation, false, false);
            this.notifyPatientRemoved(iPatientRepresentation);
            iPatientRepresentation.cleanUp();
        }
    }

    public void setPreferablyLoadKeyImagesEnabled(boolean bl) {
        this.prefLoadKeyImages = bl;
    }

    public boolean isPreferablyLoadKeyImagesEnabled() {
        return this.prefLoadKeyImages;
    }

    public void sortPatients() {
        PatientRepresentationComparator patientRepresentationComparator = new PatientRepresentationComparator();
        Collections.sort(this.patients, patientRepresentationComparator);
        this.notifyPatientsSorted(patientRepresentationComparator);
    }

    public void studyAdded(IPatientData iPatientData, IStudyData iStudyData) {
        this.notifyStudyAdded(iPatientData, iStudyData);
    }

    public void studyRemoved(IPatientData iPatientData, IStudyData iStudyData) {
        dicomCache.unregisterStudyUsage(iStudyData.getKey(), (IDisposable)iStudyData);
        this.notifyStudyRemoved(iPatientData, iStudyData);
    }

    public void removeDisplaySet(IDisplaySet[] iDisplaySetArray, boolean bl) {
        Object object;
        if (iDisplaySetArray == null || iDisplaySetArray.length == 0) {
            return;
        }
        ISplitAndSortRuntime iSplitAndSortRuntime = iDisplaySetArray[0].getSplitAndSortRuntime();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDisplaySetArray2[n2];
            iSplitAndSortRuntime.removeDisplaySet((IDisplaySet)object);
            ++n2;
        }
        this.notifyDisplaySetRemoved(Arrays.asList(iDisplaySetArray), false);
        if (bl) {
            iDisplaySetArray2 = iDisplaySetArray;
            n = iDisplaySetArray.length;
            n2 = 0;
            while (n2 < n) {
                object = iDisplaySetArray2[n2];
                object.cancelRetrieve();
                ++n2;
            }
            if (iSplitAndSortRuntime.getDisplaySetCount() == 0) {
                this.removeData(iSplitAndSortRuntime.getPatientRepresentation().getPatientData(), null);
            } else {
                object = new HashSet();
                IDisplaySet[] iDisplaySetArray3 = iSplitAndSortRuntime.getDisplaySets();
                int n3 = iDisplaySetArray3.length;
                n = 0;
                while (n < n3) {
                    IDisplaySet iDisplaySet = iDisplaySetArray3[n];
                    object.add(iDisplaySet.getOneObject().getMainFrame().getParent().getParent().getKey());
                    ++n;
                }
                ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
                for (IStudyData iStudyData : iSplitAndSortRuntime.getPatientRepresentation().getPatientData().getStudies()) {
                    if (object.contains(iStudyData.getKey())) continue;
                    arrayList.add(iStudyData);
                }
                if (!arrayList.isEmpty()) {
                    this.removeData(null, arrayList);
                }
            }
        }
    }

    public void addListener(IDataManagerListener iDataManagerListener) {
        this.listeners.add(iDataManagerListener);
    }

    public void addDisplaySetListener(IDisplaySetListener iDisplaySetListener) {
        this.displaySetListeners.add(iDisplaySetListener);
    }

    public void removeListener(IDataManagerListener iDataManagerListener) {
        this.listeners.remove(iDataManagerListener);
    }

    public IFetcher getFetcher() {
        return this.fetcher;
    }

    public IStore getDataStore() {
        return DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getStore();
    }

    public IPerform getDataPerform(String string) {
        return DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform(string);
    }

    public void applySplitAndSortChange(final SplitAndSortChangeSet splitAndSortChangeSet) {
        if (splitAndSortChangeSet != null) {
            EventUtil.invoke((Runnable)new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    void var6_11;
                    PatientInfoAction patientInfoAction = (PatientInfoAction)PActionRegistry.getAction("PATIENT_INFO");
                    if (patientInfoAction != null) {
                        patientInfoAction.setUpdateEnabled(false);
                    }
                    IFrameObjectData iFrameObjectData = null;
                    IDisplaySet iDisplaySet = null;
                    IDisplaySet iDisplaySet2 = null;
                    if (VisData.getLastModified() != null) {
                        iFrameObjectData = VisData.getLastModified().getFrameData();
                        iDisplaySet = VisData.getLastModified().getParent().getDisplaySet();
                    }
                    DataManager.this.notifyDisplaySetRemoved(splitAndSortChangeSet.getDisplaySetsRemoved(), false);
                    IPatientRepresentation iPatientRepresentation = splitAndSortChangeSet.getSplitAndSortRuntime().getPatientRepresentation();
                    for (Map.Entry<IDisplaySet, IDisplaySet> object : splitAndSortChangeSet.getDisplaySetsChanged().entrySet()) {
                        if (object.getKey() == iDisplaySet) {
                            iDisplaySet2 = object.getValue();
                        }
                        DataManager.this.replaceDisplaySet(iPatientRepresentation, object.getKey(), object.getValue());
                    }
                    DataManager.this.notifyDisplaySetAdded(iPatientRepresentation, splitAndSortChangeSet.getDisplaySetsAdded());
                    if (iDisplaySet2 != null) {
                        block1: for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                            if (visDisplay2.getData().getDisplaySet() != iDisplaySet2) continue;
                            for (VisData visData : visDisplay2.getData().getVis()) {
                                if (visData.getFrameData() != iFrameObjectData) continue;
                                visData.makeTheLastModified();
                                break block1;
                            }
                        }
                    }
                    boolean bl = false;
                    while (var6_11 < iPatientRepresentation.countHangings()) {
                        if (iPatientRepresentation.getHanging((int)var6_11) instanceof HangingProtocolRuntime) {
                            HangingDefinitionRuntime hangingDefinitionRuntime = ((HangingProtocolRuntime)iPatientRepresentation.getHanging((int)var6_11)).getHangingDefinition();
                            int n = 0;
                            while (n < hangingDefinitionRuntime.getSnapshotCount()) {
                                hangingDefinitionRuntime.getSnapshot(n).setHangingApplied(false);
                                ++n;
                            }
                        }
                        ++var6_11;
                    }
                    if (patientInfoAction != null) {
                        patientInfoAction.setUpdateEnabled(true);
                        if (iPatientRepresentation.getDecompositionRuntime().getDisplaySetCount() == 0) {
                            patientInfoAction.setCurrentData(null);
                        }
                    }
                }
            });
        }
    }

    private IHanging createDefaultHangingState(IStudyContainer iStudyContainer) {
        DefaultHangingProtocolRuntime defaultHangingProtocolRuntime = new DefaultHangingProtocolRuntime(iStudyContainer, iStudyContainer.getPatientRepresentation().getDecompositionRuntime());
        return defaultHangingProtocolRuntime;
    }

    private void replaceDisplaySet(IPatientRepresentation iPatientRepresentation, IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2) {
        if (iDisplaySet != null) {
            iDisplaySet.cancelRetrieve();
            Collection<VisDisplay2> collection = this.findVisDisplays(iDisplaySet);
            if (collection != null && !collection.isEmpty()) {
                for (VisDisplay2 visDisplay2 : collection) {
                    int n;
                    IFrameObjectData iFrameObjectData = null;
                    int n2 = visDisplay2.getNavigPos();
                    if (n2 >= 0 && n2 < visDisplay2.getVisCount()) {
                        iFrameObjectData = visDisplay2.getVis(n2).getFrameData();
                    }
                    this.notifyDisplaySetRemoved(Collections.singletonList(iDisplaySet), true);
                    if (iDisplaySet2 == null) continue;
                    this.notifyDisplaySetAdded(iPatientRepresentation, Collections.singletonList(iDisplaySet2));
                    n2 = 0;
                    if (iFrameObjectData != null && (n = Arrays.asList(iDisplaySet2.getObjects()).indexOf(iFrameObjectData)) >= 0) {
                        n2 = n;
                    }
                    visDisplay2.initVisDisplay(iDisplaySet2, n2, false, ActivationMode.DEFAULT, null);
                }
            } else {
                this.notifyDisplaySetRemoved(Collections.singletonList(iDisplaySet), false);
                if (iDisplaySet2 != null) {
                    this.notifyDisplaySetAdded(iPatientRepresentation, Collections.singletonList(iDisplaySet2));
                }
            }
        }
    }

    private Collection<VisDisplay2> findVisDisplays(IDisplaySet iDisplaySet) {
        ArrayList<VisDisplay2> arrayList = null;
        for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                IDisplaySet iDisplaySet2 = visDisplay2.getData().getDisplaySet();
                if (iDisplaySet2 == null || iDisplaySet2.getID() != iDisplaySet.getID()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<VisDisplay2>();
                }
                arrayList.add(visDisplay2);
            }
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    private void notifyPatientAdded(final IPatientRepresentation iPatientRepresentation) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataManagerListener iDataManagerListener : DataManager.this.listeners) {
                    iDataManagerListener.patientAdded(iPatientRepresentation);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyPatientRepresentationModified(final IPatientRepresentation iPatientRepresentation) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataManagerListener iDataManagerListener : DataManager.this.listeners) {
                    iDataManagerListener.patientRepresentationModified(iPatientRepresentation);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyPatientRemoved(final IPatientRepresentation iPatientRepresentation) {
        if (this.patients.size() == 0) {
            this.fetcher.resetState();
            RawDataContainerTokenCreator.getInstance().clear();
            log.info("Clearing loading queue");
        }
        FrameOfReferenceManager.clearAllFrames();
        FrameOfReferenceManager.removeFramesOfPatient(iPatientRepresentation.getPatientKey());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataManagerListener iDataManagerListener : DataManager.this.listeners) {
                    iDataManagerListener.patientRemoved(iPatientRepresentation);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyPatientsSorted(final Comparator<IPatientRepresentation> comparator) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataManagerListener iDataManagerListener : DataManager.this.listeners) {
                    iDataManagerListener.patientsSorted(comparator);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyHangingStateRemoved(final IHanging iHanging) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataManagerListener iDataManagerListener : DataManager.this.listeners) {
                    iDataManagerListener.hangingStateRemoved(iHanging);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyDisplaySetRemoved(final List<IDisplaySet> list, final boolean bl) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (IDisplaySet object2 : list) {
            object2.cancelRetrieve();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object2;
                IDisplaySet[] iDisplaySetArray = list.toArray(new IDisplaySet[0]);
                for (Object object2 : DataManager.this.displaySetListeners) {
                    if (bl && VisDisplay2.isClearDisplaySetListener((IDisplaySetListener)object2)) continue;
                    object2.displaySetsRemoved(iDisplaySetArray);
                }
                object2 = DataSelectionManager.getInstance().getCurrentPatient();
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.countHangings()) {
                        object2.getHanging(n).displaySetsRemoved(iDisplaySetArray);
                        ++n;
                    }
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyRepaintDisplaySets() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDisplaySetListener iDisplaySetListener : DataManager.this.displaySetListeners) {
                    iDisplaySetListener.repaintDisplaySets();
                }
            }
        };
        try {
            EventUtil.invoke((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void notifyDisplaySetAdded(final IPatientRepresentation iPatientRepresentation, final List<IDisplaySet> list) {
        Object object;
        if (list == null || list.isEmpty()) {
            return;
        }
        if (iPatientRepresentation.equals(DataSelectionManager.getInstance().getCurrentPatient())) {
            object = new ArrayList(256);
            for (IDisplaySet iDisplaySet : list) {
                object.addAll(iDisplaySet.getLoadable());
            }
            if (!object.isEmpty()) {
                this.fetcher.appendData((List<? extends IFetchable>)object, (byte)5);
            }
        }
        object = new Runnable(){

            @Override
            public void run() {
                for (IDisplaySetListener iDisplaySetListener : DataManager.this.displaySetListeners) {
                    iDisplaySetListener.displaySetAdded(iPatientRepresentation, list);
                }
                int n = 0;
                while (n < iPatientRepresentation.countHangings()) {
                    iPatientRepresentation.getHanging(n).displaySetAdded(iPatientRepresentation, list);
                    ++n;
                }
            }
        };
        this.executeInEventThread((Runnable)object);
    }

    private void notifyStudyAdded(IPatientData iPatientData, final IStudyData iStudyData) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDisplaySetListener iDisplaySetListener : DataManager.this.displaySetListeners) {
                    iDisplaySetListener.studyAdded(iStudyData);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyStudyRemoved(final IPatientData iPatientData, final IStudyData iStudyData) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object2;
                for (Object object2 : DataManager.this.displaySetListeners) {
                    object2.studyRemoved(iStudyData);
                }
                object2 = DataManager.this.getPatient(iPatientData);
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.countHangings()) {
                        object2.getHanging(n).studyRemoved(iStudyData);
                        ++n;
                    }
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void executeInEventThread(Runnable runnable) {
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void removeData(IPatientData iPatientData, List<IStudyData> list) {
        ArrayList<IDataObject> arrayList = new ArrayList<IDataObject>();
        HashMap<String, IPatientRepresentation> hashMap = new HashMap<String, IPatientRepresentation>();
        hashMap.putAll(this.patientMap);
        if (list != null) {
            for (IStudyData iStudyData : list) {
                arrayList.add(iStudyData.getParent().removeStudy(iStudyData));
            }
        }
        if (iPatientData != null) {
            arrayList.add(DataManager.getInstance().removePatient(iPatientData.getKey(), false));
        }
        HashSet<IPatientRepresentation> hashSet = new HashSet<IPatientRepresentation>();
        for (Object e : arrayList) {
            Object object;
            if (e == null) continue;
            if (e instanceof IPatientData) {
                object = (IPatientRepresentation)hashMap.get(((IPatientData)e).getKey());
                this.notifyPatientRemoved((IPatientRepresentation)object);
                continue;
            }
            if (!(e instanceof IStudyData)) continue;
            object = ((IStudyData)e).getParent().getKey();
            IPatientRepresentation iPatientRepresentation = (IPatientRepresentation)hashMap.get(object);
            hashSet.add(iPatientRepresentation);
        }
        for (IPatientRepresentation iPatientRepresentation : hashSet) {
            if (iPatientRepresentation.getPatientData().getStudies().isEmpty()) {
                this.notifyPatientRemoved(iPatientRepresentation);
                continue;
            }
            iPatientRepresentation.updateObjectCount();
            this.notifyPatientRepresentationModified(iPatientRepresentation);
            iPatientRepresentation.updateStudyContainers();
        }
    }
}

