/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cache;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class ByteGrayscaleBufferedImageHolder
extends BufferedImageHolder {
    public final byte[] data;

    public ByteGrayscaleBufferedImageHolder(int n, int n2) {
        super(n, n2, 10);
        this.data = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    private ByteGrayscaleBufferedImageHolder(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.data = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    @Override
    public ByteGrayscaleBufferedImageHolder getSubImage(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = this.image.getSubimage(n, n2, n3, n4);
        ByteGrayscaleBufferedImageHolder byteGrayscaleBufferedImageHolder = new ByteGrayscaleBufferedImageHolder(bufferedImage);
        byteGrayscaleBufferedImageHolder.iofs = n + n2 * this.width;
        byteGrayscaleBufferedImageHolder.iline = this.width;
        return byteGrayscaleBufferedImageHolder;
    }

    public byte[] getImageArray() {
        return this.data;
    }

    @Override
    public void clear(int n) {
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = (byte)n;
            ++n2;
        }
    }

    @Override
    public boolean isGrayscale() {
        return true;
    }
}

