/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.attributefilter;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.attributes.Instance;
import com.agfa.pacs.impaxee.hanging.attributes.Patient;
import com.agfa.pacs.impaxee.hanging.attributes.Series;
import com.agfa.pacs.impaxee.hanging.attributes.Study;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AttributeFilterRegistry {
    private static final ALogger log = ALogger.getLogger(AttributeFilterRegistry.class);
    private static final AttributeFilterRegistry instance = new AttributeFilterRegistry();
    private Patient patientTags;
    private Study studyTags;
    private Series seriesTags;
    private Instance instanceTags;

    public AttributeFilterRegistry() {
        this.loadFromConfig();
    }

    private void loadFromConfig() {
        String string = Config.impaxee.jvision.HANGMAN.attributeFilter.patient.get();
        String string2 = Config.impaxee.jvision.HANGMAN.attributeFilter.study.get();
        String string3 = Config.impaxee.jvision.HANGMAN.attributeFilter.series.get();
        String string4 = Config.impaxee.jvision.HANGMAN.attributeFilter.instance.get();
        try {
            this.patientTags = (Patient)((Object)new XmlLoader().load(string, Patient.class));
        }
        catch (MarshalException marshalException) {
            log.error("Patient level of attribute filter could not be parsed.");
        }
        try {
            this.studyTags = (Study)((Object)new XmlLoader().load(string2, Study.class));
        }
        catch (MarshalException marshalException) {
            log.error("Study level of attribute filter could not be parsed.");
        }
        try {
            this.seriesTags = (Series)((Object)new XmlLoader().load(string3, Series.class));
        }
        catch (MarshalException marshalException) {
            log.error("Series level of attribute filter could not be parsed.");
        }
        try {
            this.instanceTags = (Instance)((Object)new XmlLoader().load(string4, Instance.class));
        }
        catch (MarshalException marshalException) {
            log.error("Instance level of attribute filter could not be parsed.");
        }
    }

    public static AttributeFilterRegistry getInstance() {
        return instance;
    }

    public List<DicomTag> getPatientDicomTags() {
        return this.patientTags.createDicomTagList(false);
    }

    public List<DicomTag> getStudyDicomTags() {
        return this.studyTags.createDicomTagList(false);
    }

    public List<DicomTag> getSeriesDicomTags() {
        return this.seriesTags.createDicomTagList(false);
    }

    public List<DicomTag> getInstanceDicomTags() {
        return this.instanceTags.createDicomTagList(false);
    }

    public Set<DicomTag> getCFindTags() {
        HashSet<DicomTag> hashSet = new HashSet<DicomTag>();
        hashSet.addAll(this.getPatientDicomTags());
        hashSet.addAll(this.getStudyDicomTags());
        hashSet.addAll(this.getSeriesDicomTags());
        hashSet.addAll(this.getInstanceDicomTags());
        hashSet.addAll(TagDictionary.getInstance().getAllPrivateTagsAsList());
        hashSet.add(TagDictionary.getInstance().getDicomTag(Integer.valueOf(2134102)));
        hashSet.add(TagDictionary.getInstance().getDicomTag(Integer.valueOf(2134312)));
        hashSet.add(TagDictionary.getInstance().getDicomTag(Integer.valueOf(2134103)));
        hashSet.add(TagDictionary.getInstance().getDicomTag(Integer.valueOf(2135123)));
        hashSet.add(TagDictionary.getInstance().getDicomTag(Integer.valueOf(2134359)));
        hashSet.add(TagDictionary.getInstance().getDicomTag(Integer.valueOf(524386)));
        return hashSet;
    }
}

