/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.controls.JSeparator2;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorLabel;
import com.tiani.jvision.toptoolbar.DisplayLayoutChooserDataAction;
import com.tiani.jvision.toptoolbar.VariableLayoutChooserDataAction;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class LayoutChooserPopupMenu
extends JPopupMenu {
    private static final ALogger log = ALogger.getLogger(LayoutChooserPopupMenu.class);
    private static final ComponentFactory cfac = ComponentFactory.instance;
    private static final IAIconFactory ifac = IAIconFactory.DEFAULT_FACTORY;
    private IInternalLayoutSelectionHandler selectionHandler = new IInternalLayoutSelectionHandler(){

        @Override
        public void layoutSelected(ILayoutSelectionSource iLayoutSelectionSource) {
            LayoutChooserPopupMenu.this.setVisible(false);
            LayoutChooserPopupMenu.this.onLayoutSelected(iLayoutSelectionSource);
        }

        @Override
        public void layoutSelectionEntered(ILayoutSelectionSource iLayoutSelectionSource) {
            if (iLayoutSelectionSource != null) {
                LayoutChooserPopupMenu.this.infoLabel.setText(String.valueOf(iLayoutSelectionSource.getCols()) + " x " + iLayoutSelectionSource.getRows());
            } else {
                LayoutChooserPopupMenu.this.infoLabel.setText("");
            }
        }

        @Override
        public void layoutSelectionExited(ILayoutSelectionSource iLayoutSelectionSource) {
            LayoutChooserPopupMenu.this.infoLabel.setText("");
        }
    };
    private JLabel infoLabel;

    private LayoutChooserPopupMenu() {
        LayoutSelectionPanel layoutSelectionPanel = new LayoutSelectionPanel(8, 8);
        layoutSelectionPanel.setSelectionHandler(this.selectionHandler);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, GUI.getScaledDiagnosticInt((int)10), -1.0}, new double[]{-2.0, GUI.getScaledDiagnosticInt((int)10), -2.0});
        tableLayout.setHGap(0);
        tableLayout.setVGap(0);
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)this.createPresetsToolbar(), "0,0");
        this.add((Component)new JSeparator2(JSeparator2.SeparatorOrientation.VERTICAL, JSeparator2.SeparatorType.LINE, null), "1,0");
        this.add((Component)layoutSelectionPanel, "2,0");
        this.add((Component)new JSeparator2(JSeparator2.SeparatorOrientation.HORIZONTAL, JSeparator2.SeparatorType.LINE, null), "0,1,2,1");
        this.infoLabel = this.createInfoLabel();
        this.add((Component)this.infoLabel, "0,2,2,2");
    }

    public static LayoutChooserPopupMenu createPopupMenu(final ILayoutSelectionHandler iLayoutSelectionHandler) {
        return new LayoutChooserPopupMenu(){

            @Override
            protected void onLayoutSelected(ILayoutSelectionSource iLayoutSelectionSource) {
                if (iLayoutSelectionSource != null) {
                    try {
                        iLayoutSelectionHandler.layoutSelected(iLayoutSelectionSource);
                    }
                    catch (Exception exception) {
                        log.error(null, (Throwable)exception);
                    }
                }
            }
        };
    }

    public static LayoutChooserPopupMenu createDisplayLayoutPopupMenu(final DisplayLayoutChooserDataAction.DisplayLayoutChooserAction displayLayoutChooserAction) {
        return new LayoutChooserPopupMenu(){

            @Override
            protected void onLayoutSelected(ILayoutSelectionSource iLayoutSelectionSource) {
                if (iLayoutSelectionSource != null) {
                    try {
                        displayLayoutChooserAction.perform(iLayoutSelectionSource.getCols(), iLayoutSelectionSource.getRows());
                    }
                    catch (Exception exception) {
                        log.error(null, (Throwable)exception);
                    }
                }
            }
        };
    }

    public static LayoutChooserPopupMenu createVariableLayoutPopupMenu(final VariableLayoutChooserDataAction.VariableLayoutChooserAction variableLayoutChooserAction) {
        return new LayoutChooserPopupMenu(){

            @Override
            protected void onLayoutSelected(ILayoutSelectionSource iLayoutSelectionSource) {
                if (iLayoutSelectionSource != null) {
                    try {
                        variableLayoutChooserAction.perform(iLayoutSelectionSource.getCols(), iLayoutSelectionSource.getRows());
                    }
                    catch (Exception exception) {
                        log.error(null, (Throwable)exception);
                    }
                }
            }
        };
    }

    protected abstract void onLayoutSelected(ILayoutSelectionSource var1);

    private JLabel createInfoLabel() {
        JLabel jLabel = cfac.createLabel("");
        jLabel.setPreferredSize(GUI.getScaledDiagnosticDimension((int)10, (int)24));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    private JToolBar createPresetsToolbar() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(this.createPresetButton(ifac.loadIcon("layout-1x1.svg"), 1, 1));
        jToolBar.add(this.createPresetButton(ifac.loadIcon("layout-1x2.svg"), 1, 2));
        jToolBar.add(this.createPresetButton(ifac.loadIcon("layout-2x1.svg"), 2, 1));
        jToolBar.add(this.createPresetButton(ifac.loadIcon("layout-2x2.svg"), 2, 2));
        return jToolBar;
    }

    private JButton createPresetButton(PIcon pIcon, int n, int n2) {
        final PresetLayoutButton presetLayoutButton = new PresetLayoutButton(pIcon, n, n2);
        presetLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayoutChooserPopupMenu.this.selectionHandler.layoutSelected(presetLayoutButton);
            }
        });
        presetLayoutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LayoutChooserPopupMenu.this.selectionHandler.layoutSelectionEntered(presetLayoutButton);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LayoutChooserPopupMenu.this.selectionHandler.layoutSelectionExited(presetLayoutButton);
            }
        });
        presetLayoutButton.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                LayoutChooserPopupMenu.this.selectionHandler.layoutSelectionEntered(presetLayoutButton);
            }
        });
        return presetLayoutButton;
    }

    /* synthetic */ LayoutChooserPopupMenu(LayoutChooserPopupMenu layoutChooserPopupMenu) {
        this();
    }

    private static interface IInternalLayoutSelectionHandler
    extends ILayoutSelectionHandler {
        public void layoutSelectionEntered(ILayoutSelectionSource var1);

        public void layoutSelectionExited(ILayoutSelectionSource var1);
    }

    public static interface ILayoutSelectionHandler {
        public void layoutSelected(ILayoutSelectionSource var1);
    }

    public static interface ILayoutSelectionSource {
        public int getCols();

        public int getRows();

        public String toLayoutString();
    }

    private static class LayoutSelectionPanel
    extends JPanel {
        private static final int border = GUI.getScaledDiagnosticInt((int)2);
        private final GridLayout layout;
        private IInternalLayoutSelectionHandler selectionHandler;
        private final MouseHandler mouseHandler;

        public LayoutSelectionPanel(int n, int n2) {
            this.layout = new GridLayout(n2, n, 0, 0);
            this.setLayout(this.layout);
            this.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            int n3 = 1;
            while (n3 <= n2) {
                int n4 = 1;
                while (n4 <= n) {
                    this.add(new SelectableLayoutLabel(n4, n3));
                    ++n4;
                }
                ++n3;
            }
            this.mouseHandler = new MouseHandler();
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
        }

        public void setSelectionHandler(IInternalLayoutSelectionHandler iInternalLayoutSelectionHandler) {
            this.selectionHandler = iInternalLayoutSelectionHandler;
        }

        public IInternalLayoutSelectionHandler getSelectionHandler() {
            return this.selectionHandler;
        }

        private void updateSelectedLabels(ILayoutSelectionSource iLayoutSelectionSource) {
            int n = iLayoutSelectionSource != null ? iLayoutSelectionSource.getCols() : -1;
            int n2 = iLayoutSelectionSource != null ? iLayoutSelectionSource.getRows() : -1;
            int n3 = 1;
            while (n3 <= this.layout.getRows()) {
                int n4 = 1;
                while (n4 <= this.layout.getColumns()) {
                    SelectableLayoutLabel selectableLayoutLabel = (SelectableLayoutLabel)this.getComponent((n3 - 1) * this.layout.getColumns() + (n4 - 1));
                    if (n4 <= n && n3 <= n2) {
                        selectableLayoutLabel.setSelected(true);
                    } else {
                        selectableLayoutLabel.setSelected(false);
                    }
                    ++n4;
                }
                ++n3;
            }
            if (this.selectionHandler != null) {
                if (iLayoutSelectionSource != null) {
                    this.selectionHandler.layoutSelectionEntered(iLayoutSelectionSource);
                } else {
                    this.selectionHandler.layoutSelectionExited(null);
                }
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SelectableLayoutLabel selectableLayoutLabel;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (selectableLayoutLabel = (SelectableLayoutLabel)LayoutSelectionPanel.this.getComponentAt(mouseEvent.getPoint())) != null && LayoutSelectionPanel.this.selectionHandler != null) {
                    LayoutSelectionPanel.this.selectionHandler.layoutSelected(selectableLayoutLabel);
                    LayoutSelectionPanel.this.updateSelectedLabels(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LayoutSelectionPanel.this.updateSelectedLabels(null);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Component component = LayoutSelectionPanel.this.getComponentAt(mouseEvent.getPoint());
                if (component instanceof SelectableLayoutLabel) {
                    LayoutSelectionPanel.this.updateSelectedLabels((SelectableLayoutLabel)component);
                } else {
                    LayoutSelectionPanel.this.updateSelectedLabels(null);
                }
            }
        }
    }

    private static class PresetLayoutButton
    extends MultiMonitorButton
    implements ILayoutSelectionSource {
        final int rows;
        final int cols;

        public PresetLayoutButton(PIcon pIcon, int n, int n2) {
            super((Icon)pIcon);
            this.rows = n2;
            this.cols = n;
        }

        @Override
        public int getCols() {
            return this.cols;
        }

        @Override
        public int getRows() {
            return this.rows;
        }

        @Override
        public String toLayoutString() {
            return this.cols + "x" + this.rows;
        }
    }

    private static class SelectableLayoutLabel
    extends MultiMonitorLabel
    implements ILayoutSelectionSource {
        private static final PIconFactory ifac = new IAIconFactory(12);
        private static final PIcon emptyIcon = ifac.loadIcon(IAIconFactory.class, "layout-1x1.svg");
        private static final PIcon fullIcon = ifac.loadIcon(IAIconFactory.class, "layout-1x1-full.svg");
        final int rows;
        final int cols;
        boolean selected;

        public SelectableLayoutLabel(int n, int n2) {
            this.rows = n2;
            this.cols = n;
            this.setSelected(false);
            this.setPreferredSize(GUI.getScaledDiagnosticDimension((int)12, (int)12));
        }

        @Override
        public int getCols() {
            return this.cols;
        }

        @Override
        public int getRows() {
            return this.rows;
        }

        @Override
        public String toLayoutString() {
            return this.cols + "x" + this.rows;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.setIcon((Icon)(bl ? fullIcon : emptyIcon));
        }
    }
}

