/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionListener;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.ui.AbstractParentActionUI;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.listtext.swingx.controls.DropDownBox;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class DropDownBoxActionUI
extends AbstractParentActionUI<DropDownBox> {
    private static final ALogger log = ALogger.getLogger(DropDownBoxActionUI.class);
    private PActionListener actionListener;
    private SubActionListener subActionListener;
    private ActionListener buttonListener;
    private PAction selectedAction;
    private boolean prefSizeSet = false;

    public DropDownBoxActionUI(PAction pAction, DropDownBox dropDownBox, ActionUIScope actionUIScope) {
        super(pAction, dropDownBox, actionUIScope);
        assert (!ActionUIUtilities.isExecutable(pAction)) : "create dropdown-box action-ui error: action must not be executable!";
        this.selectedAction = this.getSelectedSubAction(pAction);
        if (this.selectedAction == null && ActionUIUtilities.hasSubActions(pAction)) {
            this.selectedAction = pAction.getSubactions()[0];
        }
        this.bind();
    }

    @Override
    public void bind() {
        super.bind();
        if (this.shouldAdjustNimbusSize()) {
            Dimension dimension = ((DropDownBox)this.getComponent()).getPreferredSize();
            dimension.width += 10;
            dimension.height += 8;
            ((DropDownBox)this.getComponent()).setPreferredSize(dimension);
            this.prefSizeSet = true;
        }
    }

    @Override
    public void release() {
        if (this.prefSizeSet) {
            ((DropDownBox)this.getComponent()).setPreferredSize(null);
            this.prefSizeSet = false;
        }
        super.release();
    }

    @Override
    protected void registerListeners(PAction pAction, DropDownBox dropDownBox) {
        if (this.actionListener == null) {
            this.actionListener = this.createActionListener();
        }
        if (this.buttonListener == null) {
            this.buttonListener = this.createButtonListener();
        }
        pAction.addListener(this.actionListener);
        dropDownBox.addActionListener(this.buttonListener);
    }

    @Override
    protected void unregisterListeners(PAction pAction, DropDownBox dropDownBox) {
        if (this.actionListener != null) {
            pAction.removeListener(this.actionListener);
        }
        if (this.buttonListener != null) {
            dropDownBox.removeActionListener(this.buttonListener);
        }
    }

    @Override
    protected void updateComponent(PAction pAction, DropDownBox dropDownBox, ActionUIScope actionUIScope) {
        super.updateComponent(pAction, dropDownBox, actionUIScope);
        if (this.selectedAction == null) {
            dropDownBox.setText(null);
            dropDownBox.setToolTipText(null);
            dropDownBox.setIcon(null);
            dropDownBox.setRolloverIcon(null);
            dropDownBox.setDisabledIcon(null);
        } else {
            boolean bl = actionUIScope == ActionUIScope.VisMenu || actionUIScope == ActionUIScope.Other;
            Icon icon = this.selectedAction.getIcon(bl);
            Icon icon2 = this.selectedAction.getPopupIcon(bl);
            Icon icon3 = this.selectedAction.getDisabledIcon(bl);
            dropDownBox.setText(icon == null ? this.selectedAction.getCaption() : null);
            dropDownBox.setToolTipText(AbstractPAction.getTooltipTextWithShortcut(this.selectedAction));
            dropDownBox.setSelected(this.selectedAction == this.getSelectedSubAction(this.getAction()));
            dropDownBox.setIcon(icon);
            dropDownBox.setDisabledIcon(icon3);
            dropDownBox.setRolloverIcon(icon2);
            dropDownBox.setRolloverSelectedIcon(icon2);
            if (!pAction.isEnabled()) {
                dropDownBox.setEnabled(false);
            } else if (!this.selectedAction.isEnabled()) {
                dropDownBox.setEnabled(false);
                dropDownBox.setDropDownEnabled();
            }
            if (ActionUIScope.DisplayToolbar.equals((Object)actionUIScope)) {
                dropDownBox.setIconScalingEnabled(true);
            }
        }
    }

    @Override
    protected void bindSubActions() {
        super.bindSubActions();
        PAction[] pActionArray = this.getAction().getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction = pActionArray[n2];
            if (this.subActionListener == null) {
                this.subActionListener = new SubActionListener();
            }
            pAction.addListener(this.subActionListener);
            ++n2;
        }
    }

    @Override
    protected void releaseSubActions() {
        super.releaseSubActions();
        PAction[] pActionArray = this.getAction().getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction = pActionArray[n2];
            pAction.removeListener(this.subActionListener);
            ++n2;
        }
    }

    @Override
    protected void registerSubActionListener(PAction pAction, IActionUI iActionUI) {
        super.registerSubActionListener(pAction, iActionUI);
        if (this.subActionListener == null) {
            this.subActionListener = new SubActionListener();
        }
        if (iActionUI.getComponent() instanceof AbstractButton) {
            ((AbstractButton)iActionUI.getComponent()).addActionListener(this.subActionListener);
        }
    }

    @Override
    protected void unregisterSubActionListener(PAction pAction, IActionUI iActionUI) {
        super.unregisterSubActionListener(pAction, iActionUI);
        if (this.subActionListener != null && iActionUI.getComponent() instanceof AbstractButton) {
            ((AbstractButton)iActionUI.getComponent()).removeActionListener(this.subActionListener);
        }
    }

    @Override
    protected JPopupMenu getParentComponent() {
        return ((DropDownBox)this.getComponent()).getPopupMenu();
    }

    protected ActionListener createButtonListener() {
        return new DropDownBoxListener();
    }

    protected PActionListener createActionListener() {
        return new ParentActionListener();
    }

    private PAction getSelectedSubAction(PAction pAction) {
        PAction[] pActionArray = pAction.getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction2 = pActionArray[n2];
            if (pAction2.isSelected()) {
                return pAction2;
            }
            ++n2;
        }
        return null;
    }

    private boolean shouldAdjustNimbusSize() {
        String string = ((DropDownBox)this.getComponent()).getText();
        return string == null || string.length() == 0 || !ActionUIScope.VisMenu.equals((Object)this.getScope());
    }

    private class DropDownBoxListener
    implements ActionListener {
        private DropDownBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PAction pAction = DropDownBoxActionUI.this.selectedAction;
            if (pAction != null) {
                log.debug("detected ui-trigger (button-click) to execute action " + pAction.getID());
                pAction.perform(ActionUIUtilities.getActionUIContext((DropDownBox)DropDownBoxActionUI.this.getComponent()));
            }
        }
    }

    private class ParentActionListener
    implements PActionListener {
        private ParentActionListener() {
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            ((DropDownBox)DropDownBoxActionUI.this.getComponent()).setEnabled(bl);
        }

        @Override
        public void selectionStateChanged(boolean bl) {
            DropDownBoxActionUI.this.updateComponent(DropDownBoxActionUI.this.getAction(), (DropDownBox)DropDownBoxActionUI.this.getComponent(), (ActionUIScope)null);
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            DropDownBoxActionUI.this.updateComponent();
        }
    }

    private class SubActionListener
    implements PActionListener,
    ActionListener {
        private SubActionListener() {
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            DropDownBoxActionUI.this.updateComponent();
        }

        @Override
        public void selectionStateChanged(boolean bl) {
            if (bl && PAction.ActionType.SubmenuExclusive.equals((Object)DropDownBoxActionUI.this.getAction().getActionType())) {
                DropDownBoxActionUI.this.selectedAction = DropDownBoxActionUI.this.getSelectedSubAction(DropDownBoxActionUI.this.getAction());
                DropDownBoxActionUI.this.updateComponent();
            }
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            DropDownBoxActionUI.this.updateComponent();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DropDownBoxActionUI.this.selectedAction = DropDownBoxActionUI.this.findSubActionForComponent((Component)actionEvent.getSource());
            DropDownBoxActionUI.this.updateComponent();
        }
    }
}

