/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import javax.swing.JComponent;

public abstract class AbstractActionUI<C extends JComponent>
implements IActionUI {
    private PAction action;
    private C component;
    private ActionUIScope scope;
    private boolean binded;

    public AbstractActionUI(PAction pAction, C c, ActionUIScope actionUIScope) {
        assert (pAction != null) : "create action-ui error: action must not be null!";
        assert (c != null) : "create action-ui error: component must not be null!";
        this.action = pAction;
        this.component = c;
        this.scope = actionUIScope;
        this.binded = false;
    }

    @Override
    public final PAction getAction() {
        return this.action;
    }

    public final C getComponent() {
        return this.component;
    }

    @Override
    public final ActionUIScope getScope() {
        return this.scope;
    }

    @Override
    public boolean isBinded() {
        return this.binded;
    }

    @Override
    public void bind() {
        if (!this.isBinded()) {
            if (ActionUIUtilities.hasSubActions(this.getAction())) {
                this.bindSubActions();
            }
            this.updateComponent(this.action, this.component, this.scope);
            this.registerListeners(this.action, this.component);
            this.binded = true;
        }
    }

    @Override
    public void release() {
        if (this.isBinded()) {
            this.unregisterListeners(this.action, this.component);
            if (ActionUIUtilities.hasSubActions(this.getAction())) {
                this.releaseSubActions();
            }
            this.binded = false;
        }
    }

    protected void updateComponent(PAction pAction, C c, ActionUIScope actionUIScope) {
        ((JComponent)c).setToolTipText(AbstractPAction.getTooltipTextWithShortcut(pAction));
        ((JComponent)c).setEnabled(pAction.isEnabled());
        ((JComponent)c).setVisible(pAction.isAvailable());
    }

    protected final void updateComponent() {
        this.updateComponent(this.getAction(), this.getComponent(), this.getScope());
    }

    protected void registerListeners(PAction pAction, C c) {
    }

    protected void unregisterListeners(PAction pAction, C c) {
    }

    protected void bindSubActions() {
    }

    protected void releaseSubActions() {
    }
}

