/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.ComputerName;
import com.tiani.jvision.main.StatisticsUtil;
import java.util.Map;

public abstract class PActionUsageTracker {
    private static final ALogger log = ALogger.getLogger(PActionUsageTracker.class);

    public static void exportUsageStatistics() {
        try {
            XmlStatisticsWriter xmlStatisticsWriter = new XmlStatisticsWriter();
            xmlStatisticsWriter.init(AbstractPAction.getUsageStatistics());
            StatisticsUtil.sendStatisticsToServer(xmlStatisticsWriter.toString(), "Agility/usagestatistics");
        }
        catch (Exception exception) {
            log.warn("Exporting action usage statistics failed.", (Throwable)exception);
        }
    }

    private static class XmlStatisticsWriter {
        private static final String ROOT_TAG = "statistics";
        private static final String USER_TAG = "user";
        private static final String ACTION_TAG = "action";
        private final StringBuilder xml = new StringBuilder();

        private XmlStatisticsWriter() {
        }

        protected void init(Iterable<Map.Entry<String, AbstractPAction.Counter>> iterable) {
            this.append(ROOT_TAG, false);
            this.append(USER_TAG, false);
            this.append("host", ComputerName.getComputerId());
            this.append("role", URLProviderFactory.getProvider().getLoginInformation().getRole());
            this.append("name", URLProviderFactory.getProvider().getLoginInformation().getUserFullName());
            this.append(USER_TAG, true);
            for (Map.Entry<String, AbstractPAction.Counter> entry : iterable) {
                this.append(entry.getKey(), entry.getValue());
            }
            this.append(ROOT_TAG, true);
        }

        private void append(String string, boolean bl) {
            this.xml.append('<');
            if (bl) {
                this.xml.append('/');
            }
            this.xml.append(string);
            this.xml.append('>');
        }

        private void append(String string, Object object) {
            this.append(string, false);
            this.xml.append(object);
            this.append(string, true);
        }

        private void append(String string, AbstractPAction.Counter counter) {
            this.append(ACTION_TAG, false);
            this.append("id", string);
            this.append("count", counter.getValue());
            this.append(ACTION_TAG, true);
        }

        public String toString() {
            return this.xml.toString();
        }
    }
}

