/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.PActionIconModifier;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconListener;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.concurrent.CountDownLatch;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PActionIconImpl
implements PActionIcon,
PIconListener {
    private static final float DARKEN_FACTOR_ON_POPUP = 0.8f;
    private static final float DARKEN_FACTOR_ON_DISABLE = 0.4f;
    private static final ALogger log = ALogger.getLogger(PActionIconImpl.class);
    private PIcon icon;
    private final PActionIconModifier modifier;
    private final boolean isUnchanging;
    private final CountDownLatch loadingLatch;
    private Icon defaultIconSmall;
    private Icon defaultIconLarge;
    private Icon popupIconSmall;
    private Icon popupIconLarge;
    private Icon disabledIconSmall;
    private Icon disabledIconLarge;

    PActionIconImpl(PIcon pIcon, PActionIconModifier pActionIconModifier, boolean bl) {
        this.icon = pIcon;
        this.modifier = pActionIconModifier;
        this.isUnchanging = bl;
        this.loadingLatch = new CountDownLatch(1);
        pIcon.setLoadListener((PIconListener)this);
    }

    public void iconLoaded(PIcon pIcon) {
        PIcon pIcon2 = this.icon;
        if (!CompareUtils.equals((Object)pIcon, (Object)pIcon2) || this.loadingLatch.getCount() <= 0L) {
            return;
        }
        this.icon = null;
        ImageIcon imageIcon = pIcon2.scaleToHeight(PActionIconFactory.SMALL_ICON_HEIGHT);
        ImageIcon imageIcon2 = pIcon2.scaleToHeight(PActionIconFactory.LARGE_ICON_HEIGHT);
        if (this.modifier != null) {
            imageIcon = this.modifier.modifyIcon(imageIcon);
            imageIcon2 = this.modifier.modifyIcon(imageIcon2);
        }
        this.defaultIconSmall = IconUtil.darkenIcon((ImageIcon)imageIcon, (float)0.8f);
        this.defaultIconLarge = IconUtil.darkenIcon((ImageIcon)imageIcon2, (float)0.8f);
        if (this.isUnchanging) {
            this.popupIconSmall = this.defaultIconSmall;
            this.popupIconLarge = this.defaultIconLarge;
            this.disabledIconSmall = this.defaultIconSmall;
            this.disabledIconLarge = this.defaultIconLarge;
        } else {
            this.popupIconSmall = imageIcon;
            this.popupIconLarge = imageIcon2;
            this.disabledIconSmall = IconUtil.darkenIcon((ImageIcon)imageIcon, (float)0.4f);
            this.disabledIconLarge = IconUtil.darkenIcon((ImageIcon)imageIcon2, (float)0.4f);
        }
        this.loadingLatch.countDown();
    }

    @Override
    public Icon getIcon(boolean bl) {
        this.ensureIconLoaded();
        if (bl) {
            return this.defaultIconSmall;
        }
        return this.defaultIconLarge;
    }

    @Override
    public Icon getPopupIcon(boolean bl) {
        this.ensureIconLoaded();
        if (bl) {
            return this.popupIconSmall;
        }
        return this.popupIconLarge;
    }

    @Override
    public Icon getDisabledIcon(boolean bl) {
        this.ensureIconLoaded();
        if (bl) {
            return this.disabledIconSmall;
        }
        return this.disabledIconLarge;
    }

    private void ensureIconLoaded() {
        if (this.icon != null) {
            this.icon.ensureIconLoaded();
        }
        try {
            this.loadingLatch.await();
        }
        catch (InterruptedException interruptedException) {
            log.debug("Waiting for icon loading interrupted.", (Throwable)interruptedException);
        }
    }
}

