/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPDataAction
implements PDataAction {
    protected PAction[] dynamicContentActions;

    public AbstractPDataAction(boolean bl) {
    }

    public AbstractPDataAction() {
        this.init();
    }

    public void init() {
        PDataScope[] pDataScopeArray = this.getAvailableScopes();
        this.dynamicContentActions = new PAction[PDataScope.values().length];
        PDataScope[] pDataScopeArray2 = pDataScopeArray;
        int n = pDataScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PDataScope pDataScope = pDataScopeArray2[n2];
            this.dynamicContentActions[pDataScope.ordinal()] = this.createDataAction(pDataScope, null);
            ++n2;
        }
    }

    protected abstract PAction createDataAction(PDataScope var1, PDataProvider var2);

    @Override
    public final PAction getAction(PDataScope pDataScope) {
        PAction pAction = this.dynamicContentActions[pDataScope.ordinal()];
        if (pAction == null) {
            throw new ActionNotFoundException(this.getID(), pDataScope);
        }
        return pAction;
    }

    @Override
    public final PAction createAction(PDataProvider pDataProvider) {
        return this.createDataAction(null, pDataProvider);
    }

    @Override
    public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
        return PDataProvider.ProviderType.Display == providerType;
    }

    public static VisData getCurrentImage() {
        return VisData.getLastModified();
    }

    public static VisDisplay2 getCurrentDisplay() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        return visData.getParent().getVisDisplay();
    }

    public static VisScreen2 getCurrentScreen() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        return visData.getParent().getVisDisplay().getScreen();
    }

    public static List<VisData> getVisDatas(PDataScope pDataScope) {
        VisData visData = null;
        switch (pDataScope) {
            case SelectedImages: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return visData.getParent().getSelectedVis();
            }
            case CurrentDisplay: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return new ArrayList<VisData>(visData.getParent().getVis());
            }
            case AllDisplayed: {
                return JVision2.getMainFrame().getAllVisDatas();
            }
            case CurrentStudy: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                String string = visData.getImageInformation().getStudyInstanceUID();
                List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
                Iterator<VisData> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getImageInformation().getStudyInstanceUID().equals(string)) continue;
                    iterator.remove();
                }
                return list;
            }
            case CurrentImage: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(visData);
            }
        }
        return Collections.emptyList();
    }

    public static List<VisDisplay2> getVisDisplays(PDataScope pDataScope) {
        switch (pDataScope) {
            case AllDisplayed: {
                return JVision2.getMainFrame().getDisplays();
            }
            case SelectedImages: 
            case CurrentDisplay: {
                VisData visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(visData.getParent().getVisDisplay());
            }
            case CurrentStudy: {
                VisData visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                String string = visData.getImageInformation().getStudyInstanceUID();
                List<VisDisplay2> list = JVision2.getMainFrame().getAllDisplays();
                Iterator<VisDisplay2> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getData().getFirstVis().getImageInformation().getStudyInstanceUID().equals(string)) continue;
                    iterator.remove();
                }
                return list;
            }
        }
        return Collections.emptyList();
    }

    public static List<VisDisplay2> getVisDisplaysBasedOnMousePosition() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            Rectangle rectangle = visDisplay2.getBounds();
            rectangle.setLocation(visDisplay2.getLocationOnScreen());
            if (!rectangle.contains(point)) continue;
            return Collections.singletonList(visDisplay2);
        }
        return null;
    }

    protected String getID(PDataScope pDataScope) {
        if (pDataScope == null) {
            return this.getID();
        }
        StringBuilder stringBuilder = new StringBuilder(this.getID());
        stringBuilder.append('@').append(pDataScope.name());
        return stringBuilder.toString();
    }

    protected abstract class AbstractInnerPAction
    extends AbstractPAction {
        protected PDataScope scope;
        protected PDataProvider provider;

        public AbstractInnerPAction(String string, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(string);
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        public AbstractInnerPAction(IconDefinition iconDefinition, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(iconDefinition);
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        public AbstractInnerPAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        @Override
        public String getID() {
            return AbstractPDataAction.this.getID(this.scope);
        }
    }

    protected abstract class CompoundInnerPAction
    extends CompoundAbstractPAction {
        protected PDataScope scope;
        protected PDataProvider provider;

        public CompoundInnerPAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        @Override
        public String getID() {
            return AbstractPDataAction.this.getID(this.scope);
        }
    }

    protected abstract class SelectableInnerPAction
    extends AbstractInnerPAction {
        public SelectableInnerPAction(IconDefinition iconDefinition, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(iconDefinition, pDataScope, pDataProvider);
        }

        public SelectableInnerPAction(String string, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(string, pDataScope, pDataProvider);
        }

        public SelectableInnerPAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public final boolean isSelectable() {
            return this.provider != null;
        }

        protected abstract boolean isSelectedImpl();

        @Override
        public final boolean isSelected() {
            if (this.provider != null) {
                return this.isSelectedImpl();
            }
            return false;
        }
    }
}

