/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.EclipseScheduledApplication;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.service.event.Event;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AppPersistence
implements ServiceTrackerCustomizer {
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String FILTER_PREFIX = "(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=";
    private static final String FILE_APPLOCKS = ".locks";
    private static final String FILE_APPSCHEDULED = ".scheduled";
    private static final String EVENT_HANDLER = "org.osgi.service.event.EventHandler";
    private static final int DATA_VERSION = 2;
    private static final byte NULL = 0;
    private static final int OBJECT = 1;
    private static BundleContext context;
    private static ServiceTracker configTracker;
    private static Location configLocation;
    private static Collection locks;
    private static Map scheduledApps;
    static ArrayList timerApps;
    private static StorageManager storageManager;
    private static boolean scheduling;
    static boolean shutdown;
    private static int nextScheduledID;
    private static Thread timerThread;
    static /* synthetic */ Class class$0;

    static {
        locks = new ArrayList();
        scheduledApps = new HashMap();
        timerApps = new ArrayList();
        scheduling = false;
        shutdown = false;
        nextScheduledID = 1;
    }

    static void start(BundleContext bundleContext) {
        context = bundleContext;
        shutdown = false;
        AppPersistence.initConfiguration();
    }

    static void stop() {
        shutdown = true;
        AppPersistence.stopTimer();
        if (storageManager != null) {
            storageManager.close();
            storageManager = null;
        }
        AppPersistence.closeConfiguration();
        context = null;
    }

    private static void initConfiguration() {
        AppPersistence.closeConfiguration();
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.configuration.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        configTracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)new AppPersistence());
        configTracker.open();
    }

    private static void closeConfiguration() {
        if (configTracker != null) {
            configTracker.close();
        }
        configTracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(ApplicationDescriptor applicationDescriptor) {
        Collection collection = locks;
        synchronized (collection) {
            return locks.contains(applicationDescriptor.getApplicationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLock(ApplicationDescriptor applicationDescriptor, boolean bl) {
        Collection collection = locks;
        synchronized (collection) {
            if (bl) {
                if (!locks.contains(applicationDescriptor.getApplicationId())) {
                    locks.add(applicationDescriptor.getApplicationId());
                    AppPersistence.saveData(FILE_APPLOCKS);
                }
            } else if (locks.remove(applicationDescriptor.getApplicationId())) {
                AppPersistence.saveData(FILE_APPLOCKS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeScheduledApp(EclipseScheduledApplication eclipseScheduledApplication) {
        boolean bl;
        Object object = scheduledApps;
        synchronized (object) {
            boolean bl2 = bl = scheduledApps.remove(eclipseScheduledApplication.getScheduleId()) != null;
            if (bl) {
                AppPersistence.saveData(FILE_APPSCHEDULED);
            }
        }
        if (bl) {
            object = timerApps;
            synchronized (object) {
                timerApps.remove(eclipseScheduledApplication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledApplication addScheduledApp(ApplicationDescriptor applicationDescriptor, String string, Map map, String string2, String string3, boolean bl) throws InvalidSyntaxException, ApplicationException {
        EclipseScheduledApplication eclipseScheduledApplication;
        if (!scheduling && !AppPersistence.checkSchedulingSupport()) {
            throw new ApplicationException(4, "Cannot support scheduling without org.osgi.service.event package");
        }
        context.createFilter(string3);
        Map map2 = scheduledApps;
        synchronized (map2) {
            eclipseScheduledApplication = new EclipseScheduledApplication(context, AppPersistence.getNextScheduledID(string), applicationDescriptor.getApplicationId(), map, string2, string3, bl);
            AppPersistence.addScheduledApp(eclipseScheduledApplication);
            AppPersistence.saveData(FILE_APPSCHEDULED);
        }
        return eclipseScheduledApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addScheduledApp(EclipseScheduledApplication eclipseScheduledApplication) {
        Cloneable cloneable;
        if ("org/osgi/application/timer".equals(eclipseScheduledApplication.getTopic())) {
            cloneable = timerApps;
            synchronized (cloneable) {
                timerApps.add(eclipseScheduledApplication);
                if (timerThread == null) {
                    AppPersistence.startTimer();
                }
            }
        }
        scheduledApps.put(eclipseScheduledApplication.getScheduleId(), eclipseScheduledApplication);
        cloneable = new Hashtable();
        if (eclipseScheduledApplication.getTopic() != null) {
            ((Hashtable)cloneable).put("event.topics", new String[]{eclipseScheduledApplication.getTopic()});
        }
        if (eclipseScheduledApplication.getEventFilter() != null) {
            ((Hashtable)cloneable).put("event.filter", eclipseScheduledApplication.getEventFilter());
        }
        ((Hashtable)cloneable).put("schedule.id", eclipseScheduledApplication.getScheduleId());
        ((Hashtable)cloneable).put("service.pid", eclipseScheduledApplication.getAppPid());
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.application.ScheduledApplication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        stringArray[1] = EVENT_HANDLER;
        ServiceRegistration serviceRegistration = context.registerService(stringArray, (Object)eclipseScheduledApplication, (Dictionary)((Object)cloneable));
        eclipseScheduledApplication.setServiceRegistration(serviceRegistration);
    }

    private static String getNextScheduledID(String string) throws ApplicationException {
        if (string != null) {
            if (scheduledApps.get(string) != null) {
                throw new ApplicationException(5, "Duplicate scheduled ID: " + string);
            }
            return string;
        }
        if (nextScheduledID == Integer.MAX_VALUE) {
            nextScheduledID = 0;
        }
        String string2 = new Integer(nextScheduledID++).toString();
        while (scheduledApps.get(string2) != null && nextScheduledID < Integer.MAX_VALUE) {
            string2 = new Integer(nextScheduledID++).toString();
        }
        if (nextScheduledID == Integer.MAX_VALUE) {
            throw new ApplicationException(5, "Maximum number of scheduled applications reached");
        }
        return string2;
    }

    private static boolean checkSchedulingSupport() {
        try {
            Class.forName(EVENT_HANDLER);
            scheduling = true;
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            scheduling = false;
            return false;
        }
    }

    private static synchronized boolean loadData(String string) {
        File file;
        block10: {
            Location location;
            Location location2;
            block9: {
                try {
                    location2 = configLocation;
                    if (location2 != null) break block9;
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            File file2 = new File(String.valueOf(location2.getURL().getPath()) + '/' + "org.eclipse.equinox.app");
            if (storageManager == null) {
                boolean bl = location2.isReadOnly();
                storageManager = new StorageManager(file2, bl ? "none" : null, bl);
                storageManager.open(!bl);
            }
            if (!((file = storageManager.lookup(string, false)) != null && file.isFile() || (location = location2.getParentLocation()) == null)) {
                file2 = new File(String.valueOf(location.getURL().getPath()) + '/' + "org.eclipse.equinox.app");
                StorageManager storageManager = new StorageManager(file2, "none", true);
                storageManager.open(false);
                file = storageManager.lookup(string, false);
                storageManager.close();
            }
            if (file != null && file.isFile()) break block10;
            return true;
        }
        if (FILE_APPLOCKS.equals(string)) {
            AppPersistence.loadLocks(file);
        } else if (FILE_APPSCHEDULED.equals(string)) {
            AppPersistence.loadSchedules(file);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLocks(File file) throws IOException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            int n = objectInputStream.readInt();
            if (n != 2) {
                return;
            }
            int n2 = objectInputStream.readInt();
            Collection collection = locks;
            synchronized (collection) {
                int n3 = 0;
                while (n3 < n2) {
                    locks.add(objectInputStream.readUTF());
                    ++n3;
                }
            }
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    private static void loadSchedules(File file) throws IOException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            int n = objectInputStream.readInt();
            if (n != 2) {
                return;
            }
            try {
                int n2 = objectInputStream.readInt();
                int n3 = 0;
                while (n3 < n2) {
                    String string = AppPersistence.readString(objectInputStream, false);
                    String string2 = AppPersistence.readString(objectInputStream, false);
                    String string3 = AppPersistence.readString(objectInputStream, false);
                    String string4 = AppPersistence.readString(objectInputStream, false);
                    boolean bl = objectInputStream.readBoolean();
                    Map map = (Map)objectInputStream.readObject();
                    EclipseScheduledApplication eclipseScheduledApplication = new EclipseScheduledApplication(context, string, string2, map, string3, string4, bl);
                    AppPersistence.addScheduledApp(eclipseScheduledApplication);
                    ++n3;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new IOException(invalidSyntaxException.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new IOException(noClassDefFoundError.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    private static synchronized void saveData(String string) {
        if (storageManager == null || storageManager.isReadOnly()) {
            return;
        }
        try {
            File file = storageManager.createTempFile(string);
            if (FILE_APPLOCKS.equals(string)) {
                AppPersistence.saveLocks(file);
            } else if (FILE_APPSCHEDULED.equals(string)) {
                AppPersistence.saveSchedules(file);
            }
            storageManager.lookup(string, true);
            storageManager.update(new String[]{string}, new String[]{file.getName()});
        }
        catch (IOException iOException) {
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 4, 0, NLS.bind((String)Messages.persistence_error_saving, (Object)string), 0, (Throwable)iOException, null));
        }
    }

    private static void saveLocks(File file) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeInt(2);
            objectOutputStream.writeInt(locks.size());
            Iterator iterator = locks.iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeUTF((String)iterator.next());
            }
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    private static void saveSchedules(File file) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeInt(2);
            objectOutputStream.writeInt(scheduledApps.size());
            Iterator iterator = scheduledApps.values().iterator();
            while (iterator.hasNext()) {
                EclipseScheduledApplication eclipseScheduledApplication = (EclipseScheduledApplication)iterator.next();
                AppPersistence.writeStringOrNull(objectOutputStream, eclipseScheduledApplication.getScheduleId());
                AppPersistence.writeStringOrNull(objectOutputStream, eclipseScheduledApplication.getAppPid());
                AppPersistence.writeStringOrNull(objectOutputStream, eclipseScheduledApplication.getTopic());
                AppPersistence.writeStringOrNull(objectOutputStream, eclipseScheduledApplication.getEventFilter());
                objectOutputStream.writeBoolean(eclipseScheduledApplication.isRecurring());
                objectOutputStream.writeObject(eclipseScheduledApplication.getArguments());
            }
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    private static void startTimer() {
        timerThread = new Thread((Runnable)new AppTimer(), "app schedule timer");
        timerThread.start();
    }

    private static void stopTimer() {
        if (timerThread != null) {
            timerThread.interrupt();
        }
        timerThread = null;
    }

    private static String readString(ObjectInputStream objectInputStream, boolean bl) throws IOException {
        byte by = objectInputStream.readByte();
        if (by == 0) {
            return null;
        }
        return bl ? objectInputStream.readUTF().intern() : objectInputStream.readUTF();
    }

    private static void writeStringOrNull(ObjectOutputStream objectOutputStream, String string) throws IOException {
        if (string == null) {
            objectOutputStream.writeByte(0);
        } else {
            objectOutputStream.writeByte(1);
            objectOutputStream.writeUTF(string);
        }
    }

    public Object addingService(ServiceReference serviceReference) {
        if (configLocation != null) {
            return null;
        }
        configLocation = (Location)context.getService(serviceReference);
        AppPersistence.loadData(FILE_APPLOCKS);
        AppPersistence.loadData(FILE_APPSCHEDULED);
        return configLocation;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        if (object == configLocation) {
            configLocation = null;
        }
    }

    static class AppTimer
    implements Runnable {
        AppTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = -1;
            while (!shutdown) {
                try {
                    Thread.sleep(30000L);
                    Calendar calendar = Calendar.getInstance();
                    int n2 = calendar.get(12);
                    if (n2 == n) continue;
                    n = n2;
                    Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                    hashtable.put("year", new Integer(calendar.get(1)));
                    hashtable.put("month", new Integer(calendar.get(2)));
                    hashtable.put("day_of_month", new Integer(calendar.get(5)));
                    hashtable.put("day_of_week", new Integer(calendar.get(7)));
                    hashtable.put("hour_of_day", new Integer(calendar.get(11)));
                    hashtable.put("minute", new Integer(n2));
                    Event event = new Event("org/osgi/application/timer", hashtable);
                    EclipseScheduledApplication[] eclipseScheduledApplicationArray = null;
                    ArrayList arrayList = timerApps;
                    synchronized (arrayList) {
                        if (timerApps.size() == 0) {
                            continue;
                        }
                        eclipseScheduledApplicationArray = timerApps.toArray(new EclipseScheduledApplication[timerApps.size()]);
                    }
                    int n3 = 0;
                    while (n3 < eclipseScheduledApplicationArray.length) {
                        String string;
                        try {
                            String string2 = eclipseScheduledApplicationArray[n3].getEventFilter();
                            Object object = string = string2 == null ? null : FrameworkUtil.createFilter((String)string2);
                            if (string == null || string.match(hashtable)) {
                                eclipseScheduledApplicationArray[n3].handleEvent(event);
                            }
                        }
                        catch (Throwable throwable) {
                            string = NLS.bind((String)Messages.scheduled_app_launch_error, (Object)eclipseScheduledApplicationArray[n3].getAppPid());
                            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, throwable, null));
                        }
                        ++n3;
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

