/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.util.tracker.ServiceTracker;

public class AppCommands
implements CommandProvider {
    private static final String LAUNCHABLE_APP_FILTER = "(&(application.locked=false)(application.launchable=true)(application.visible=true))";
    private static final String ACTIVE_APP_FILTER = "(!(application.state=STOPPING))";
    private static final String LOCKED_APP_FILTER = "(application.locked=true)";
    private static final String NEW_LINE = "\r\n";
    private static final String TAB = "\t";
    private Map commandsHelp = null;
    private static AppCommands instance;
    private BundleContext context;
    private ServiceTracker applicationDescriptors;
    private ServiceTracker applicationHandles;
    private ServiceTracker scheduledApplications;
    private Filter launchableApp;
    private Filter activeApp;
    private Filter lockedApp;
    private ServiceRegistration providerRegistration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static synchronized void create(BundleContext bundleContext) {
        if (instance != null) {
            return;
        }
        instance = new AppCommands();
        instance.start(bundleContext);
    }

    static synchronized void destroy(BundleContext bundleContext) {
        if (instance == null) {
            return;
        }
        instance.stop(bundleContext);
        instance = null;
    }

    protected AppCommands() {
    }

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.application.ApplicationDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.applicationDescriptors = new ServiceTracker(bundleContext, clazz.getName(), null);
            this.applicationDescriptors.open();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.osgi.service.application.ApplicationHandle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.applicationHandles = new ServiceTracker(bundleContext, clazz2.getName(), null);
            this.applicationHandles.open();
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.osgi.service.application.ScheduledApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.scheduledApplications = new ServiceTracker(bundleContext, clazz3.getName(), null);
            this.scheduledApplications.open();
            this.launchableApp = bundleContext.createFilter(LAUNCHABLE_APP_FILTER);
            this.activeApp = bundleContext.createFilter(ACTIVE_APP_FILTER);
            this.lockedApp = bundleContext.createFilter(LOCKED_APP_FILTER);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.providerRegistration = bundleContext.registerService(clazz4.getName(), (Object)this, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public void stop(BundleContext bundleContext) {
        this.providerRegistration.unregister();
        if (this.applicationDescriptors != null) {
            this.applicationDescriptors.close();
        }
        if (this.applicationHandles != null) {
            this.applicationHandles.close();
        }
        if (this.scheduledApplications != null) {
            this.scheduledApplications.close();
        }
    }

    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.commandsHelp == null) {
            this.initializeCommandsHelp();
        }
        if (string != null) {
            if (this.commandsHelp.containsKey(string)) {
                this.addCommand(string, (String[])this.commandsHelp.get(string), stringBuffer);
            }
            return stringBuffer.toString();
        }
        this.addHeader(Messages.console_help_app_commands_header, stringBuffer);
        Iterator iterator = this.commandsHelp.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            this.addCommand(string2, stringArray, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void initializeCommandsHelp() {
        this.commandsHelp = new LinkedHashMap();
        this.commandsHelp.put("activeApps", new String[]{Messages.console_help_activeapps_description});
        this.commandsHelp.put("apps", new String[]{Messages.console_help_apps_description});
        this.commandsHelp.put("lockApp", new String[]{Messages.console_help_arguments, Messages.console_help_lockapp_description});
        this.commandsHelp.put("schedApp", new String[]{Messages.console_help_schedapp_arguments, Messages.console_help_schedapp_description});
        this.commandsHelp.put("startApp", new String[]{Messages.console_help_arguments, Messages.console_help_startapp_description});
        this.commandsHelp.put("stopApp", new String[]{Messages.console_help_arguments, Messages.console_help_stopapp_description});
        this.commandsHelp.put("unlockApp", new String[]{Messages.console_help_arguments, Messages.console_help_unlockapp_description});
        this.commandsHelp.put("unschedApp", new String[]{Messages.console_help_arguments, Messages.console_help_unschedapp_description});
    }

    private void addHeader(String string, StringBuffer stringBuffer) {
        stringBuffer.append("---");
        stringBuffer.append(string);
        stringBuffer.append("---");
        stringBuffer.append(NEW_LINE);
    }

    private void addCommand(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(TAB);
        stringBuffer.append(string);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(NEW_LINE);
    }

    private void addCommand(String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(TAB);
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" - ");
        stringBuffer.append(string3);
        stringBuffer.append(NEW_LINE);
    }

    private void addCommand(String string, String[] stringArray, StringBuffer stringBuffer) {
        if (stringArray.length == 1) {
            this.addCommand(string, stringArray[0], stringBuffer);
        } else if (stringArray.length == 2) {
            this.addCommand(string, stringArray[0], stringArray[1], stringBuffer);
        }
    }

    private Dictionary getServiceProps(ServiceReference serviceReference) {
        String[] stringArray = serviceReference.getPropertyKeys();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], serviceReference.getProperty(stringArray[n]));
            ++n;
        }
        return hashtable;
    }

    public void _apps(CommandInterpreter commandInterpreter) {
        ServiceReference[] serviceReferenceArray = this.applicationDescriptors.getServiceReferences();
        if (serviceReferenceArray == null) {
            commandInterpreter.println((Object)"No applications found.");
            return;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            String string = (String)serviceReferenceArray[n].getProperty("service.pid");
            commandInterpreter.print((Object)string);
            if (this.getApplication(this.applicationHandles.getServiceReferences(), string, "application.descriptor", true) != null) {
                commandInterpreter.print((Object)" [running]");
            }
            if (this.getApplication(this.scheduledApplications.getServiceReferences(), string, "service.pid", true) != null) {
                commandInterpreter.print((Object)" [scheduled]");
            }
            if (!this.launchableApp.match(this.getServiceProps(serviceReferenceArray[n]))) {
                commandInterpreter.print((Object)" [not launchable]");
            } else {
                commandInterpreter.print((Object)" [launchable]");
            }
            if (this.lockedApp.match(this.getServiceProps(serviceReferenceArray[n]))) {
                commandInterpreter.print((Object)" [locked]");
            }
            commandInterpreter.println();
            ++n;
        }
    }

    public void _activeApps(CommandInterpreter commandInterpreter) {
        ServiceReference[] serviceReferenceArray = this.applicationHandles.getServiceReferences();
        if (serviceReferenceArray == null) {
            commandInterpreter.println((Object)"No active applications found");
            return;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            commandInterpreter.print(serviceReferenceArray[n].getProperty("service.pid"));
            commandInterpreter.print((Object)" [");
            commandInterpreter.print((Object)(this.activeApp.match(this.getServiceProps(serviceReferenceArray[n])) ? "running" : "stopping"));
            commandInterpreter.println((Object)"]");
            ++n;
        }
    }

    private ServiceReference getApplication(ServiceReference[] serviceReferenceArray, String string, String string2, boolean bl) {
        if (serviceReferenceArray == null || string == null) {
            return null;
        }
        ServiceReference serviceReference = null;
        boolean bl2 = false;
        int n = 0;
        while (n < serviceReferenceArray.length) {
            String string3 = (String)serviceReferenceArray[n].getProperty(string2);
            if (string.equals(string3)) {
                return serviceReferenceArray[n];
            }
            if (!bl && string3.indexOf(string) >= 0) {
                if (serviceReference != null) {
                    bl2 = true;
                }
                serviceReference = serviceReferenceArray[n];
            }
            ++n;
        }
        return bl2 ? null : serviceReference;
    }

    public void _startApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = null;
            while ((string2 = commandInterpreter.nextArgument()) != null) {
                arrayList.add(string2);
            }
            String[] stringArray = arrayList.size() == 0 ? null : arrayList.toArray(new String[arrayList.size()]);
            try {
                HashMap<String, String[]> hashMap = new HashMap<String, String[]>(1);
                if (stringArray != null) {
                    hashMap.put("application.args", stringArray);
                }
                ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
                ApplicationHandle applicationHandle = applicationDescriptor.launch(hashMap);
                commandInterpreter.println((Object)("Launched application instance: " + applicationHandle.getInstanceId()));
            }
            finally {
                this.context.ungetService(serviceReference);
            }
            return;
        }
        commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
    }

    public void _stopApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationHandles.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            serviceReference = this.getApplication(this.applicationHandles.getServiceReferences(), string, "application.descriptor", false);
        }
        if (serviceReference != null) {
            if (this.activeApp.match(this.getServiceProps(serviceReference))) {
                try {
                    ApplicationHandle applicationHandle = (ApplicationHandle)this.context.getService(serviceReference);
                    applicationHandle.destroy();
                    commandInterpreter.println((Object)("Stopped application instance: " + applicationHandle.getInstanceId()));
                }
                finally {
                    this.context.ungetService(serviceReference);
                }
            } else {
                commandInterpreter.println((Object)("Application instance is already stopping: " + serviceReference.getProperty("service.pid")));
            }
            return;
        }
        commandInterpreter.println((Object)("\"" + string + "\" does not exist, is not running or is ambigous."));
    }

    public void _lockApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference != null) {
            try {
                ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
                applicationDescriptor.lock();
                commandInterpreter.println((Object)("Locked application: " + applicationDescriptor.getApplicationId()));
            }
            finally {
                this.context.ungetService(serviceReference);
            }
            return;
        }
        commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
    }

    public void _unlockApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference != null) {
            try {
                ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
                applicationDescriptor.unlock();
                commandInterpreter.println((Object)("Unlocked application: " + applicationDescriptor.getApplicationId()));
            }
            finally {
                this.context.ungetService(serviceReference);
            }
            return;
        }
        commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
    }

    public void _schedApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference != null) {
            try {
                ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
                String string2 = commandInterpreter.nextArgument();
                boolean bl = Boolean.valueOf(commandInterpreter.nextArgument());
                applicationDescriptor.schedule(null, null, "org/osgi/application/timer", string2, bl);
                commandInterpreter.println((Object)("Scheduled application: " + applicationDescriptor.getApplicationId()));
            }
            finally {
                this.context.ungetService(serviceReference);
            }
            return;
        }
        commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
    }

    public void _unschedApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.scheduledApplications.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
        } else {
            try {
                ScheduledApplication scheduledApplication = (ScheduledApplication)this.context.getService(serviceReference);
                scheduledApplication.remove();
                commandInterpreter.println((Object)("Unscheduled application: " + serviceReference.getProperty("service.pid")));
            }
            finally {
                this.context.ungetService(serviceReference);
            }
        }
    }

    public Object _help(CommandInterpreter commandInterpreter) {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            return Boolean.FALSE;
        }
        String string2 = this.getHelp(string);
        if (string2.length() > 0) {
            return string2;
        }
        return Boolean.FALSE;
    }
}

