/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.ClinicalCodeProviderAdapter;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.export.tce.keyword.KeywordClinicalCodeAdapter;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.impaxee.tce.keyword.IKeywordProviderUI;
import com.agfa.pacs.impaxee.tce.keyword.IKeywordUI;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCode;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeNode;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeProvider;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeSchemeUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class ClinicalCodeKeywordUIProvider
implements IKeywordProviderUI {
    @Override
    public String getUIType() {
        return "ClinicalCodes";
    }

    @Override
    public IKeywordUI getUI(IKeywordProvider iKeywordProvider) {
        return new UI(((ClinicalCodeProviderAdapter)iKeywordProvider).getClinicalCodeProvider());
    }

    private static final class UI
    implements IKeywordUI {
        private IClinicalCodeSchemeUI ui;

        public UI(IClinicalCodeProvider iClinicalCodeProvider) {
            this.ui = iClinicalCodeProvider.createCodeSchemeUI(iClinicalCodeProvider.createCodeScheme());
        }

        @Override
        public JComponent getRootComponent() {
            return (JComponent)this.ui.getAWTRootComponent();
        }

        @Override
        public IKeyword getSelectedKeyword() {
            List list = this.ui.getSelectedCodes();
            if (list != null && !list.isEmpty()) {
                return new KeywordClinicalCodeAdapter((IClinicalCode)list.get(0));
            }
            return null;
        }

        @Override
        public void setSelectedKeyword(IKeyword iKeyword) {
            IClinicalCode iClinicalCode = null;
            if (iKeyword != null) {
                IClinicalCodeNode iClinicalCodeNode = null;
                Code code = iKeyword.getDicomCode();
                iClinicalCodeNode = code != null ? this.ui.getCodeScheme().findNodeForCode(code) : this.ui.getCodeScheme().findNodeForCode(iKeyword.getText());
                if (iClinicalCodeNode != null) {
                    iClinicalCode = iClinicalCodeNode.getCode();
                }
            }
            if (iClinicalCode == null) {
                this.ui.setSelectedCodes(new ArrayList(0));
            } else {
                this.ui.setSelectedCodes(Collections.singletonList(iClinicalCode));
            }
        }
    }
}

