/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private RegistryStrategyOSGI strategy;
    private Object token;
    private HashMap dynamicAddStateStamps = new HashMap();
    private long[] currentStateStamp = new long[1];

    public EclipseBundleListener(ExtensionRegistry extensionRegistry, Object object, RegistryStrategyOSGI registryStrategyOSGI) {
        this.registry = extensionRegistry;
        this.token = object;
        this.strategy = registryStrategyOSGI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        switch (bundleEvent.getType()) {
            case 32: {
                long[] lArray = this.currentStateStamp;
                synchronized (this.currentStateStamp) {
                    long l = this.registry.computeState();
                    if (this.currentStateStamp[0] != l) {
                        this.currentStateStamp[0] = l;
                        this.dynamicAddStateStamps.clear();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    this.addBundle(bundle, true);
                    break;
                }
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundleArray) {
        int n = 0;
        while (n < bundleArray.length) {
            if (this.isBundleResolved(bundleArray[n])) {
                this.addBundle(bundleArray[n], false);
            } else {
                this.removeBundle(bundleArray[n]);
            }
            ++n;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        URL uRL;
        long l = 0L;
        if (this.strategy.checkContributionsTimestamp() && (uRL = EclipseBundleListener.getExtensionURL(bundle, false)) != null) {
            l = this.strategy.getExtendedTimestamp(bundle, uRL);
        }
        this.registry.remove(Long.toString(bundle.getBundleId()), l);
    }

    public static URL getExtensionURL(Bundle bundle, boolean bl) {
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        if (bundle.getSymbolicName() == null) {
            return null;
        }
        boolean bl2 = OSGIUtils.getDefault().isFragment(bundle);
        String string = bl2 ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        URL uRL = bundle.getEntry(string);
        if (uRL == null) {
            return null;
        }
        if (!EclipseBundleListener.isSingleton(bundle)) {
            if (bl && !EclipseBundleListener.isGeneratedManifest(bundle)) {
                String string2 = NLS.bind((String)RegistryMessages.parse_nonSingleton, (Object)bundle.getSymbolicName());
                RuntimeLog.log((IStatus)new Status(2, "org.eclipse.equinox.registry", 0, string2, null));
            }
            return null;
        }
        if (!bl2) {
            return uRL;
        }
        Bundle[] bundleArray = OSGIUtils.getDefault().getHosts(bundle);
        if (bundleArray == null) {
            return null;
        }
        if (EclipseBundleListener.isSingleton(bundleArray[0])) {
            return uRL;
        }
        if (bl) {
            String string3 = NLS.bind((String)RegistryMessages.parse_nonSingletonFragment, (Object)bundle.getSymbolicName(), (Object)bundleArray[0].getSymbolicName());
            RuntimeLog.log((IStatus)new Status(2, "org.eclipse.equinox.registry", 0, string3, null));
        }
        return null;
    }

    private static boolean isGeneratedManifest(Bundle bundle) {
        return bundle.getHeaders("").get("Generated-from") != null;
    }

    private void addBundle(Bundle bundle, boolean bl) {
        BufferedInputStream bufferedInputStream;
        IContributor iContributor;
        if (bl) {
            this.checkForNLSFragment(bundle);
        }
        if (this.registry.hasContributor(iContributor = ContributorFactoryOSGi.createContributor(bundle))) {
            return;
        }
        URL uRL = EclipseBundleListener.getExtensionURL(bundle, true);
        if (uRL == null) {
            return;
        }
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            bufferedInputStream = null;
        }
        if (bufferedInputStream == null) {
            return;
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceTranslator.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException missingResourceException) {}
        long l = 0L;
        if (this.strategy.checkContributionsTimestamp()) {
            l = this.strategy.getExtendedTimestamp(bundle, uRL);
        }
        this.registry.addContribution(bufferedInputStream, iContributor, true, uRL.getPath(), resourceBundle, this.token, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNLSFragment(Bundle bundle) {
        if (!OSGIUtils.getDefault().isFragment(bundle)) {
            long[] lArray = this.currentStateStamp;
            synchronized (this.currentStateStamp) {
                this.dynamicAddStateStamps.put(Long.toString(bundle.getBundleId()), new Long(this.currentStateStamp[0]));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        Bundle[] bundleArray = OSGIUtils.getDefault().getHosts(bundle);
        if (bundleArray == null) {
            return;
        }
        int n = 0;
        while (n < bundleArray.length) {
            this.checkForNLSFiles(bundleArray[n], bundle);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForNLSFiles(Bundle bundle, Bundle bundle2) {
        String string = Long.toString(bundle.getBundleId());
        Object[] objectArray = this.currentStateStamp;
        synchronized (this.currentStateStamp) {
            int n;
            Long l = (Long)this.dynamicAddStateStamps.get(string);
            if (l != null && this.currentStateStamp[0] == l) {
                // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
            objectArray = OSGIUtils.getDefault().getFragments(bundle);
            boolean bl = false;
            if (this.hasNLSFilesFor(bundle, bundle2)) {
                bl = true;
            } else {
                n = 0;
                while (n < objectArray.length && !bl) {
                    if (!bundle2.equals(objectArray[n]) && this.hasNLSFilesFor((Bundle)objectArray[n], bundle2)) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) return;
            this.removeBundle(bundle);
            this.addBundle(bundle, false);
            n = 0;
            while (n < objectArray.length) {
                if (!bundle2.equals(objectArray[n])) {
                    this.removeBundle((Bundle)objectArray[n]);
                    this.addBundle((Bundle)objectArray[n], false);
                }
                ++n;
            }
            long[] lArray = this.currentStateStamp;
            synchronized (this.currentStateStamp) {
                this.dynamicAddStateStamps.put(string, new Long(this.currentStateStamp[0]));
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return;
            }
        }
    }

    private boolean hasNLSFilesFor(Bundle bundle, Bundle bundle2) {
        String string;
        URL uRL;
        if (!this.registry.hasContributor(Long.toString(bundle.getBundleId()))) {
            return false;
        }
        Dictionary dictionary = bundle.getHeaders("");
        String string2 = (String)dictionary.get("Bundle-Localization");
        if (string2 == null) {
            string2 = "OSGI-INF/l10n/bundle";
        }
        if ((uRL = bundle.getEntry(String.valueOf(string2) + ".properties")) == null) {
            return false;
        }
        int n = string2.lastIndexOf(47);
        if (n == string2.length() - 1) {
            return false;
        }
        String string3 = n < 0 ? "" : string2.substring(0, n);
        Enumeration enumeration = bundle2.findEntries(string3, string = String.valueOf(n < 0 ? string2 : string2.substring(n + 1)) + "_*.properties", false);
        return enumeration != null;
    }

    private static boolean isSingleton(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders("");
        String string = (String)dictionary.get("Bundle-SymbolicName");
        try {
            ManifestElement[] manifestElementArray;
            if (string != null && (manifestElementArray = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)string)).length > 0) {
                String string2 = manifestElementArray[0].getDirective("singleton");
                if (string2 == null) {
                    string2 = manifestElementArray[0].getAttribute("singleton");
                }
                if (!"true".equalsIgnoreCase(string2)) {
                    String string3 = (String)dictionary.get("Bundle-ManifestVersion");
                    return string3 == null && OSGIUtils.getDefault().getBundle(manifestElementArray[0].getValue()) == bundle;
                }
            }
        }
        catch (BundleException bundleException) {}
        return true;
    }
}

