/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.internal.registry.RegistryDelta;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;

public final class RegistryChangeEvent
implements IRegistryChangeEvent {
    private String filter;
    private Map deltas;

    public RegistryChangeEvent(Map map, String string) {
        this.deltas = map;
        this.filter = string;
    }

    private RegistryDelta[] getHostDeltas() {
        if (this.filter != null) {
            RegistryDelta[] registryDeltaArray;
            RegistryDelta registryDelta = this.getHostDelta(this.filter);
            if (registryDelta == null) {
                registryDeltaArray = new RegistryDelta[]{};
            } else {
                RegistryDelta[] registryDeltaArray2 = new RegistryDelta[1];
                registryDeltaArray = registryDeltaArray2;
                registryDeltaArray2[0] = registryDelta;
            }
            return registryDeltaArray;
        }
        return this.deltas.values().toArray(new RegistryDelta[this.deltas.size()]);
    }

    private RegistryDelta getHostDelta(String string) {
        if (this.filter != null && !string.equals(this.filter)) {
            return null;
        }
        return (RegistryDelta)this.deltas.get(string);
    }

    public IExtensionDelta[] getExtensionDeltas() {
        RegistryDelta[] registryDeltaArray = this.getHostDeltas();
        if (registryDeltaArray.length == 0) {
            return new IExtensionDelta[0];
        }
        int n = 0;
        int n2 = 0;
        while (n2 < registryDeltaArray.length) {
            n += registryDeltaArray[n2].getExtensionDeltasCount();
            ++n2;
        }
        IExtensionDelta[] iExtensionDeltaArray = new IExtensionDelta[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < registryDeltaArray.length) {
            IExtensionDelta[] iExtensionDeltaArray2 = registryDeltaArray[n3].getExtensionDeltas();
            System.arraycopy(iExtensionDeltaArray2, 0, iExtensionDeltaArray, n4, iExtensionDeltaArray2.length);
            n4 += iExtensionDeltaArray2.length;
            ++n3;
        }
        return iExtensionDeltaArray;
    }

    public IExtensionDelta[] getExtensionDeltas(String string) {
        RegistryDelta registryDelta = this.getHostDelta(string);
        if (registryDelta == null) {
            return new IExtensionDelta[0];
        }
        return registryDelta.getExtensionDeltas();
    }

    public IExtensionDelta[] getExtensionDeltas(String string, String string2) {
        RegistryDelta registryDelta = this.getHostDelta(string);
        if (registryDelta == null) {
            return new IExtensionDelta[0];
        }
        return registryDelta.getExtensionDeltas(String.valueOf(string) + '.' + string2);
    }

    public IExtensionDelta getExtensionDelta(String string, String string2, String string3) {
        RegistryDelta registryDelta = this.getHostDelta(string);
        if (registryDelta == null) {
            return null;
        }
        return registryDelta.getExtensionDelta(String.valueOf(string) + '.' + string2, string3);
    }

    public String toString() {
        return "RegistryChangeEvent:  " + Arrays.asList(this.getHostDeltas());
    }
}

