/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

public class DirectMap {
    private final float growthFactor;
    private String[] keyArray;
    private String[][] valueArray;
    private int size;

    public DirectMap(int n, float f) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.growthFactor = f;
        this.keyArray = new String[n];
        this.valueArray = new String[n][];
        this.size = 0;
    }

    public synchronized void put(String string, String[] stringArray) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = this.findKey(string);
        if (n != -1) {
            throw new IllegalArgumentException();
        }
        if (this.size >= this.keyArray.length) {
            int n2 = this.recalcSize(this.keyArray.length);
            if (n2 <= this.size) {
                n2 = this.size + 1;
            }
            String[] stringArray2 = new String[n2];
            System.arraycopy(this.keyArray, 0, stringArray2, 0, this.keyArray.length);
            this.keyArray = stringArray2;
            String[][] stringArrayArray = new String[n2][];
            System.arraycopy(this.valueArray, 0, stringArrayArray, 0, this.valueArray.length);
            this.valueArray = stringArrayArray;
        }
        this.keyArray[this.size] = string;
        this.valueArray[this.size] = stringArray;
        ++this.size;
    }

    public synchronized boolean containsKey(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.findKey(string) != -1;
    }

    public synchronized String[] get(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = this.findKey(string);
        if (n == -1) {
            return null;
        }
        return this.valueArray[n];
    }

    String[] getKeys() {
        return this.keyArray;
    }

    String[][] getValues() {
        return this.valueArray;
    }

    int getSzie() {
        return this.size;
    }

    private int recalcSize(int n) {
        return (int)((float)n * (1.0f + this.growthFactor));
    }

    private int findKey(String string) {
        int n = 0;
        while (n < this.keyArray.length) {
            if (this.keyArray[n] != null && this.keyArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

