/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.local;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCache;
import com.agfa.pacs.config.IConfigurationCacheVisitor;
import com.agfa.pacs.config.IConfigurationSource;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.ComputerName;
import com.agfa.pacs.tools.UnicodeReader;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class PropertiesConfigurationSource
implements IConfigurationSource {
    public static final String DEFAULT_ROLE_NAME = "Default";
    private static ALogger log = ALogger.getLogger(PropertiesConfigurationSource.class);
    private boolean initialized = false;
    private Object mutex = new Object();
    private String base;
    private boolean asResource;
    private IConfigurationCache myCache;
    private String configBase = "";

    public PropertiesConfigurationSource() {
        if (Platform.isRunning()) {
            Location location = Platform.getConfigurationLocation();
            try {
                this.base = String.valueOf(new File(new URL(location.getURL(), "pacs/").getPath()).getAbsolutePath()) + File.separatorChar;
                this.asResource = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.configBase = System.getProperty("minicore.configarea");
            if (this.configBase == null) {
                this.configBase = "";
            }
            this.base = "/resources/pacs/";
            this.asResource = true;
        }
    }

    private void initCache(IConfigurationCache iConfigurationCache) {
        this.myCache = iConfigurationCache;
        if (this.asResource) {
            this.readLocalConfig(iConfigurationCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestKey(IConfigurationCache iConfigurationCache, String string, String string2, String string3) {
        if (!this.initialized) {
            Object object = this.mutex;
            synchronized (object) {
                block5: {
                    if (!this.initialized) break block5;
                    return false;
                }
                long l = System.currentTimeMillis();
                this.initCache(iConfigurationCache);
                this.initialized = true;
                log.info("Config Init:" + (System.currentTimeMillis() - l));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueModified(String string, ConfigLevel configLevel, String string2, Object object, ConfigType configType) {
        if (this.asResource) {
            PropertiesConfigurationSource propertiesConfigurationSource = this;
            synchronized (propertiesConfigurationSource) {
                this.storeConfig();
            }
        }
        return false;
    }

    public void storeConfig() {
        try {
            if (!this.asResource) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        HashMap<ConfigLevel, BufferedWriter> hashMap = new HashMap<ConfigLevel, BufferedWriter>();
        try {
            String string = String.valueOf(this.configBase) + this.base;
            String string2 = this.getLocalName();
            String string3 = this.getUserName();
            hashMap.put(ConfigLevel.Enterprise, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, "Enterprise.tmp"))), "UTF-8")));
            hashMap.put(ConfigLevel.Site, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, "Site.tmp"))), "UTF-8")));
            hashMap.put(ConfigLevel.Department, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, "Department.tmp"))), "UTF-8")));
            hashMap.put(ConfigLevel.Role, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, "Role.tmp"))), "UTF-8")));
            hashMap.put(ConfigLevel.Workstation, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, "Workstation.tmp"))), "UTF-8")));
            hashMap.put(ConfigLevel.Local, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, String.valueOf(string2) + ".tmp"))), "UTF-8")));
            hashMap.put(ConfigLevel.User, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ensurePath(new File(string, String.valueOf(string3) + ".tmp"))), "UTF-8")));
            this.myCache.scanCache((IConfigurationCacheVisitor)new CacheVisitor(hashMap), false, true);
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                ((BufferedWriter)iterator.next()).close();
            }
            new File(string, "Enterprise.properties").delete();
            new File(string, "Enterprise.tmp").renameTo(new File(string, "Enterprise.properties"));
            new File(string, "Site.properties").delete();
            new File(string, "Site.tmp").renameTo(new File(string, "Site.properties"));
            new File(string, "Department.properties").delete();
            new File(string, "Department.tmp").renameTo(new File(string, "Department.properties"));
            new File(string, "Role.properties").delete();
            new File(string, "Role.tmp").renameTo(new File(string, "Role.properties"));
            new File(string, "Workstation.properties").delete();
            new File(string, "Workstation.tmp").renameTo(new File(string, "Workstation.properties"));
            new File(string, String.valueOf(string2) + ".properties").delete();
            new File(string, String.valueOf(string2) + ".tmp").renameTo(new File(string, String.valueOf(string2) + ".properties"));
            new File(string, String.valueOf(string3) + ".properties").delete();
            new File(string, String.valueOf(string3) + ".tmp").renameTo(new File(string, String.valueOf(string3) + ".properties"));
        }
        catch (Exception exception) {
            log.error("Error", (Throwable)exception);
        }
    }

    private File ensurePath(File file) {
        file = file.getAbsoluteFile();
        file.getParentFile().mkdirs();
        return file;
    }

    public String concatOrder(ConfigLevel[] configLevelArray) {
        StringBuilder stringBuilder = new StringBuilder(150);
        int n = 0;
        while (n < configLevelArray.length) {
            stringBuilder.append(configLevelArray[n].name());
            if (n < configLevelArray.length - 1) {
                stringBuilder.append('.');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private String getUserName() {
        String string = System.getProperty("user.name");
        try {
            File file = new File(this.base, String.valueOf(string) + ".properties");
            if (file.exists()) {
                return string;
            }
        }
        catch (Exception exception) {}
        return "User";
    }

    private String getLocalName() {
        String string = ComputerName.getComputerId();
        File file = new File(this.base, String.valueOf(string) + ".properties");
        if (file.exists()) {
            return string;
        }
        return "Local";
    }

    private boolean readLocalConfig(IConfigurationCache iConfigurationCache) {
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        if (this.loadLocalConfig(String.valueOf(this.base) + "Manufacturer.properties", ConfigLevel.Manufacturer, iConfigurationCache)) break block9;
                                        return false;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        return false;
                                    }
                                }
                                if (this.loadLocalConfig(String.valueOf(this.base) + "Enterprise.properties", ConfigLevel.Enterprise, iConfigurationCache)) break block10;
                                return false;
                            }
                            if (this.loadLocalConfig(String.valueOf(this.base) + "Site.properties", ConfigLevel.Site, iConfigurationCache)) break block11;
                            return false;
                        }
                        if (this.loadLocalConfig(String.valueOf(this.base) + "Department.properties", ConfigLevel.Department, iConfigurationCache)) break block12;
                        return false;
                    }
                    if (this.loadLocalConfig(String.valueOf(this.base) + "Role.properties", ConfigLevel.Role, iConfigurationCache)) break block13;
                    return false;
                }
                if (this.loadLocalConfig(String.valueOf(this.base) + "Workstation.properties", ConfigLevel.Workstation, iConfigurationCache)) break block14;
                return false;
            }
            if (this.loadLocalConfig(String.valueOf(this.base) + this.getLocalName() + ".properties", ConfigLevel.Local, iConfigurationCache) || this.loadLocalConfig(String.valueOf(this.base) + "Local.properties", ConfigLevel.Local, iConfigurationCache)) break block15;
            return false;
        }
        return this.loadLocalConfig(String.valueOf(this.base) + this.getUserName() + ".properties", ConfigLevel.User, iConfigurationCache) || this.loadLocalConfig(String.valueOf(this.base) + "User.properties", ConfigLevel.User, iConfigurationCache);
    }

    @SuppressWarnings(value={"OS_OPEN_STREAM"}, justification="stream will close")
    private boolean loadLocalConfig(String string, ConfigLevel configLevel, IConfigurationCache iConfigurationCache) {
        InputStream inputStream;
        block17: {
            block18: {
                inputStream = null;
                File file = new File(String.valueOf(this.configBase) + string);
                inputStream = file.exists() ? new FileInputStream(file) : PropertiesConfigurationSource.class.getResourceAsStream(string);
                if (inputStream != null) break block17;
                if (inputStream == null) break block18;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
        try {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader((Reader)new UnicodeReader(inputStream, "UTF-8"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.trim().length() <= 0) continue;
                    this.initEntry(iConfigurationCache, configLevel, string2);
                }
            }
            catch (Exception exception) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void initEntry(IConfigurationCache iConfigurationCache, ConfigLevel configLevel, String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(58, n + 1);
        int n3 = string.indexOf(61);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 1, n3);
        ConfigType configType = ConfigType.valueOf((String)string3);
        String string4 = string.substring(n3 + 1);
        String[] stringArray = string2.split("\\.");
        iConfigurationCache.initValue(configLevel, stringArray, configType, string4, DEFAULT_ROLE_NAME);
    }

    public IConfigurationSource.ConfigSourcePriority getPriority() {
        return IConfigurationSource.ConfigSourcePriority.Medium;
    }

    public boolean isSupportingRoles() {
        return false;
    }

    public boolean requestKeyUpdate(IConfigurationCache iConfigurationCache, String string, List<String> list, String string2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPluginNotCached(String string, List<String> list, String string2) {
        Object object = this.mutex;
        synchronized (object) {
            this.initialized = false;
        }
    }

    public boolean requestKeyUpdate(IConfigurationCache iConfigurationCache, String string, String string2, String string3) {
        return this.requestKeyUpdate(iConfigurationCache, string, Collections.singletonList(string2), string3);
    }

    public void notifyPluginNotCached(String string, String string2, String string3) {
        this.notifyPluginNotCached(string, Collections.singletonList(string2), string3);
    }

    public void storeForRole(String string) {
    }

    static class CacheVisitor
    implements IConfigurationCacheVisitor {
        Map<ConfigLevel, BufferedWriter> files;

        public CacheVisitor(Map<ConfigLevel, BufferedWriter> map) {
            this.files = map;
        }

        public void visitEntry(ConfigLevel configLevel, long l, String string, ConfigType configType, Object object) {
            try {
                String string2 = String.valueOf(string) + ":" + configType + "=" + object.toString() + "\n";
                this.files.get(configLevel).write(string2);
            }
            catch (IOException iOException) {
                log.error("IO exception", (Throwable)iOException);
            }
        }
    }
}

