/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedFloatGroup
extends DistinctFileGroup {
    public CachedFloatGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        float[] fArray = (float[])object;
        object = fArray;
        Arrays.fill(fArray, 0.0f);
    }

    @Override
    public Object allocateNew() {
        try {
            return new float[(int)this.length];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.dataCache.ensureFreeMemory(this.length * 6L);
            try {
                return new float[(int)this.length];
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                this.dataCache.ensureFreeMemory(-1L);
                return new float[(int)this.length];
            }
        }
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeFloats((float[])object, string);
    }

    @Override
    public void readNIO(Object object, String object2) throws IOException {
        object = (float[])object;
        object2 = new RandomAccessFile((String)object2, "r");
        try {
            MappedByteBuffer mappedByteBuffer = ((RandomAccessFile)object2).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, ((Object)object).length << 2);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asFloatBuffer().get((float[])object);
        }
        finally {
            ((RandomAccessFile)object2).close();
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeFloats((float[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        object = (float[])object;
        try {
            RandomAccessFile randomAccessFile;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, ((Object)object).length << 2);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                mappedByteBuffer.asFloatBuffer().put((float[])object);
            }
            finally {
                randomAccessFile.close();
            }
            return;
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        if (object != null) {
            return ((float[])object).length << 2;
        }
        return this.length << 2;
    }
}

