/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.blocked;

import com.agfa.pacs.cache.AbstractArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CommonFileGroup;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.blocked.a;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;

public abstract class AbstractArrayContainerGroup
extends CommonFileGroup {
    private static final ALogger a = ALogger.getLogger(AbstractArrayContainerGroup.class);
    protected long nativeFileHandle;
    protected RandomAccessFile df;
    protected int typeMultiplier = 1;

    public AbstractArrayContainerGroup(DataCache dataCache) {
        super(dataCache, null, false);
    }

    public AbstractArrayContainerGroup(DataCache dataCache, String string) {
        super(dataCache, string, true);
        this.dataCache = dataCache;
        this.global = dataCache.getGlobalLRU();
    }

    @Override
    public Object getPersistent(CacheItem cacheItem, CacheID object) {
        object = (a)cacheItem;
        ((CacheItem)object).touch();
        Object object2 = ((a)object).a();
        if (object2 != null) {
            return object2;
        }
        this.readPersistent(cacheItem);
        object2 = ((a)object).a();
        ((CacheItem)object).releaseReferenceSynced();
        if (object2 == null) {
            throw new NullPointerException();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistent(Object object, CacheID object2, int n) {
        Object object3 = this.addPersistentInternal(object, (CacheID)object2, n);
        if (object3 != null) {
            object = (AbstractArrayContainer)object;
            this.dataCache.removeFromOutside(object.getData());
            object = this.getArrayGroup(object.getArrayLength());
            object.addPersistent((CacheItem)object3);
            object = this.getItemID((CacheID)object2);
            object3 = object2 = this.getIndex();
            synchronized (object2) {
                long[] lArray = (long[])this.deleted.remove(object);
                if (lArray != null) {
                    object2.put(object, lArray);
                } else {
                    object2.put(object, ADDED);
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public void free(Object object) {
        object = (AbstractArrayContainer)object;
        this.dataCache.free(object.getData());
    }

    @Override
    public boolean isAllocationAllowed() {
        return this.dataCache.getParameters().isAllocationAllowed(1234567L);
    }

    @Override
    public Object allocateNew() {
        throw new IllegalStateException();
    }

    @Override
    public void clear(Object object) {
    }

    @Override
    public Object readItem(long l, long l2) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void groupEmptied() {
        super.groupEmptied();
        super.dispose();
        this.notify();
    }

    @Override
    protected void closeDataFile() throws IOException {
        if (this.nativeFileHandle != 0L) {
            long l = ArrayIO.close(this.nativeFileHandle);
            this.nativeFileHandle = 0L;
            if (l != 0L) {
                throw new IOException(ArrayIO.getErrorMessage(l));
            }
        }
        if (this.df != null) {
            try {
                this.df.close();
            }
            catch (IOException iOException) {
                a.error("Unable to close file", (Throwable)iOException);
            }
            this.df = null;
        }
    }

    @Override
    protected long openDataFile() throws IOException {
        File file = new File(this.dataFile);
        if (ArrayIO.useNativeIO) {
            if (this.nativeFileHandle == 0L) {
                Object object = file.getParentFile();
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                object = (String.valueOf(this.dataFile) + "\u0000").getBytes();
                this.nativeFileHandle = ArrayIO.openForRW((byte[])object);
                if (this.nativeFileHandle == 0L) {
                    throw new IOException("failed to open file" + this.dataFile);
                }
            }
        } else if (this.df == null) {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            this.df = new RandomAccessFile(this.dataFile, "rw");
        }
        this.playbackTempFileAttributes();
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPersistent(CacheItem cacheItem) {
        Object object = cacheItem;
        synchronized (object) {
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                throw new IllegalArgumentException("id not known to cache " + cacheItem.getID());
            }
            cacheItem.addReferenceUnsynced();
            if (cacheItem.getUnsyncedState() == ItemState.READING) {
                while (cacheItem.getUnsyncedState() == ItemState.READING) {
                    try {
                        cacheItem.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            if (cacheItem.dataAvailableUnsynced()) {
                return;
            }
            cacheItem.setStateUnsynced(ItemState.READING);
            cacheItem.notify();
        }
        try {
            long[] lArray = this.getPosFromIndex(cacheItem.getID());
            object = lArray;
            long l = lArray[0];
            reference var6_8 = (object[1] - l) / (long)this.typeMultiplier;
            int n = (int)cacheItem.getManagementGroup().getSizeEstimate(null);
            Object object2 = this.createArrayContainer((long)var6_8, n, cacheItem.getPriority());
            Object object3 = this;
            synchronized (object3) {
                if (this.groupState != CommonFileGroup.FileGroupState.OPEN) {
                    Map<String, long[]> map = this.getIndex();
                    synchronized (map) {
                        this.openGroup(true);
                    }
                }
                object2 = this.readItem((AbstractArrayContainer)object2, l, (long)var6_8, cacheItem.getID());
                this.notifyAll();
            }
            object3 = cacheItem;
            synchronized (object3) {
                cacheItem.setDataUnsynced(object2);
                cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                cacheItem.notifyAll();
                return;
            }
        }
        catch (Exception exception) {
            CacheItem cacheItem2 = cacheItem;
            synchronized (cacheItem2) {
                cacheItem.setDataUnsynced(null);
                if (cacheItem.getUnsyncedState() != ItemState.DELETED) {
                    cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                }
                cacheItem.releaseReferenceSynced();
                cacheItem.notifyAll();
            }
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                throw new IllegalArgumentException();
            }
            log.error("Unable to read persistent cache item", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        if (object == null) {
            long[] lArray = this.getPosFromIndex(cacheID);
            object = lArray;
            if (lArray == ADDED) {
                return this.global.get(cacheID);
            }
            reference var4_4 = object[1] - object[0];
            return new a(null, cacheID, this, this.getArrayGroup(AbstractArrayContainer.roundUpSize((int)((int)var4_4))), n);
        }
        long l = ((AbstractArrayContainer)object).getArrayLength();
        object = new a(object, cacheID, this, this.getArrayGroup(l), n);
        if (this.isEmpty && IS_AGILITY) {
            try {
                this.setGroupAttribute("GroupState", "CREATED");
                this.isEmpty = false;
            }
            catch (IOException iOException) {
                a.warn("failed setting GroupState to CREATED");
            }
        }
        return object;
    }

    @Override
    public long[] writeItem(Object object, long l, CacheID cacheID) throws IOException {
        object = (AbstractArrayContainer)object;
        if (ArrayIO.useNativeIO) {
            this.writeNative((AbstractArrayContainer)object, l);
        } else {
            this.writeNIO((AbstractArrayContainer)object, l);
        }
        return new long[]{l, l + (long)(object.getDataLength() * this.typeMultiplier)};
    }

    public Object readItem(AbstractArrayContainer abstractArrayContainer, long l, long l2, CacheID cacheID) throws IOException {
        if (ArrayIO.useNativeIO) {
            this.readNative(abstractArrayContainer, l);
        } else {
            this.readNIO(abstractArrayContainer, l);
        }
        return abstractArrayContainer;
    }

    protected abstract AbstractArrayContainer createArrayContainer(long var1, long var3, int var5);

    protected abstract ICachedObjectGroup getArrayGroup(long var1);

    protected abstract void writeNative(AbstractArrayContainer var1, long var2) throws IOException;

    protected abstract void writeNIO(AbstractArrayContainer var1, long var2) throws IOException;

    protected abstract void readNative(AbstractArrayContainer var1, long var2) throws IOException;

    protected abstract void readNIO(AbstractArrayContainer var1, long var2) throws IOException;
}

