/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CachedObjectGroup;
import com.agfa.pacs.memcache.DataCache;
import java.io.File;
import java.io.IOException;

public abstract class DistinctFileGroup
extends CachedObjectGroup {
    protected long length;

    public DistinctFileGroup(long l, DataCache dataCache) {
        super(dataCache, true);
        this.length = l;
    }

    @Override
    public boolean isAllocationAllowed() {
        return this.dataCache.getParameters().isAllocationAllowed(this.length);
    }

    @Override
    public void writePersistent(Object object, CacheID object2) throws IOException {
        object2 = String.valueOf(this.dataCache.getParameters().getLocation()) + File.separatorChar + object2;
        File file = new File((String)object2);
        file.delete();
        object2 = new File(String.valueOf(object2) + ".part");
        if (ArrayIO.useNativeIO) {
            this.writeNative(object, ((File)object2).getAbsolutePath());
        } else {
            this.writeNIO(object, ((File)object2).getAbsolutePath());
        }
        ((File)object2).renameTo(file);
    }

    @Override
    public Object readPersistent(CacheID object, Object object2) throws IOException {
        object = String.valueOf(this.dataCache.getParameters().getLocation()) + File.separatorChar + object;
        if (ArrayIO.useNativeIO) {
            this.readNative(object2, (String)object);
        } else {
            this.readNIO(object2, (String)object);
        }
        return object2;
    }

    @Override
    public boolean persistentItemExists(CacheID cacheID) {
        return new File(String.valueOf(this.dataCache.getParameters().getLocation()) + File.separatorChar + cacheID).exists();
    }

    @Override
    public void removeFromDisk(CacheItem cacheItem, boolean bl) {
        this.dataCache.getOnDisk().deleteItem(cacheItem, bl);
    }

    public abstract void readNIO(Object var1, String var2) throws IOException;

    public abstract void readNative(Object var1, String var2) throws IOException;

    public abstract void writeNIO(Object var1, String var2) throws IOException;

    public abstract void writeNative(Object var1, String var2) throws IOException;

    public void writeNativeBytes(byte[] byArray, String string) throws IOException {
        byte[] byArray2 = (String.valueOf(string) + "\u0000").getBytes();
        if (this.getSizeEstimate(byArray) < 0x400000L) {
            if (ArrayIO.writeByteArray(byArray, byArray2) != 0L) {
                String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string2).mkdirs();
                long l = ArrayIO.writeByteArray(byArray, byArray2);
                if (l != 0L) {
                    new File(string).delete();
                    throw new IOException(String.valueOf(string) + ":" + ArrayIO.getErrorMessage(l));
                }
            }
        } else {
            long l = ArrayIO.openForWriting(byArray2);
            if (l == 0L) {
                String string3 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string3).mkdirs();
                l = ArrayIO.openForWriting(byArray2);
            }
            if (l != 0L) {
                long l2;
                int n = 0;
                while (n + 0x200000 <= byArray.length) {
                    l2 = ArrayIO.appendByteArray(byArray, n, 0x200000, l);
                    if (l2 != 0L) {
                        throw new IOException(ArrayIO.getErrorMessage(l2));
                    }
                    Thread.yield();
                    n += 0x200000;
                }
                if (n < byArray.length && (l2 = ArrayIO.appendByteArray(byArray, n, byArray.length - n, l)) != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
                l2 = ArrayIO.close(l);
                if (l2 != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
            } else {
                throw new IOException("Invalid file handle");
            }
        }
    }

    public void readNativeBytes(byte[] byArray, String string) throws IOException {
        long l = ArrayIO.readByteArray(byArray, (String.valueOf(string) + "\u0000").getBytes());
        if (l != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l));
        }
    }

    public void writeNativeInts(int[] nArray, String string) throws IOException {
        byte[] byArray = (String.valueOf(string) + "\u0000").getBytes();
        if (ArrayIO.writeIntArray(nArray, byArray) != 0L) {
            String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
            new File(string2).mkdirs();
            long l = ArrayIO.writeIntArray(nArray, byArray);
            if (l != 0L) {
                new File(string).delete();
                throw new IOException(ArrayIO.getErrorMessage(l));
            }
        }
    }

    public void readNativeInts(int[] nArray, String string) throws IOException {
        long l = ArrayIO.readIntArray(nArray, (String.valueOf(string) + "\u0000").getBytes());
        if (l != 0L) {
            throw new IOException(String.valueOf(ArrayIO.getErrorMessage(l)) + " at " + string);
        }
    }

    public void writeNativeShorts(short[] sArray, String string) throws IOException {
        byte[] byArray = (String.valueOf(string) + "\u0000").getBytes();
        if (this.getSizeEstimate(sArray) < 0x400000L) {
            if (ArrayIO.writeShortArray(sArray, byArray) != 0L) {
                String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string2).mkdirs();
                long l = ArrayIO.writeShortArray(sArray, byArray);
                if (l != 0L) {
                    new File(string).delete();
                    throw new IOException(ArrayIO.getErrorMessage(l));
                }
            }
        } else {
            long l = ArrayIO.openForWriting(byArray);
            if (l == 0L) {
                String string3 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string3).mkdirs();
                l = ArrayIO.openForWriting(byArray);
            }
            if (l != 0L) {
                long l2;
                int n = 0;
                while (n + 0x200000 <= sArray.length) {
                    l2 = ArrayIO.appendShortArray(sArray, n, 0x200000, l);
                    if (l2 != 0L) {
                        throw new IOException(ArrayIO.getErrorMessage(l2));
                    }
                    Thread.yield();
                    n += 0x200000;
                }
                if (n < sArray.length && (l2 = ArrayIO.appendShortArray(sArray, n, sArray.length - n, l)) != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
                l2 = ArrayIO.close(l);
                if (l2 != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
            }
        }
    }

    public void readNativeShorts(short[] sArray, String string) throws IOException {
        long l = ArrayIO.readShortArray(sArray, (String.valueOf(string) + "\u0000").getBytes());
        if (l != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l));
        }
    }

    public void writeNativeFloats(float[] fArray, String string) throws IOException {
        byte[] byArray = (String.valueOf(string) + "\u0000").getBytes();
        if (this.getSizeEstimate(fArray) <= 0x400000L) {
            if (ArrayIO.writeFloatArray(fArray, byArray) != 0L) {
                String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string2).mkdirs();
                long l = ArrayIO.writeFloatArray(fArray, byArray);
                if (l != 0L) {
                    new File(string).delete();
                    throw new IOException(ArrayIO.getErrorMessage(l));
                }
            }
        } else {
            long l = ArrayIO.openForWriting(byArray);
            if (l == 0L) {
                String string3 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string3).mkdirs();
                l = ArrayIO.openForWriting(byArray);
            }
            if (l != 0L) {
                long l2;
                int n = 0;
                while (n + 0x200000 <= fArray.length) {
                    l2 = ArrayIO.appendFloatArray(fArray, n, 0x200000, l);
                    if (l2 != 0L) {
                        throw new IOException(ArrayIO.getErrorMessage(l2));
                    }
                    Thread.yield();
                    n += 0x200000;
                }
                if (n < fArray.length && (l2 = ArrayIO.appendFloatArray(fArray, n, fArray.length - n, l)) != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
                l2 = ArrayIO.close(l);
                if (l2 != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
            } else {
                throw new IOException("Invalid file handle");
            }
        }
    }

    public void readNativeFloats(float[] fArray, String string) throws IOException {
        long l = ArrayIO.readFloatArray(fArray, (String.valueOf(string) + "\u0000").getBytes());
        if (l != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l));
        }
    }

    public void writeNativeDoubles(double[] dArray, String string) throws IOException {
        byte[] byArray = (String.valueOf(string) + "\u0000").getBytes();
        if (this.getSizeEstimate(dArray) < 0x400000L) {
            if (ArrayIO.writeDoubleArray(dArray, byArray) != 0L) {
                String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string2).mkdirs();
                long l = ArrayIO.writeDoubleArray(dArray, byArray);
                if (l != 0L) {
                    new File(string).delete();
                    throw new IOException(ArrayIO.getErrorMessage(l));
                }
            }
        } else {
            long l = ArrayIO.openForWriting(byArray);
            if (l == 0L) {
                String string3 = string.substring(0, string.lastIndexOf(File.separatorChar));
                new File(string3).mkdirs();
                l = ArrayIO.openForWriting(byArray);
            }
            if (l != 0L) {
                long l2;
                int n = 0;
                while (n + 0x200000 <= dArray.length) {
                    l2 = ArrayIO.appendDoubleArray(dArray, n, 0x200000, l);
                    if (l2 != 0L) {
                        throw new IOException(ArrayIO.getErrorMessage(l2));
                    }
                    Thread.yield();
                    n += 0x200000;
                }
                if (n < dArray.length && (l2 = ArrayIO.appendDoubleArray(dArray, n, dArray.length - n, l)) != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
                l2 = ArrayIO.close(l);
                if (l2 != 0L) {
                    throw new IOException(ArrayIO.getErrorMessage(l2));
                }
            } else {
                throw new IOException("Invalid file handle");
            }
        }
    }

    public void readNativeDoubles(double[] dArray, String string) throws IOException {
        long l = ArrayIO.readDoubleArray(dArray, (String.valueOf(string) + "\u0000").getBytes());
        if (l != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l));
        }
    }

    @Override
    public String getPersistentLocation(CacheID cacheID) {
        return String.valueOf(this.dataCache.getParameters().getLocation()) + File.separatorChar + cacheID;
    }
}

