/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CachedObjectGroup;
import com.agfa.pacs.memcache.DataCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonFileGroup
extends CachedObjectGroup {
    private static final ALogger a = ALogger.getLogger(CommonFileGroup.class);
    protected static final boolean IS_AGILITY = ApplicationManagement.getInstance().getApplicationType().isAgility();
    protected final String GROUP_STATE_ATTRIBUTE_NAME = "GroupState";
    protected final String GROUP_STATE_CREATED = "CREATED";
    protected static final long[] ADDED = new long[0];
    protected String dataFile;
    protected String indexFile;
    private volatile Map<String, long[]> b = null;
    protected Map<String, long[]> deleted;
    protected Map<String, long[]> toCommit;
    private long c;
    protected boolean destroyed;
    protected FileGroupState groupState = FileGroupState.CLOSED;
    private Map<String, String> d;
    protected boolean isEmpty = true;

    public CommonFileGroup(DataCache dataCache, String string, boolean bl) {
        super(dataCache, bl);
        if (string != null) {
            this.dataFile = String.valueOf(dataCache.getParameters().getLocation()) + File.separatorChar + string + ".dat";
            this.indexFile = String.valueOf(dataCache.getParameters().getLocation()) + File.separatorChar + string + ".idx";
            new File(this.indexFile).getParentFile().mkdirs();
            this.deleted = new HashMap<String, long[]>();
            this.toCommit = new HashMap<String, long[]>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemMembers() {
        Map<String, long[]> object2;
        Map<String, long[]> map = object2 = this.getIndex();
        synchronized (object2) {
            String[] stringArray = new String[object2.size()];
            int n = 0;
            for (String string : object2.keySet()) {
                stringArray[n++] = string;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean persistentItemExists(CacheID object) {
        object = this.getItemID((CacheID)object);
        Map<String, long[]> map = this.getIndex();
        Object object2 = map;
        synchronized (map) {
            if (map.containsKey(object)) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            object2 = this;
            synchronized (object2) {
                Map<String, long[]> map2 = map;
                synchronized (map2) {
                    if (map.containsKey(object)) {
                        return true;
                    }
                    if (this.groupState != FileGroupState.OPEN) {
                        try {
                            this.openGroup(true);
                        }
                        catch (IOException iOException) {
                            a.error("Unable to open group", (Throwable)iOException);
                        }
                    }
                    return this.deleted.containsKey(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePersistent(Object object, CacheID object2) throws IOException {
        Map<String, long[]> map;
        Object object3 = this.getItemID((CacheID)object2);
        if (this.groupState != FileGroupState.OPEN) {
            Map<String, long[]> map2 = this.getIndex();
            synchronized (map2) {
                this.openGroup(false);
            }
        }
        long l = this.c;
        object = this.writeItem(object, l, (CacheID)object2);
        this.c = (long)object[1];
        String string = object3;
        object3 = object;
        object2 = string;
        object = this;
        Map<String, long[]> map3 = map = ((CommonFileGroup)object).getIndex();
        synchronized (map) {
            if (((CommonFileGroup)object).groupState != FileGroupState.EMPTIED) {
                if (map.put((String)object2, (long[])object3) == null) {
                    ((CommonFileGroup)object).deleted.put((String)object2, map.remove(object2));
                }
            } else {
                ((CommonFileGroup)object).deleted.put((String)object2, (long[])object3);
            }
            ((CommonFileGroup)object).toCommit.put((String)object2, (long[])object3);
            // ** MonitorExit[var5_7] (shouldn't be in output)
            if (this.groupState == FileGroupState.EMPTIED) {
                this.a(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readPersistent(CacheID object, Object object2) throws IOException {
        if (this.groupState != FileGroupState.OPEN) {
            object2 = this.getIndex();
            synchronized (object2) {
                this.openGroup(true);
            }
        }
        long[] lArray = this.getPosFromIndex((CacheID)object);
        object2 = lArray;
        long l = lArray[0];
        object = this.readItem(l, (long)(object2[1] - l));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl) throws IOException {
        Map<String, long[]> map = this.getIndex();
        synchronized (map) {
            if (bl && this.groupState != FileGroupState.EMPTIED) {
                return;
            }
            if (this.groupState != FileGroupState.CLOSED) {
                this.closeDataFile();
                CommonFileGroup commonFileGroup = this;
                if (!commonFileGroup.toCommit.isEmpty()) {
                    DataOutputStream dataOutputStream;
                    File object2 = new File(commonFileGroup.indexFile);
                    try {
                        dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(object2, true)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        object2.getParentFile().mkdirs();
                        dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(object2, true)));
                    }
                    for (Map.Entry<String, long[]> entry : commonFileGroup.toCommit.entrySet()) {
                        dataOutputStream.writeBytes(String.valueOf(entry.getKey()) + "\n");
                        long[] lArray = entry.getValue();
                        dataOutputStream.writeLong(lArray[0]);
                        dataOutputStream.writeLong(lArray[1]);
                    }
                    commonFileGroup.toCommit.clear();
                    dataOutputStream.close();
                }
                if (this.groupState == FileGroupState.OPEN) {
                    this.groupState = FileGroupState.CLOSED;
                }
            }
            return;
        }
    }

    protected void openGroup(boolean bl) throws IOException {
        if (this.groupState != FileGroupState.OPEN) {
            File file = new File(this.indexFile);
            if (!file.exists()) {
                this.deleted.clear();
            }
            if (this.groupState == FileGroupState.CLOSED || this.groupState == FileGroupState.EMPTIED && !this.getIndex().isEmpty() || bl) {
                this.groupState = FileGroupState.OPEN;
            }
            this.c = this.openDataFile();
        }
    }

    protected abstract long openDataFile() throws IOException;

    protected abstract void closeDataFile() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDisk(CacheItem object, boolean bl) {
        String string = ((CacheItem)object).getID().toString();
        int n = string.lastIndexOf(File.separatorChar);
        string = n >= 0 ? string.substring(n + 1) : string.toString();
        this.dataCache.getOnDisk().removeFromList((CacheItem)object);
        object = this.getIndex();
        Map<String, long[]> map = object;
        synchronized (object) {
            long[] lArray = (long[])object.remove(string);
            if (lArray != ADDED && lArray != null) {
                this.deleted.put(string, lArray);
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            if (object.size() == 0) {
                this.groupEmptied();
                this.dataCache.getOnDisk().setDeleteOccured();
            }
            return;
        }
    }

    protected void groupEmptied() {
        this.groupState = FileGroupState.EMPTIED;
    }

    public abstract Object readItem(long var1, long var3) throws IOException;

    public abstract long[] writeItem(Object var1, long var2, CacheID var4) throws IOException;

    @Override
    public synchronized void dispose() {
        try {
            this.a(false);
        }
        catch (IOException iOException) {
            a.error("Unable to close group", (Throwable)iOException);
        }
        if (!this.dataCache.getParameters().isPermanent()) {
            File file = new File(this.dataFile);
            file.delete();
            new File(this.indexFile).delete();
            file.getParentFile().delete();
            this.deleted.clear();
            this.destroyed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isEmpty() {
        return this.getIndex().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getPosFromIndex(CacheID cacheID) {
        Map<String, long[]> map;
        String string = this.getItemID(cacheID);
        Map<String, long[]> map2 = map = this.getIndex();
        synchronized (map) {
            long[] lArray = map.get(string);
            if (lArray == null && (lArray = this.deleted.remove(string)) != null) {
                map.put(string, lArray);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (lArray == null) {
                throw new IllegalStateException("item " + cacheID + " not on disk");
            }
            return lArray;
        }
    }

    protected String getItemID(CacheID object) {
        int n = ((String)(object = object.toString())).lastIndexOf(File.separatorChar);
        if (n >= 0) {
            return ((String)object).substring(n + 1);
        }
        return ((String)object).toString();
    }

    @Override
    public synchronized void flush() {
        if (this.getIndex() == null) {
            return;
        }
        super.flush();
        try {
            this.a(false);
            return;
        }
        catch (IOException iOException) {
            a.error("Unable to close group", (Throwable)iOException);
            return;
        }
    }

    @Override
    public String getPersistentLocation(CacheID cacheID) {
        return this.dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, long[]> getIndex() {
        if (this.indexFile == null) {
            return null;
        }
        if (this.b == null) {
            CommonFileGroup commonFileGroup = this;
            synchronized (commonFileGroup) {
                if (this.b == null) {
                    CommonFileGroup commonFileGroup2 = this;
                    this.b = Collections.synchronizedMap(new HashMap());
                    File file = new File(commonFileGroup2.indexFile);
                    if (file.exists()) {
                        try {
                            String string;
                            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                            commonFileGroup2.c = new File(commonFileGroup2.dataFile).length();
                            while ((string = dataInputStream.readLine()) != null) {
                                commonFileGroup2.b.put(string, new long[]{dataInputStream.readLong(), dataInputStream.readLong()});
                            }
                            dataInputStream.close();
                        }
                        catch (IOException iOException) {
                            file.delete();
                            new File(commonFileGroup2.dataFile).delete();
                            commonFileGroup2.b.clear();
                            commonFileGroup2.deleted.clear();
                        }
                    }
                }
            }
        }
        return this.b;
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        object = super.createItem(object, cacheID, n);
        if (this.isEmpty && IS_AGILITY) {
            try {
                this.setGroupAttribute("GroupState", "CREATED");
                this.isEmpty = false;
            }
            catch (IOException iOException) {
                a.warn("failed setting GroupState to CREATED");
            }
        }
        return object;
    }

    protected synchronized void playbackTempFileAttributes() throws IOException {
        Map<String, String> object2 = this.d;
        this.d = null;
        if (object2 != null) {
            for (Map.Entry<String, String> entry : object2.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2 != null) {
                    this.setGroupAttribute(string, string2);
                    continue;
                }
                this.deleteGroupAttribute(string);
            }
        }
    }

    @Override
    public synchronized String getGroupAttribute(String string) throws IOException {
        UserDefinedFileAttributeView userDefinedFileAttributeView = CommonFileGroup.a(this.dataFile);
        if (userDefinedFileAttributeView != null) {
            int n = userDefinedFileAttributeView.size(string);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            userDefinedFileAttributeView.read(string, byteBuffer);
            byteBuffer.flip();
            return Charset.defaultCharset().decode(byteBuffer).toString();
        }
        if (this.d != null) {
            return this.d.get(string);
        }
        return null;
    }

    @Override
    public synchronized void setGroupAttribute(String string, String string2) throws IOException {
        UserDefinedFileAttributeView userDefinedFileAttributeView = CommonFileGroup.a(this.dataFile);
        if (userDefinedFileAttributeView != null) {
            userDefinedFileAttributeView.write(string, Charset.defaultCharset().encode(string2));
            return;
        }
        if (this.d == null) {
            this.d = new HashMap<String, String>();
        }
        this.d.put(string, string2);
    }

    @Override
    public synchronized void deleteGroupAttribute(String string) throws IOException {
        UserDefinedFileAttributeView userDefinedFileAttributeView = CommonFileGroup.a(this.dataFile);
        if (userDefinedFileAttributeView != null) {
            userDefinedFileAttributeView.delete(string);
        } else {
            if (this.d == null) {
                this.d = new HashMap<String, String>();
            }
            this.d.put(string, null);
        }
        if (string.equals("GroupState")) {
            this.isEmpty = true;
        }
    }

    private static UserDefinedFileAttributeView a(String object) throws IOException {
        if (Files.exists((Path)(object = Paths.get((String)object, new String[0])), new LinkOption[0])) {
            FileStore fileStore = Files.getFileStore((Path)object);
            if (!fileStore.supportsFileAttributeView(UserDefinedFileAttributeView.class)) {
                throw new UnsupportedOperationException("UserDefinedFileAttributeView not supported on FileStore: " + fileStore);
            }
            return Files.getFileAttributeView((Path)object, UserDefinedFileAttributeView.class, new LinkOption[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = new File(this.dataFile);
        if (((File)object).exists()) {
            stringBuffer.append("data file " + this.dataFile + " exists, size=" + ((File)object).length() + "\n");
        } else {
            stringBuffer.append("data file " + this.dataFile + " not on disk\n");
        }
        Map.Entry<String, long[]> entry2 = new File(this.indexFile);
        if (((File)object).exists()) {
            stringBuffer.append("index file " + this.indexFile + " exists, size=" + ((File)((Object)entry2)).length() + "\n");
        } else {
            stringBuffer.append("index file " + this.indexFile + " not on disk\n");
        }
        stringBuffer.append("append position:" + this.c + "\n");
        stringBuffer.append("destroyed=" + this.destroyed + "\n");
        stringBuffer.append("groupState=" + (Object)((Object)this.groupState) + "\n");
        stringBuffer.append("isEmpty=" + this.isEmpty + "\n");
        object = this.getIndex();
        synchronized (object) {
            long[] lArray;
            stringBuffer.append("index map:\n");
            for (Map.Entry<String, long[]> entry2 : this.b.entrySet()) {
                lArray = entry2.getValue();
                if (lArray == ADDED) {
                    stringBuffer.append(String.valueOf((String)entry2.getKey()) + "->ADDED\n");
                    continue;
                }
                stringBuffer.append(String.valueOf((String)entry2.getKey()) + "->" + lArray[0] + "," + lArray[1] + "\n");
            }
            stringBuffer.append("deleted map:\n");
            for (Map.Entry<String, long[]> entry2 : this.deleted.entrySet()) {
                lArray = entry2.getValue();
                if (lArray == ADDED) {
                    stringBuffer.append(String.valueOf(entry2.getKey()) + "->ADDED\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(entry2.getKey()) + "->" + lArray[0] + "," + lArray[1] + "\n");
            }
            stringBuffer.append("toCommit map:\n");
            for (Map.Entry<String, long[]> entry2 : this.toCommit.entrySet()) {
                lArray = entry2.getValue();
                if (lArray == ADDED) {
                    stringBuffer.append(String.valueOf(entry2.getKey()) + "->ADDED\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(entry2.getKey()) + "->" + lArray[0] + "," + lArray[1] + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected static enum FileGroupState {
        CLOSED,
        OPEN,
        EMPTIED;

    }
}

