/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.Messages;
import com.agfa.pacs.memcache.internal.MemoryManagementLink;
import com.agfa.pacs.tools.StringTools;
import com.agfa.pacs.tools.TempDirectoryProvider;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import javax.swing.JOptionPane;

public class CacheParameters
implements IConfigurationChangeListener {
    private static final IConfigurationProvider a = ConfigurationProviderFactory.getConfig();
    private static final boolean b = ApplicationManagement.getInstance().getApplicationType().isAgility();
    public static final String AGILITY_CACHE_SUBDIR = "unversioned";
    private static final String c = b ? "doNeverEverChangeOrReferenceThisKey.UseDisk" : "UseDisk";
    private static final ALogger d = ALogger.getLogger(CacheParameters.class);
    private static boolean e = false;
    private boolean f;
    private boolean g;
    private boolean h;
    private long i;
    private long j;
    private String k;
    private double l = 0.15;
    private double m;
    private long n;
    private long o;
    private boolean p;
    private long q;
    private long r;
    private String s;
    private boolean t = false;
    private boolean u;
    private final IConfigurationProvider v = a.getNode("com.agfa.memcache");
    private IConfigurationProvider w;

    public CacheParameters() {
        Object object;
        boolean bl;
        this.a();
        CacheParameters cacheParameters = this;
        if (cacheParameters.w.exists("PersistentCacheDir")) {
            cacheParameters.k = cacheParameters.w.getString("PersistentCacheDir");
        } else {
            cacheParameters.k = cacheParameters.v.getString("PersistentCacheDir");
            d.warn("The config entry for the cache dir does not exist on workstation group level. Setting on workstation level will be used!");
        }
        if (System.getProperty("config.cache") != null) {
            cacheParameters.k = System.getProperty("config.cache");
        }
        if (bl = "TEMP".equalsIgnoreCase(cacheParameters.k)) {
            cacheParameters.k = CacheParameters.b();
        }
        if (!b && cacheParameters.d() && !cacheParameters.f()) {
            object = cacheParameters.k;
            Object object2 = new File("").getAbsoluteFile();
            if (((File)object2).getName().equalsIgnoreCase("LOG")) {
                object2 = ((File)object2).getParentFile();
            }
            object2 = new File((File)object2, "Cache");
            cacheParameters.k = ((File)object2).getAbsolutePath();
            Object object3 = object;
            object = cacheParameters.k;
            object2 = object3;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The configured cache directory '");
            stringBuilder.append((String)object2);
            stringBuilder.append("' is not writable, using fallback: ");
            stringBuilder.append((String)object);
            d.error(stringBuilder.toString());
            if (!Boolean.parseBoolean(System.getProperty("java.awt.headless"))) {
                object = new Runnable(){

                    @Override
                    public final void run() {
                        JOptionPane.showMessageDialog(null, Messages.getString("CacheParameters.DirectoryNotWritable.Message"), Messages.getString("CacheParameters.DirectoryNotWritable.Title"), 0);
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    object.run();
                } else {
                    EventQueue.invokeLater((Runnable)object);
                }
            }
        }
        if (cacheParameters.k.endsWith("/")) {
            cacheParameters.k = cacheParameters.k.substring(0, cacheParameters.k.length() - 1);
        }
        if (!cacheParameters.k.endsWith(File.separator)) {
            cacheParameters.k = String.valueOf(cacheParameters.k) + File.separatorChar;
        }
        if (!bl) {
            cacheParameters.k = b ? String.valueOf(cacheParameters.k) + TempDirectoryProvider.AGILITY_CACHE_DIR_INFIX + File.separator + AGILITY_CACHE_SUBDIR + File.separator : String.valueOf(cacheParameters.k) + "Cache" + File.separator;
        }
        if (!((File)(object = new File(cacheParameters.k))).mkdirs() && !((File)object).exists()) {
            d.warn("Couldn't create directory for cache in: " + cacheParameters.k + ". The cache directory of the temp directory is used instead!");
            cacheParameters.k = CacheParameters.b();
            File file = new File(cacheParameters.k);
            if (!file.mkdirs() && !file.exists()) {
                d.error("Couldn't create directory for cache in temp directory: " + cacheParameters.k);
            }
        }
        cacheParameters.s = String.valueOf(cacheParameters.k) + "locks" + File.separatorChar;
        this.c();
        this.e();
        a.registerConfigurationChangeListener("com.agfa.memcache", (IConfigurationChangeListener)this);
    }

    /*
     * Unable to fully structure code
     */
    private void a() {
        var1_1 = this;
        if (!var1_1.v.exists("UseWorkstationGroupSettings") || !var1_1.v.getBoolean("UseWorkstationGroupSettings")) ** GOTO lbl7
        if (var1_1.v.exists("workstationGroup")) {
            v0 = true;
        } else {
            CacheParameters.d.warn("It is configured to use the cache settings on workstation group level, but the required config node does not exist! Config entries on workstation level are used instead!");
lbl7:
            // 2 sources

            v0 = this.u = false;
        }
        if (this.u) {
            this.w = this.v.getNode("workstationGroup");
            return;
        }
        this.w = this.v;
    }

    private static String b() {
        if (b) {
            return TempDirectoryProvider.getCacheDirectory((String)AGILITY_CACHE_SUBDIR).toString();
        }
        return new File(System.getProperty("java.io.tmpdir"), "Cache").getAbsolutePath();
    }

    private void c() {
        this.f = this.d();
        this.g = this.a("SessionPersistence", null);
        this.h = this.a("ContinuousCacheCleanup", !b);
        if (this.w.exists("DiskSizeLimit")) {
            this.q = StringTools.parseMemoryAmount((String)this.w.getString("DiskSizeLimit"));
        } else {
            this.q = StringTools.parseMemoryAmount((String)this.v.getString("DiskSizeLimit"));
            d.warn("The config entry for the disk size limit does not exist on workstation group level. Setting on workstation level will be used!");
        }
        this.r = StringTools.parseMemoryAmount((String)this.v.getString("DiskFreeLimit"));
        this.l = Double.parseDouble(this.v.getString("MinimumFreePercentage"));
        this.m = Double.parseDouble(this.v.getString("CleanFreePercentage"));
        this.t = this.v.getBoolean("SlowCacheWriting");
        this.p = this.v.getBoolean("KeepFootprintSmall");
    }

    private boolean d() {
        return this.v.getBoolean(c);
    }

    private boolean a(String string, Boolean bl) {
        boolean bl2;
        if (this.w.exists(string)) {
            bl2 = this.w.getBoolean(string);
        } else if (bl == null || this.v.exists(string)) {
            d.warn("The config entry for {} does not exist on workstation group level. Setting on workstation level will be used!", (Object)string);
            bl2 = this.v.getBoolean(string);
        } else {
            bl2 = bl;
        }
        return bl2;
    }

    private void e() {
        try {
            long l = Runtime.getRuntime().maxMemory();
            this.i = (long)((double)l * this.l);
            this.j = (long)((double)l * this.m);
            long l2 = l;
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : list) {
                if (!"Tenured Gen".equals(memoryPoolMXBean.getName())) continue;
                l2 = memoryPoolMXBean.getUsage().getMax();
                break;
            }
            long l3 = (long)((double)l2 * this.l);
            long l4 = (long)((double)l2 * this.m);
            this.n = (long)((double)l2 - (double)l4 * 1.1);
            this.o = (long)((double)l2 - (double)l3 * 1.1);
            return;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.i = (long)((double)Runtime.getRuntime().totalMemory() * this.l);
            this.j = (long)((double)Runtime.getRuntime().totalMemory() * this.m);
            this.n = (long)((double)Runtime.getRuntime().totalMemory() - (double)this.j * 1.1);
            this.o = (long)((double)Runtime.getRuntime().totalMemory() - (double)this.i * 1.1);
            return;
        }
    }

    public boolean isAllocationAllowed(long l) {
        return this.getFreeMem() - l > this.i;
    }

    public boolean isCleanThresholdExceeded() {
        return this.getFreeMem() < this.j;
    }

    public boolean isSlowCacheWriting() {
        return this.t;
    }

    public boolean keepFootprintSmall() {
        return this.p;
    }

    public long getFreeMem() {
        try {
            return Math.max(0L, Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory() - MemoryManagementLink.getFreeMin());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Runtime.getRuntime().freeMemory();
        }
    }

    public boolean usePersistentStorage() {
        return this.f;
    }

    public String getLocation() {
        return this.k;
    }

    public boolean isPermanent() {
        return this.g || e || this.clearCacheOnShutdown();
    }

    public boolean clearCacheOnShutdown() {
        return !this.g && !this.h;
    }

    public long getUsageThreshold() {
        return this.n;
    }

    public long getCriticalUsageThreshold() {
        return this.o;
    }

    public long toFreeOnCollectionThresholdNotif() {
        return (long)((double)(this.getCriticalUsageThreshold() - this.getUsageThreshold()) * 1.5);
    }

    public long getDiskSizeLimit() {
        return this.q;
    }

    public long getMinimumFreeDisk() {
        return this.r;
    }

    public String getLockDirectoryPath() {
        return this.s;
    }

    public void configurationChanged(String string) {
        this.a();
        this.c();
        this.e();
    }

    public static void forceSessionPersistence() {
        e = true;
    }

    public static boolean useNativeDll() {
        return a.getNode("com.agfa.memcache").getBoolean("UseNativeDLL");
    }

    public void updateEdenSpace(long l) {
        double d2;
        double d3 = (double)l / (double)Runtime.getRuntime().maxMemory();
        if (d2 > 0.09) {
            this.l = d3 * 1.5;
            this.m += this.l;
        }
        this.e();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean f() {
        FileOutputStream fileOutputStream;
        File file = new File(this.k);
        file.mkdirs();
        file = new File(file, "TEMP");
        file.deleteOnExit();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            file.delete();
            return false;
        }
        catch (Throwable throwable) {
            file.delete();
            throw throwable;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            d.warn("Closing stream failed.", (Throwable)iOException);
        }
        file.delete();
        return true;
    }
}

