/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CachedObjectGroup;
import com.agfa.pacs.memcache.DataCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.BitSet;

public abstract class BlockedFileGroup
extends CachedObjectGroup {
    private static final ALogger a = ALogger.getLogger(BlockedFileGroup.class);
    protected long nativeFileHandle;
    protected RandomAccessFile df;
    private BitSet b;
    private DataOutputStream c;
    private volatile boolean d = false;
    private String e;
    protected String dataFile;
    protected long length;

    public BlockedFileGroup(DataCache object, String string, boolean bl, long l) {
        super((DataCache)object, bl);
        this.e = string;
        this.dataFile = String.valueOf(((DataCache)object).getParameters().getLocation()) + File.separatorChar + string + ".dat";
        this.setLength(l);
        object = new File(this.dataFile);
        if (!((File)object).getParentFile().mkdirs()) {
            a.warn("failed creating directory: " + ((File)object).getParentFile().getAbsolutePath());
        }
    }

    protected void reOpen() {
        String string = String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 4)) + ".nfo";
        if (!this.a(string) && this.length >= 0L) {
            this.createInfoFile(string);
        }
    }

    public void setLength(long l) {
        this.length = l;
    }

    protected void createInfoFile(String object) {
        this.b = new BitSet();
        try {
            object = new DataOutputStream(new FileOutputStream((String)object));
            ((DataOutputStream)object).writeLong(this.length);
            this.c = object;
            return;
        }
        catch (IOException iOException) {
            a.error("IO error creating info file", (Throwable)iOException);
            return;
        }
    }

    private boolean a(String string) {
        File file;
        block4: {
            file = new File(string);
            if (file.exists()) break block4;
            return false;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            this.setLength(dataInputStream.readLong());
            int n = (int)(file.length() / 4L - 2L);
            this.b = new BitSet(n);
            int n2 = 0;
            while (n2 < n) {
                this.b.set(dataInputStream.readInt());
                ++n2;
            }
            dataInputStream.close();
            this.c = new DataOutputStream(new FileOutputStream(string, true));
        }
        catch (IOException iOException) {
            this.b = new BitSet();
        }
        return true;
    }

    @Override
    public void writePersistent(Object object, CacheID object2) throws IOException {
        if (this.length <= 0L) {
            this.setLength(this.getSizeEstimate(object));
            this.createInfoFile(String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 3)) + "nfo");
        }
        if (!this.b()) {
            this.a();
        }
        object2 = object2.toString();
        int n = ((String)object2).lastIndexOf(35);
        int n2 = Integer.parseInt(((String)object2).substring(n + 1));
        long l = (long)n2 * this.length;
        if (ArrayIO.useNativeIO) {
            this.writeNative(object, l);
        } else {
            this.writeNIO(object, l);
        }
        this.c();
        if (this.b == null) {
            return;
        }
        this.b.set(n2);
        if (this.c != null) {
            this.c.writeInt(n2);
        }
    }

    private void a() throws FileNotFoundException {
        a.debug("OPENING VOLUME FILE " + this.dataFile);
        if (!ArrayIO.useNativeIO) {
            this.df = new RandomAccessFile(this.dataFile, "rw");
            return;
        }
        byte[] byArray = (String.valueOf(this.dataFile) + "\u0000").getBytes();
        do {
            this.nativeFileHandle = ArrayIO.openForRW(byArray);
            if (this.nativeFileHandle != 0L) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } while (this.nativeFileHandle == 0L);
    }

    private boolean b() {
        if (ArrayIO.useNativeIO) {
            return this.nativeFileHandle != 0L;
        }
        return this.df != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        BlockedFileGroup blockedFileGroup = this;
        synchronized (blockedFileGroup) {
            try {
                this.c();
                if (this.c != null) {
                    this.c.flush();
                }
                if (ArrayIO.useNativeIO) {
                    a.debug("FLUSH, CLOSING VOLUME FILE " + this.dataFile);
                    if (this.nativeFileHandle != 0L) {
                        long l = ArrayIO.close(this.nativeFileHandle);
                        this.nativeFileHandle = 0L;
                        if (l != 0L) {
                            a.error("io error flushing: " + ArrayIO.getErrorMessage(l));
                        }
                    }
                } else {
                    this.df.close();
                    this.df = null;
                }
            }
            catch (IOException iOException) {
                a.error("io error flushing", (Throwable)iOException);
            }
            super.flush();
            return;
        }
    }

    public abstract void writeNative(Object var1, long var2) throws IOException;

    public abstract void writeNIO(Object var1, long var2) throws IOException;

    public abstract void readNative(Object var1, long var2) throws IOException;

    public abstract void readNIO(Object var1, long var2) throws IOException;

    @Override
    public boolean persistentItemExists(CacheID object) {
        object = object.toString();
        int n = ((String)object).lastIndexOf(35);
        int n2 = Integer.parseInt(((String)object).substring(n + 1));
        this.c();
        if (this.b == null) {
            this.reOpen();
        }
        if (this.b != null && n2 < this.b.size()) {
            return this.b.get(n2);
        }
        return false;
    }

    @Override
    public Object readPersistent(CacheID object, Object object2) throws IOException {
        if (this.length < 0L) {
            throw new IllegalStateException();
        }
        if (!this.b()) {
            this.a();
        }
        object = object.toString();
        int n = ((String)object).lastIndexOf(35);
        int n2 = Integer.parseInt(((String)object).substring(n + 1));
        this.c();
        if (this.b == null || n2 >= this.b.size() || !this.b.get(n2)) {
            return null;
        }
        long l = (long)n2 * this.length;
        if (ArrayIO.useNativeIO) {
            this.readNative(object2, l);
        } else {
            this.readNIO(object2, l);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDisk(CacheItem object, boolean bl) {
        String string = ((CacheItem)object).getID().toString();
        int n = string.lastIndexOf(35);
        int n2 = Integer.parseInt(string.substring(n + 1));
        this.dataCache.getOnDisk().removeFromList((CacheItem)object);
        object = this;
        synchronized (object) {
            this.c();
            if (this.b != null && n2 < this.b.size()) {
                this.b.clear(n2);
            }
            if (this.b == null || this.b.cardinality() == 0) {
                try {
                    a.debug("ALL REMOVED, CLOSING VOLUME FILE " + this.dataFile);
                    if (this.df != null) {
                        this.df.close();
                    }
                    if (this.c != null) {
                        this.c.close();
                    }
                    if (this.nativeFileHandle != 0L) {
                        long l = ArrayIO.close(this.nativeFileHandle);
                        this.nativeFileHandle = 0L;
                        if (l != 0L) {
                            a.error("IO error removing item from disk: " + ArrayIO.getErrorMessage(l));
                        }
                    }
                }
                catch (IOException iOException) {
                    a.error("IO error removing item from disk", (Throwable)iOException);
                }
                this.dataCache.getOnDisk().setDeleteOccured();
                this.b = null;
            }
            return;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return this.length;
    }

    @Override
    public void addPersistent(Object object, CacheID cacheID, int n) {
        if (this.length < 0L) {
            this.setLength(this.getSizeEstimate(object));
            this.createInfoFile(String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 3)) + "nfo");
        }
        super.addPersistent(object, cacheID, n);
    }

    public abstract Object readItem(InputStream var1, long var2) throws IOException;

    public abstract void writeItem(DataOutputStream var1, Object var2) throws IOException;

    @Override
    public String getPersistentLocation(CacheID cacheID) {
        return this.dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        if (!this.d) {
            BlockedFileGroup blockedFileGroup = this;
            synchronized (blockedFileGroup) {
                if (!this.d) {
                    String string = String.valueOf(this.dataCache.getParameters().getLocation()) + File.separatorChar + this.e + ".nfo";
                    if (!this.a(string) && this.length >= 0L) {
                        this.createInfoFile(string);
                    }
                    this.d = true;
                }
                return;
            }
        }
    }

    protected BitSet getPresence() {
        this.c();
        return this.b;
    }

    protected DataOutputStream getDPresence() {
        this.c();
        return this.c;
    }
}

