/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FloatingInfo;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.ShiftedFloatingBounds;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.style.BlockRenderState;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderThreadState;
import org.lobobrowser.util.Objects;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLBodyElement;

public class RBlock
extends BaseElementRenderable
implements RenderableContainer,
ImageObserver {
    protected static final Logger logger = Logger.getLogger(RBlock.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private static final int MAX_CACHE_SIZE = 10;
    protected final FrameContext frameContext;
    protected final int listNesting;
    protected final HtmlRendererContext rendererContext;
    protected final RBlockViewport bodyLayout;
    protected final Map cachedLayout = new Hashtable(5);
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected JScrollBar vScrollBar;
    protected JScrollBar hScrollBar;
    protected boolean hasHScrollBar = false;
    protected boolean hasVScrollBar = false;
    protected int defaultOverflowX = 0;
    protected int defaultOverflowY = 0;
    private LayoutValue lastLayoutValue = null;
    private LayoutKey lastLayoutKey = null;
    private boolean resettingScrollBars = false;
    private BoundableRenderable armedRenderable;

    public RBlock(NodeImpl nodeImpl, int n, UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext, RenderableContainer renderableContainer) {
        super(renderableContainer, (ModelNode)nodeImpl, userAgentContext);
        RBlockViewport rBlockViewport;
        this.listNesting = n;
        this.frameContext = frameContext;
        this.rendererContext = htmlRendererContext;
        this.bodyLayout = rBlockViewport = new RBlockViewport((ModelNode)nodeImpl, (RenderableContainer)this, this.getViewportListNesting(n), userAgentContext, htmlRendererContext, frameContext, (RCollection)this);
        rBlockViewport.setOriginalParent((RCollection)this);
        rBlockViewport.setX(Short.MAX_VALUE);
        rBlockViewport.setY(Short.MAX_VALUE);
    }

    public int getVScrollBarWidth() {
        return 16;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getVAlign() {
        return 5;
    }

    public void ensureVisible(Point point) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            boolean bl = this.hasHScrollBar;
            boolean bl2 = this.hasVScrollBar;
            int n = rBlockViewport.x;
            int n2 = rBlockViewport.y;
            Insets insets = this.getInsets(bl, bl2);
            if (bl) {
                if (point.x < insets.left) {
                    rBlockViewport.x += insets.left - point.x;
                } else if (point.x > this.width - insets.right) {
                    rBlockViewport.x -= point.x - this.width + insets.right;
                }
            }
            if (bl2) {
                if (point.y < insets.top) {
                    rBlockViewport.y += insets.top - point.y;
                } else if (point.y > this.height - insets.bottom) {
                    rBlockViewport.y -= point.y - this.height + insets.bottom;
                }
            }
            if (bl || bl2) {
                this.correctViewportOrigin(insets, this.width, this.height);
                if (n != rBlockViewport.x || n2 != rBlockViewport.y) {
                    this.resetScrollBars(null);
                    this.repaint();
                }
            }
        }
    }

    private JScrollBar getHScrollBar() {
        JScrollBar jScrollBar = this.hScrollBar;
        if (jScrollBar == null) {
            jScrollBar = new JScrollBar(0);
            jScrollBar.addAdjustmentListener(new LocalAdjustmentListener(0));
            this.hScrollBar = jScrollBar;
        }
        return jScrollBar;
    }

    private JScrollBar getVScrollBar() {
        JScrollBar jScrollBar = this.vScrollBar;
        if (jScrollBar == null) {
            jScrollBar = new JScrollBar(1);
            jScrollBar.addAdjustmentListener(new LocalAdjustmentListener(1));
            this.vScrollBar = jScrollBar;
        }
        return jScrollBar;
    }

    public final boolean isOverflowVisibleX() {
        int n = this.overflowX;
        return n == 0 || n == 4;
    }

    public final boolean isOverflowVisibleY() {
        int n = this.overflowY;
        return n == 0 || n == 4;
    }

    public int getFirstLineHeight() {
        return this.bodyLayout.getFirstLineHeight();
    }

    public int getFirstBaselineOffset() {
        return this.bodyLayout.getFirstBaselineOffset();
    }

    public void setSelectionEnd(RenderableSpot renderableSpot) {
        this.endSelection = renderableSpot;
    }

    public void setSelectionStart(RenderableSpot renderableSpot) {
        this.startSelection = renderableSpot;
    }

    public int getViewportListNesting(int n) {
        return n;
    }

    public void paint(Graphics graphics) {
        long l;
        long l2;
        long l3;
        long l4;
        boolean bl;
        block24: {
            RenderState renderState = this.modelNode.getRenderState();
            if (renderState != null && renderState.getVisibility() != 0) {
                return;
            }
            bl = loggableInfo;
            l4 = bl ? System.currentTimeMillis() : 0L;
            this.prePaint(graphics);
            l3 = bl ? System.currentTimeMillis() : 0L;
            l2 = 0L;
            try {
                Object object;
                JScrollBar jScrollBar;
                int n;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                RBlockViewport rBlockViewport = this.bodyLayout;
                if (rBlockViewport != null) {
                    int n2 = this.overflowX;
                    int n3 = this.overflowY;
                    if (!(n2 != 0 && n2 != 4 || n3 != 0 && n3 != 4)) {
                        n = rBlockViewport.x;
                        int n4 = rBlockViewport.y;
                        graphics.translate(n, n4);
                        try {
                            rBlockViewport.paint(graphics);
                        }
                        finally {
                            graphics.translate(-n, -n4);
                        }
                    }
                    Graphics graphics2 = graphics.create(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
                    try {
                        graphics2.translate(rBlockViewport.x - insets.left, rBlockViewport.y - insets.top);
                        rBlockViewport.paint(graphics2);
                    }
                    finally {
                        graphics2.dispose();
                    }
                    if (bl) {
                        l2 = System.currentTimeMillis();
                    }
                }
                RenderableSpot renderableSpot = this.startSelection;
                RenderableSpot renderableSpot2 = this.endSelection;
                n = 0;
                if (renderableSpot != null && renderableSpot2 != null && !renderableSpot.equals((Object)renderableSpot2)) {
                    this.paintSelection(graphics, n != 0, renderableSpot, renderableSpot2);
                }
                if ((jScrollBar = this.hScrollBar) != null) {
                    object = graphics.create(insets.left, this.height - insets.bottom, this.width - insets.left - insets.right, 16);
                    try {
                        jScrollBar.paint((Graphics)object);
                    }
                    finally {
                        ((Graphics)object).dispose();
                    }
                }
                if ((object = this.vScrollBar) == null) break block24;
                Graphics graphics3 = graphics.create(this.width - insets.right, insets.top, 16, this.height - insets.top - insets.bottom);
                try {
                    ((JComponent)object).paint(graphics3);
                }
                finally {
                    graphics3.dispose();
                }
            }
            finally {
                super.paint(graphics);
            }
        }
        if (bl && (l = System.currentTimeMillis()) - l4 > 100L) {
            logger.info("paint(): Elapsed: " + (l - l4) + " ms. Prepaint: " + (l3 - l4) + " ms. Viewport: " + (l2 - l3) + " ms. RBlock: " + this + ".");
        }
    }

    public final void layout(int n, int n2, boolean bl, boolean bl2, int n3, int n4, boolean bl3) {
        this.layout(n, n2, bl, bl2, null, n3, n4, bl3);
    }

    public final void layout(int n, int n2, boolean bl, boolean bl2, FloatingBoundsSource floatingBoundsSource, boolean bl3) {
        this.layout(n, n2, bl, bl2, floatingBoundsSource, this.defaultOverflowX, this.defaultOverflowY, bl3);
    }

    public final void layout(int n, int n2, boolean bl, boolean bl2, FloatingBoundsSource floatingBoundsSource, int n3, int n4, boolean bl3) {
        try {
            this.doLayout(n, n2, bl, bl2, floatingBoundsSource, n3, n4, bl3);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    public final void doLayout(int n, int n2, boolean bl) {
        this.doLayout(n, n2, true, false, null, this.defaultOverflowX, this.defaultOverflowY, bl);
    }

    public void doLayout(int n, int n2, boolean bl, boolean bl2, FloatingBoundsSource floatingBoundsSource, int n3, int n4, boolean bl3) {
        RenderState renderState = this.modelNode.getRenderState();
        Font font = renderState == null ? null : renderState.getFont();
        int n5 = renderState == null ? 0 : renderState.getWhiteSpace();
        LayoutKey layoutKey = new LayoutKey(n, n2, bl, bl2, floatingBoundsSource, n3, n4, n5, font);
        Map map = this.cachedLayout;
        LayoutValue layoutValue = bl3 ? (LayoutValue)map.get(layoutKey) : (Objects.equals((Object)layoutKey, (Object)this.lastLayoutKey) ? this.lastLayoutValue : null);
        if (layoutValue == null) {
            layoutValue = this.forceLayout(renderState, n, n2, bl, bl2, floatingBoundsSource, n3, n4, bl3);
            if (bl3) {
                this.lastLayoutKey = null;
                this.lastLayoutValue = null;
                if (map.size() > 10) {
                    map.clear();
                }
                map.put(layoutKey, layoutValue);
            } else {
                this.lastLayoutKey = layoutKey;
                this.lastLayoutValue = layoutValue;
            }
        }
        this.width = layoutValue.width;
        this.height = layoutValue.height;
        this.hasHScrollBar = layoutValue.hasHScrollBar;
        this.hasVScrollBar = layoutValue.hasVScrollBar;
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    private final boolean correctViewportOrigin(Insets insets, int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        int n3 = rBlockViewport.x;
        int n4 = rBlockViewport.y;
        boolean bl = false;
        if (n3 > insets.left) {
            rBlockViewport.x = insets.left;
            bl = true;
        } else if (n3 < n - insets.right - rBlockViewport.width) {
            rBlockViewport.x = Math.min(insets.left, n - insets.right - rBlockViewport.width);
            bl = true;
        }
        if (n4 > insets.top) {
            rBlockViewport.y = insets.top;
            bl = true;
        } else if (n4 < n2 - insets.bottom - rBlockViewport.height) {
            rBlockViewport.y = Math.min(insets.top, n2 - insets.bottom - rBlockViewport.height);
            bl = true;
        }
        return bl;
    }

    private final LayoutValue forceLayout(RenderState renderState, int n, int n2, boolean bl, boolean bl2, FloatingBoundsSource floatingBoundsSource, int n3, int n4, boolean bl3) {
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl4;
        int n9;
        int n10;
        int n11;
        RenderThreadState renderThreadState;
        int n12;
        int n13;
        Insets insets;
        Insets insets2;
        RenderState renderState2 = renderState;
        if (renderState2 == null) {
            renderState2 = new BlockRenderState(null);
        }
        this.applyStyle(n, n2);
        RBlockViewport rBlockViewport = this.bodyLayout;
        NodeImpl nodeImpl = (NodeImpl)this.modelNode;
        if (nodeImpl == null || rBlockViewport == null) {
            Insets insets3 = this.getInsets(false, false);
            return new LayoutValue(insets3.left + insets3.right, insets3.bottom + insets3.top, false, false);
        }
        Insets insets4 = this.paddingInsets;
        if (insets4 == null) {
            insets4 = RBlockViewport.ZERO_INSETS;
        }
        if ((insets2 = this.borderInsets) == null) {
            insets2 = RBlockViewport.ZERO_INSETS;
        }
        if ((insets = this.marginInsets) == null) {
            insets = RBlockViewport.ZERO_INSETS;
        }
        int n14 = insets4.left + insets4.right;
        int n15 = insets4.top + insets4.bottom;
        int n16 = this.overflowX;
        if (n16 == 0) {
            n16 = n3;
        }
        if ((n13 = this.overflowY) == 0) {
            n13 = n4;
        }
        boolean bl5 = n13 == 2;
        boolean bl6 = n16 == 1;
        boolean bl7 = n16 == 2;
        boolean bl8 = n13 == 1;
        Insets insets5 = this.getInsets(bl6, bl8);
        int n17 = insets5.left + insets5.right;
        int n18 = insets5.top + insets5.bottom;
        int n19 = n - n14 - n17;
        int n20 = n - n15 - n18;
        Integer n21 = this.getDeclaredWidth(renderState, n19);
        Integer n22 = this.getDeclaredHeight(renderState, n20);
        int n23 = -1;
        int n24 = -1;
        if (n21 != null) {
            n23 = n21;
        }
        if (n22 != null) {
            n24 = n22;
        }
        this.clearGUIComponents();
        int n25 = n23 == -1 ? n : n23 + n17 + n14;
        int n26 = n12 = n24 == -1 ? n2 : n24 + n18 + n15;
        if (n23 == -1 && !bl && n > n17 + n14) {
            renderThreadState = RenderThreadState.getState();
            boolean bl9 = renderThreadState.overrideNoWrap;
            if (!bl9) {
                renderThreadState.overrideNoWrap = true;
                try {
                    n11 = n14;
                    n10 = n15;
                    rBlockViewport.layout(n11, n10, insets4, -1, null, true);
                    if (rBlockViewport.width + n17 < n25) {
                        n25 = rBlockViewport.width + n17;
                        n12 = rBlockViewport.height + n18;
                    }
                }
                finally {
                    renderThreadState.overrideNoWrap = false;
                }
            }
        }
        renderThreadState = null;
        FloatingBounds floatingBounds = null;
        if (floatingBoundsSource != null) {
            floatingBounds = floatingBoundsSource.getChildBlockFloatingBounds(n25);
            renderThreadState = new ShiftedFloatingBounds(floatingBounds, -insets5.left, -insets5.right, -insets5.top);
        }
        n11 = n25 - n17;
        n10 = n12 - insets5.top - insets5.bottom;
        int n27 = bl5 ? (n24 == -1 ? -1 : n24 + insets4.top) : -1;
        try {
            rBlockViewport.layout(n11, n10, insets4, n27, (FloatingBounds)renderThreadState, bl3);
        }
        catch (SizeExceededException sizeExceededException) {
            bl8 = true;
            insets5 = this.getInsets(bl6, bl8);
            n17 = insets5.left + insets5.right;
            n19 = n - n14 - n17;
            n21 = this.getDeclaredWidth(renderState, n19);
            n23 = n21 == null ? -1 : n21;
            n11 = n25 - n17;
            if (floatingBounds != null) {
                renderThreadState = new ShiftedFloatingBounds(floatingBounds, -insets5.left, -insets5.right, -insets5.top);
            }
            rBlockViewport.layout(n11, n10, insets4, -1, (FloatingBounds)renderThreadState, bl3);
        }
        int n28 = rBlockViewport.width;
        int n29 = rBlockViewport.height;
        int n30 = n28 + n17;
        int n31 = n29 + n18;
        int n32 = n23 == -1 ? -1 : n23 + insets5.left + insets5.right + insets4.left + insets4.right;
        int n33 = n9 = n24 == -1 ? -1 : n24 + insets5.top + insets5.bottom + insets4.top + insets4.bottom;
        if (bl7 && (n32 != -1 && n30 > n32 || n30 > n25)) {
            bl6 = true;
            insets5 = this.getInsets(bl6, bl8);
            n18 = insets5.top + insets5.bottom;
            n31 = n29 + n18;
        }
        boolean bl10 = n16 == 4 || n16 == 0;
        boolean bl11 = bl4 = n13 == 4 || n13 == 0;
        if (n32 == -1) {
            int n34 = n8 = bl ? Math.max(n30, n25) : n30;
            if (bl6 && n8 > n25) {
                n8 = Math.max(n25, 16);
            }
        } else {
            int n35 = n8 = bl10 ? Math.max(n30, n32) : n32;
        }
        if (!bl3 && (n7 = renderState2.getAlignXPercent()) > 0) {
            n6 = Math.max(rBlockViewport.width, n8 - insets5.left - insets5.right);
            rBlockViewport.alignX(n7, n6, insets4);
        }
        if (n9 == -1) {
            int n36 = n5 = bl2 ? Math.max(n31, n12) : n31;
            if (bl8 && n5 > n12) {
                n5 = Math.max(n12, 16);
            }
        } else {
            int n37 = n5 = bl4 ? Math.max(n31, n9) : n9;
        }
        if (!bl3 && (n7 = renderState2.getAlignYPercent()) > 0) {
            n6 = Math.max(rBlockViewport.height, n5 - insets5.top - insets5.bottom);
            rBlockViewport.alignY(n7, n6, insets4);
        }
        if (bl8) {
            JScrollBar jScrollBar = this.getVScrollBar();
            this.addComponent(jScrollBar);
        }
        if (bl6) {
            JScrollBar jScrollBar = this.getHScrollBar();
            this.addComponent(jScrollBar);
        }
        if (bl6 || bl8) {
            this.correctViewportOrigin(insets5, n8, n5);
            this.width = n8;
            this.height = n5;
            this.resetScrollBars(renderState2);
        } else {
            rBlockViewport.x = insets5.left;
            rBlockViewport.y = insets5.top;
        }
        return new LayoutValue(n8, n5, bl6, bl8);
    }

    private int getVUnitIncrement(RenderState renderState) {
        if (renderState != null) {
            return renderState.getFontMetrics().getHeight();
        }
        return new BlockRenderState(null).getFontMetrics().getHeight();
    }

    private void resetScrollBars(RenderState renderState) {
        this.resettingScrollBars = true;
        try {
            RBlockViewport rBlockViewport = this.bodyLayout;
            if (rBlockViewport != null) {
                JScrollBar jScrollBar;
                int n;
                int n2;
                int n3;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                JScrollBar jScrollBar2 = this.vScrollBar;
                if (jScrollBar2 != null) {
                    int n4 = insets.top - rBlockViewport.y;
                    n3 = this.height - insets.top - insets.bottom;
                    n2 = 0;
                    n = rBlockViewport.height;
                    jScrollBar2.setValues(n4, n3, n2, n);
                    jScrollBar2.setUnitIncrement(this.getVUnitIncrement(renderState));
                    jScrollBar2.setBlockIncrement(n3);
                }
                if ((jScrollBar = this.hScrollBar) != null) {
                    n3 = insets.left - rBlockViewport.x;
                    n2 = this.width - insets.left - insets.right;
                    n = 0;
                    int n5 = rBlockViewport.width;
                    jScrollBar.setValues(n3, n2, n, n5);
                }
            }
        }
        finally {
            this.resettingScrollBars = false;
        }
    }

    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        Graphics graphics2 = graphics.create();
        try {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            graphics2.clipRect(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
            boolean bl2 = super.paintSelection(graphics2, bl, renderableSpot, renderableSpot2);
            return bl2;
        }
        finally {
            graphics2.dispose();
        }
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            if (n > insets.left && n < this.width - insets.right && n2 > insets.top && n2 < this.height - insets.bottom) {
                return rBlockViewport.getLowestRenderableSpot(n - rBlockViewport.x, n2 - rBlockViewport.y);
            }
            return new RenderableSpot((BoundableRenderable)this, n, n2);
        }
        return new RenderableSpot((BoundableRenderable)this, n, n2);
    }

    public void invalidateLayoutLocal() {
        JScrollBar jScrollBar;
        super.invalidateLayoutLocal();
        this.cachedLayout.clear();
        this.lastLayoutKey = null;
        this.lastLayoutValue = null;
        JScrollBar jScrollBar2 = this.hScrollBar;
        if (jScrollBar2 != null) {
            jScrollBar2.invalidate();
        }
        if ((jScrollBar = this.vScrollBar) != null) {
            jScrollBar.invalidate();
        }
    }

    protected void clearStyle(boolean bl) {
        super.clearStyle(bl);
        this.overflowX = this.defaultOverflowX;
        this.overflowY = this.defaultOverflowY;
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null && !rBlockViewport.onMouseClick(mouseEvent, n - rBlockViewport.x, n2 - rBlockViewport.y)) {
            return false;
        }
        if (!HtmlController.getInstance().onMouseClick(this.modelNode, mouseEvent, n, n2)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null && !rBlockViewport.onDoubleClick(mouseEvent, n - rBlockViewport.x, n2 - rBlockViewport.y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        BoundableRenderable boundableRenderable = this.armedRenderable;
        if (boundableRenderable != null) {
            try {
                boolean bl = boundableRenderable.onMouseDisarmed(mouseEvent);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            int n3 = n - rBlockViewport.x;
            int n4 = n2 - rBlockViewport.y;
            if (rBlockViewport.contains(n3, n4)) {
                this.armedRenderable = rBlockViewport;
                if (!rBlockViewport.onMousePressed(mouseEvent, n3, n4)) {
                    return false;
                }
            } else {
                this.armedRenderable = null;
            }
        } else {
            this.armedRenderable = null;
        }
        if (!HtmlController.getInstance().onMouseDown(this.modelNode, mouseEvent, n, n2)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            int n3 = n - rBlockViewport.x;
            int n4 = n2 - rBlockViewport.y;
            if (rBlockViewport.contains(n3, n4)) {
                this.armedRenderable = null;
                if (!rBlockViewport.onMouseReleased(mouseEvent, n3, n4)) {
                    return false;
                }
            } else {
                BoundableRenderable boundableRenderable = this.armedRenderable;
                if (boundableRenderable != null) {
                    boundableRenderable.onMouseDisarmed(mouseEvent);
                }
            }
        }
        if (!HtmlController.getInstance().onMouseUp(this.modelNode, mouseEvent, n, n2)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public Color getPaintedBackgroundColor() {
        return this.backgroundColor;
    }

    public Iterator getRenderables() {
        RBlockViewport rBlockViewport = this.bodyLayout;
        return new Iterator(rBlockViewport){
            private RBlockViewport bl;
            {
                this.bl = rBlockViewport;
            }

            @Override
            public boolean hasNext() {
                return this.bl != null;
            }

            public Object next() {
                if (this.bl == null) {
                    throw new NoSuchElementException();
                }
                try {
                    RBlockViewport rBlockViewport = this.bl;
                    return rBlockViewport;
                }
                finally {
                    this.bl = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public void updateWidgetBounds(int n, int n2) {
        super.updateWidgetBounds(n, n2);
        boolean bl = this.hasHScrollBar;
        boolean bl2 = this.hasVScrollBar;
        if (bl || bl2) {
            JScrollBar jScrollBar;
            Insets insets = this.getInsets(bl, bl2);
            if (bl && (jScrollBar = this.hScrollBar) != null) {
                jScrollBar.setBounds(n + insets.left, n2 + this.height - insets.bottom, this.width - insets.left - insets.right, 16);
            }
            if (bl2 && (jScrollBar = this.vScrollBar) != null) {
                jScrollBar.setBounds(n + this.width - insets.right, n2 + insets.top, 16, this.height - insets.top - insets.bottom);
            }
        }
    }

    public void scrollHorizontalTo(int n) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int n2 = n;
            rBlockViewport.x = n2 > insets.left ? insets.left : (n2 < this.width - insets.right - rBlockViewport.width ? Math.min(insets.left, this.width - insets.right - rBlockViewport.width) : n2);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollVerticalTo(int n) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int n2 = n;
            rBlockViewport.y = n2 > insets.top ? insets.top : (n2 < this.height - insets.bottom - rBlockViewport.height ? Math.min(insets.top, this.height - insets.bottom - rBlockViewport.height) : n2);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollByUnits(int n, int n2) {
        int n3 = n == 1 ? this.getVUnitIncrement(null) * n2 : n2;
        this.scrollBy(n, n3);
    }

    public void scrollBy(int n, int n2) {
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            switch (n) {
                case 0: {
                    this.scrollHorizontalTo(rBlockViewport.x - n2);
                    break;
                }
                case 1: {
                    this.scrollVerticalTo(rBlockViewport.y - n2);
                }
            }
        }
    }

    public void scrollTo(Rectangle rectangle, boolean bl, boolean bl2) {
        boolean bl3 = this.hasHScrollBar;
        boolean bl4 = this.hasVScrollBar;
        if (bl3 || bl4) {
            RBlockViewport rBlockViewport = this.bodyLayout;
            Insets insets = this.getInsets(bl3, bl4);
            int n = this.height - insets.top - insets.bottom;
            int n2 = this.width - insets.left - insets.right;
            int n3 = insets.left - rectangle.x;
            int n4 = insets.top - rectangle.y;
            boolean bl5 = false;
            if (!bl || n3 > rBlockViewport.x || -n3 + rBlockViewport.x + rectangle.width > n2) {
                rBlockViewport.setX(n3);
                bl5 = true;
            }
            if (!bl2 || n4 > rBlockViewport.y || -n4 + rBlockViewport.y + rectangle.height > n) {
                rBlockViewport.setY(n4);
                bl5 = true;
            }
            if (bl5) {
                this.correctViewportOrigin(insets, this.width, this.height);
                this.resetScrollBars(null);
                this.updateWidgetBounds();
                this.repaint();
            }
        }
    }

    private void scrollToSBValue(int n, int n2) {
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        switch (n) {
            case 0: {
                int n3 = insets.left - n2;
                this.scrollHorizontalTo(n3);
                break;
            }
            case 1: {
                int n4 = insets.top - n2;
                this.scrollVerticalTo(n4);
            }
        }
    }

    public RBlockViewport getRBlockViewport() {
        return this.bodyLayout;
    }

    public boolean extractSelectionText(StringBuffer stringBuffer, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        boolean bl2 = super.extractSelectionText(stringBuffer, bl, renderableSpot, renderableSpot2);
        String string = System.getProperty("line.separator");
        if (bl) {
            stringBuffer.insert(0, string);
        }
        if (bl2) {
            stringBuffer.append(string);
        }
        return bl2;
    }

    public String toString() {
        return "RBlock[node=" + this.modelNode + "]";
    }

    public FloatingInfo getExportableFloatingInfo() {
        FloatingInfo floatingInfo = this.bodyLayout.getExportableFloatingInfo();
        if (floatingInfo == null) {
            return null;
        }
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        return new FloatingInfo(floatingInfo.shiftX + insets.left, floatingInfo.shiftY + insets.top, floatingInfo.floats);
    }

    public int getDefaultOverflowX() {
        return this.defaultOverflowX;
    }

    public int getDefaultOverflowY() {
        return this.defaultOverflowY;
    }

    public void setDefaultOverflowX(int n) {
        this.defaultOverflowX = n;
    }

    public void setDefaultOverflowY(int n) {
        this.defaultOverflowY = n;
    }

    private static class BodyFilter
    implements NodeFilter {
        private BodyFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLBodyElement;
        }
    }

    private static class LayoutKey {
        public final int availWidth;
        public final int availHeight;
        public final FloatingBoundsSource floatBoundsSource;
        public final int defaultOverflowX;
        public final int defaultOverflowY;
        public final int whitespace;
        public final Font font;
        public final boolean expandWidth;
        public final boolean expandHeight;
        public final boolean useDeclaredSize;

        public LayoutKey(int n, int n2, boolean bl, boolean bl2, FloatingBoundsSource floatingBoundsSource, int n3, int n4, int n5, Font font) {
            this.availWidth = n;
            this.availHeight = n2;
            this.floatBoundsSource = floatingBoundsSource;
            this.defaultOverflowX = n3;
            this.defaultOverflowY = n4;
            this.whitespace = n5;
            this.font = font;
            this.expandWidth = bl;
            this.expandHeight = bl2;
            this.useDeclaredSize = true;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LayoutKey)) {
                return false;
            }
            LayoutKey layoutKey = (LayoutKey)object;
            return layoutKey.availWidth == this.availWidth && layoutKey.availHeight == this.availHeight && layoutKey.defaultOverflowX == this.defaultOverflowX && layoutKey.defaultOverflowY == this.defaultOverflowY && layoutKey.whitespace == this.whitespace && layoutKey.expandWidth == this.expandWidth && layoutKey.expandHeight == this.expandHeight && layoutKey.useDeclaredSize == this.useDeclaredSize && Objects.equals((Object)layoutKey.font, (Object)this.font) && Objects.equals((Object)layoutKey.floatBoundsSource, (Object)this.floatBoundsSource);
        }

        public int hashCode() {
            Font font = this.font;
            return this.availWidth * 1000 + this.availHeight ^ (font == null ? 0 : font.hashCode()) ^ (this.expandWidth ? 2 : 0) ^ (this.expandHeight ? 1 : 0);
        }
    }

    private static class LayoutValue {
        public final int width;
        public final int height;
        public final boolean hasHScrollBar;
        public final boolean hasVScrollBar;

        public LayoutValue(int n, int n2, boolean bl, boolean bl2) {
            this.width = n;
            this.height = n2;
            this.hasHScrollBar = bl;
            this.hasVScrollBar = bl2;
        }
    }

    private class LocalAdjustmentListener
    implements AdjustmentListener {
        private final int orientation;

        public LocalAdjustmentListener(int n) {
            this.orientation = n;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (RBlock.this.resettingScrollBars) {
                return;
            }
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n = adjustmentEvent.getValue();
                    RBlock.this.scrollToSBValue(this.orientation, n);
                }
            }
        }
    }
}

