/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.remote;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.print.remote.DicomPrinterWrapper;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class DicomPrinterFactory {
    private static DicomPrinterFactory instance = new DicomPrinterFactory();
    private static ALogger log = ALogger.getLogger(DicomPrinterFactory.class);

    public static DicomPrinterFactory getInstance() {
        return instance;
    }

    public List<DicomPrinterWrapper> getDicomPrinters() {
        ArrayList<DicomPrinterWrapper> arrayList = new ArrayList<DicomPrinterWrapper>();
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        IConfigurationList iConfigurationList = iConfigurationProvider.getList("listtext.print.dicom_printers");
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
            String string = "";
            try {
                string = iConfigurationProvider2.getString("name");
                String string2 = iConfigurationProvider2.getString("host");
                int n = (int)iConfigurationProvider2.getLong("port");
                String string3 = iConfigurationProvider2.getString("calledAET");
                String string4 = null;
                if (iConfigurationProvider2.exists("callingAET")) {
                    string4 = iConfigurationProvider2.getText("callingAET");
                }
                String string5 = null;
                if (iConfigurationProvider2.exists("xml")) {
                    string5 = iConfigurationProvider2.getText("xml");
                }
                arrayList.add(new DicomPrinterWrapper(string, string2, n, string3, string4, string5));
            }
            catch (Exception exception) {
                log.error("Could not load printer definition of printer:" + string);
            }
        }
        return arrayList;
    }
}

