/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.raster;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.raster.RasterFormat;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RasterPanel
extends JPanel {
    private RasterFormat model;
    private JSpinner rows = null;
    private JSpinner columns = null;
    private JLabel rowsLabel = null;
    private JLabel columnsLabel = null;
    private JCheckBox chkRealSize = null;
    private JCheckBox chkRealEnlarged = null;

    public RasterPanel(RasterFormat rasterFormat) {
        this.model = rasterFormat;
        this.createComponents();
        this.installListeners();
        this.installLayout();
    }

    private void createComponents() {
        this.rowsLabel = new JLabel(String.valueOf(Messages.getString("RasterPanel.RowsPerPage")) + ":");
        this.columnsLabel = new JLabel(String.valueOf(Messages.getString("RasterPanel.ColumnsPerPage")) + ":");
        this.columns = new JSpinner(new SpinnerNumberModel(this.model.getColumnCount(), 1, 12, 1));
        this.rows = new JSpinner(new SpinnerNumberModel(this.model.getRowCount(), 1, 12, 1));
        this.chkRealSize = new JCheckBox(new RealSizeAction());
        this.chkRealSize.setSelected(this.model.isRealSize());
        this.chkRealEnlarged = new JCheckBox(new RealEnlargedAction());
        this.chkRealEnlarged.setSelected(this.model.isRealSizeEnlarged());
        this.chkRealEnlarged.setEnabled(this.chkRealSize.isSelected());
        if (Product.isCDViewer() || Product.isReducedVersion()) {
            this.chkRealEnlarged.setSelected(false);
            this.chkRealEnlarged.setEnabled(false);
            this.chkRealSize.setSelected(false);
            this.chkRealSize.setEnabled(false);
            this.model.setRealSize(false);
            this.model.setRealSizeEnlarged(false);
        }
    }

    private void installListeners() {
        MyChangeListener myChangeListener = new MyChangeListener();
        this.columns.addChangeListener(myChangeListener);
        this.rows.addChangeListener(myChangeListener);
    }

    private void installLayout() {
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -1.0}, new double[]{-2.0, -2.0});
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        super.setLayout((LayoutManager)tableLayout);
        super.add((Component)this.rowsLabel, "0,0");
        super.add((Component)this.rows, "1,0");
        super.add((Component)this.columnsLabel, "3,0");
        super.add((Component)this.columns, "4,0");
        super.add((Component)this.chkRealSize, "1,1, 2,1");
        super.add((Component)this.chkRealEnlarged, "3,1, 5,1");
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == RasterPanel.this.columns) {
                RasterPanel.this.model.setColumnCount((Integer)RasterPanel.this.columns.getModel().getValue());
            } else if (changeEvent.getSource() == RasterPanel.this.rows) {
                RasterPanel.this.model.setRowCount((Integer)RasterPanel.this.rows.getModel().getValue());
            }
        }
    }

    private class RealEnlargedAction
    extends AbstractAction {
        public RealEnlargedAction() {
            super(Messages.getString("RasterPanel.EnlargeTo1_11"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RasterPanel.this.model.setRealSizeEnlarged(RasterPanel.this.chkRealEnlarged.isSelected());
        }
    }

    private class RealSizeAction
    extends AbstractAction {
        public RealSizeAction() {
            super("1:1");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RasterPanel.this.model.setRealSize(RasterPanel.this.chkRealSize.isSelected());
            RasterPanel.this.chkRealEnlarged.setEnabled(RasterPanel.this.chkRealSize.isSelected());
        }
    }
}

