/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.raster;

import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.module.print.ImageFormat;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.type.print.ConfigurationInformation;
import com.agfa.pacs.listtext.dicomobject.type.print.DecimateCropBehavior;
import com.agfa.pacs.listtext.dicomobject.type.print.MagnificationType;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.ImageDisplayFormat;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.StandardImageDisplayFormat;
import com.agfa.pacs.listtext.lta.print.IDicomConfigProvider;
import com.agfa.pacs.listtext.lta.print.IFormat;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.IPrintConfigurationListener;
import com.agfa.pacs.listtext.lta.print.IPrintSetting;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.PrintManager;
import com.agfa.pacs.listtext.lta.print.raster.RasterPage;
import com.agfa.pacs.listtext.lta.print.raster.RasterPanel;
import com.agfa.pacs.listtext.lta.print.remote.AnnotationUtils;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmBoxConfiguration;
import com.agfa.pacs.listtext.print.dicompm.DicomImageBoxConfiguration;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.mapper.MapperImageBox;
import com.agfa.pacs.listtext.print.renderer.layout.IFilmBoxLayout;
import com.agfa.pacs.listtext.print.renderer.layout.RasterFilmBoxLayout;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class RasterFormat
implements IFormat {
    private static final ALogger log = ALogger.getLogger(RasterFormat.class);
    private RasterPanel panel;
    private int rows = 1;
    private int columns = 1;
    private IPrintConfigurationListener listener = null;
    private ArrayList<IImageBoxInfo> boxes = new ArrayList();
    private boolean realSize = false;
    private Double zoomRatio = null;

    @Override
    public void initFromConfig(IConfigurationProvider iConfigurationProvider) {
        iConfigurationProvider = iConfigurationProvider.getNode("raster");
        this.rows = (int)iConfigurationProvider.getLong("rows");
        this.columns = (int)iConfigurationProvider.getLong("columns");
        this.boxes = new ArrayList();
        this.realSize = iConfigurationProvider.getBoolean("real_size");
        if (iConfigurationProvider.exists("zoom_ratio")) {
            this.zoomRatio = iConfigurationProvider.getDouble("zoom_ratio");
        }
    }

    @Override
    public void saveToConfig(IConfigurationProvider iConfigurationProvider) {
        iConfigurationProvider = iConfigurationProvider.getNode("raster");
        iConfigurationProvider.setLong("rows", (long)this.rows);
        iConfigurationProvider.setLong("columns", (long)this.columns);
        iConfigurationProvider.setBoolean("real_size", this.realSize);
        if (this.zoomRatio != null) {
            iConfigurationProvider.setDouble("zoom_ratio", this.zoomRatio.doubleValue());
        } else if (iConfigurationProvider.exists("zoom_ratio")) {
            iConfigurationProvider.removeValue("zoom_ratio");
        }
    }

    @Override
    public void reset() {
        this.boxes = new ArrayList();
    }

    private void deleteTrailingNulls() {
        if (this.boxes != null && this.boxes.size() >= 1) {
            int n = this.boxes.size() - 1;
            while (n >= 0) {
                if (this.boxes.get(n) != null) break;
                this.boxes.remove(n);
                --n;
            }
        }
    }

    private RasterPage getPage(int n) {
        int n2 = this.rows * this.columns;
        int n3 = this.rows * this.columns * n;
        int n4 = n2;
        if (n < 0 || n >= this.getPageCount()) {
            return null;
        }
        if ((n + 1) * n2 > this.boxes.size()) {
            n4 = n2 - this.boxes.size() % n2;
            int n5 = 0;
            while (n5 < n4) {
                this.boxes.add(null);
                ++n5;
            }
        }
        ArrayList<IImageBoxInfo> arrayList = new ArrayList<IImageBoxInfo>(this.boxes.subList(n3, n3 + n2));
        return new RasterPage(this.columns, this.rows, arrayList);
    }

    @Override
    public IImageBoxInfo isDataOn(int n, float f, float f2) {
        RasterPage rasterPage = this.getPage(n);
        return rasterPage.getObjAt(f, f2);
    }

    @Override
    public void removeData(IImageBoxInfo iImageBoxInfo) {
        this.boxes.remove(iImageBoxInfo);
        this.deleteTrailingNulls();
    }

    private String getUID(IObjectInfo iObjectInfo, PrintManager.SPLIT_TYPE sPLIT_TYPE) {
        switch (sPLIT_TYPE) {
            case NO_SPLIT: {
                return null;
            }
            case SPLIT_ON_PATIENT: {
                return iObjectInfo.getTreeParent().getTreeParent().getTreeParent().getKey();
            }
            case SPLIT_ON_STUDY: {
                return iObjectInfo.getTreeParent().getTreeParent().getKey();
            }
            case SPLIT_ON_SERIE: {
                return iObjectInfo.getTreeParent().getKey();
            }
        }
        return null;
    }

    @Override
    public void addData(List<IImageBoxInfo> list, PrintManager.SPLIT_TYPE sPLIT_TYPE) {
        String string = null;
        String string2 = null;
        this.deleteTrailingNulls();
        if (this.boxes.size() > 0) {
            IImageBoxInfo iImageBoxInfo = this.boxes.get(this.boxes.size() - 1);
            string = this.getUID(iImageBoxInfo.getObjectInfo(), sPLIT_TYPE);
        }
        for (IImageBoxInfo iImageBoxInfo : list) {
            string2 = this.getUID(iImageBoxInfo.getObjectInfo(), sPLIT_TYPE);
            if (string != null && string2 != null && !string.equals(string2)) {
                this.createNewPage();
            } else {
                this.deleteTrailingNulls();
            }
            string = string2;
            this.boxes.add(iImageBoxInfo);
        }
    }

    @Override
    public void insertData(int n, float f, float f2, List<IImageBoxInfo> list) {
        if (this.getPageCount() <= n) {
            return;
        }
        int n2 = (int)Math.floor(f * (float)this.columns);
        int n3 = (int)Math.floor(f2 * (float)this.rows);
        int n4 = this.rows * this.columns * n + n2 + n3 * this.columns;
        int n5 = 0;
        while (n5 < list.size()) {
            int n6 = this.boxes.size() - 1;
            if (n4 + n5 > n6) {
                this.boxes.add(list.get(n5));
            } else {
                if (this.boxes.get(n4 + n5) == null) {
                    this.boxes.remove(n4 + n5);
                }
                this.boxes.add(n4 + n5, list.get(n5));
            }
            ++n5;
        }
        this.deleteTrailingNulls();
        log.info(String.valueOf(list.size()) + " elements added at position " + n4);
    }

    @Override
    public void moveData(int n, float f, float f2, IDataInfo iDataInfo) {
        if (this.getPageCount() <= n) {
            return;
        }
        int n2 = (int)Math.floor(f * (float)this.columns);
        int n3 = (int)Math.floor(f2 * (float)this.rows);
        int n4 = this.rows * this.columns * n + n2 + n3 * this.columns;
        int n5 = this.rows * this.columns * n;
        int n6 = -1;
        int n7 = 0;
        while (n7 < this.columns * this.rows) {
            if (this.boxes.get(n5 + n7) != null && this.boxes.get(n5 + n7).getObjectInfo().getKey().equals(iDataInfo.getKey())) {
                n6 = n5 + n7;
                break;
            }
            ++n7;
        }
        if (n6 != -1) {
            IImageBoxInfo iImageBoxInfo = this.boxes.get(n6);
            if (this.boxes.get(n4) != null) {
                this.boxes.add(n6, this.boxes.get(n4));
                this.boxes.remove(n6 + 1);
            } else {
                this.boxes.add(n6, null);
                this.boxes.remove(n6 + 1);
            }
            this.boxes.add(n4, iImageBoxInfo);
            this.boxes.remove(n4 + 1);
        }
    }

    @Override
    public IImageBoxInfo addData(int n, float f, float f2, IImageBoxInfo iImageBoxInfo) {
        if (this.getPageCount() <= n) {
            return null;
        }
        RasterPage rasterPage = this.getPage(n);
        int n2 = (int)Math.floor(f * (float)this.columns);
        int n3 = (int)Math.floor(f2 * (float)this.rows);
        IImageBoxInfo iImageBoxInfo2 = rasterPage.getObj(n2, n3);
        rasterPage.setObj(n2, n3, iImageBoxInfo);
        return iImageBoxInfo2;
    }

    @Override
    public void deletePage(int n) {
        if (n < this.getPageCount()) {
            int n2 = n * this.columns * this.rows;
            int n3 = this.rows * this.columns;
            int n4 = 0;
            while (n4 < n3) {
                this.boxes.remove(n2);
                ++n4;
            }
        }
    }

    @Override
    public IFilmBoxLayout getLayout(boolean bl) {
        return new RasterFilmBoxLayout(this.columns, this.rows);
    }

    private List<RasterPage> getAllPages() {
        int n = this.getPageCount();
        ArrayList<RasterPage> arrayList = new ArrayList<RasterPage>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.getPage(n2));
            ++n2;
        }
        return arrayList;
    }

    @Override
    public MapperFilmSession getMapperFilmSession(IDisplayFormat iDisplayFormat, IDicomConfigProvider iDicomConfigProvider, IPrintSetting iPrintSetting, Integer n) {
        MapperFilmSession mapperFilmSession = new MapperFilmSession();
        mapperFilmSession.setZoomRatio(this.zoomRatio);
        if (n == null) {
            List<RasterPage> list = this.getAllPages();
            for (RasterPage rasterPage : list) {
                this.addMapper(mapperFilmSession, iDicomConfigProvider, iDisplayFormat, iPrintSetting, rasterPage);
            }
        } else if (n < this.getPageCount()) {
            this.addMapper(mapperFilmSession, iDicomConfigProvider, iDisplayFormat, iPrintSetting, this.getPage(n));
        }
        return mapperFilmSession;
    }

    private void addMapper(MapperFilmSession mapperFilmSession, IDicomConfigProvider iDicomConfigProvider, IDisplayFormat iDisplayFormat, IPrintSetting iPrintSetting, RasterPage rasterPage) {
        Object object;
        MagnificationType magnificationType = null;
        String string = null;
        MapperFilmBox mapperFilmBox = new MapperFilmBox(iDisplayFormat, this.realSize ? PresentationSizeMode.TrueSize : PresentationSizeMode.ScaleToFit);
        if (rasterPage == null) {
            return;
        }
        boolean bl = false;
        Map map = null;
        ConfigurationInformation configurationInformation = null;
        if (iDicomConfigProvider != null) {
            map = iDicomConfigProvider.getConfig().getAnnotationBoxes();
            DicomFilmBoxConfiguration dicomFilmBoxConfiguration = new DicomFilmBoxConfiguration();
            mapperFilmBox.mapperConfigurations().add(dicomFilmBoxConfiguration);
            dicomFilmBoxConfiguration.setBorderDensity(iDicomConfigProvider.getBorderDensity());
            dicomFilmBoxConfiguration.setEmptyImageDensity(iDicomConfigProvider.getEmptyDensity());
            if (iDicomConfigProvider.getSelectedMedium().getMaxDensity() != null) {
                dicomFilmBoxConfiguration.setMaxDensity(iDicomConfigProvider.getSelectedMedium().getMaxDensity());
            }
            if (iDicomConfigProvider.getSelectedMedium().getMinDensity() != null) {
                dicomFilmBoxConfiguration.setMaxDensity(iDicomConfigProvider.getSelectedMedium().getMinDensity());
            }
            if (iDicomConfigProvider.getConfig().getDefaultSmoothingType().length() > 0) {
                string = iDicomConfigProvider.getConfig().getDefaultSmoothingType();
            }
            if (string != null) {
                dicomFilmBoxConfiguration.setSmoothingType(string);
            }
            dicomFilmBoxConfiguration.setTrim(iDicomConfigProvider.getTrim());
            magnificationType = iDicomConfigProvider.getConfig().getDefaultMagnificationType();
            dicomFilmBoxConfiguration.setMagnificationType(magnificationType);
            if (iDicomConfigProvider.isAgfaPrinter() && iPrintSetting.useDemographics()) {
                if (iDicomConfigProvider.getConfig().getConfigurationInformation() != null && iDicomConfigProvider.getConfig().getConfigurationInformation().length() > 0) {
                    bl = true;
                    dicomFilmBoxConfiguration.setAnnotationDisplayFormatID(null);
                    configurationInformation = ConfigurationInformation.create((String)iDicomConfigProvider.getConfig().getConfigurationInformation());
                    dicomFilmBoxConfiguration.setConfigurationInformation(configurationInformation);
                }
            } else if (iPrintSetting.useDemographics()) {
                String[] stringArray = iDicomConfigProvider.getConfig().getSopClassesSupported();
                boolean bl2 = false;
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = stringArray2[n2];
                    if (((String)object).equals("1.2.840.10008.5.1.1.15")) {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (bl2 && map != null) {
                    dicomFilmBoxConfiguration.setAnnotationDisplayFormatID(iDicomConfigProvider.getConfig().getAnnotationID());
                    bl = true;
                }
            }
        }
        mapperFilmSession.filmBoxes().add(mapperFilmBox);
        int n = 0;
        while (n < this.columns) {
            int n3 = 0;
            while (n3 < this.rows) {
                MapperImageBox mapperImageBox = (MapperImageBox)mapperFilmBox.imageBoxes().get(n3 * this.columns + n);
                mapperImageBox.setEvaluator(AnnotationUtils.getEvaluator());
                object = rasterPage.getObj(n, n3);
                if (object != null) {
                    mapperImageBox.setContent(object.getObjectInfo(), object.getFrameNumber());
                    mapperImageBox.setFramePresentationStateSource(object.getFramePresentationStateSource());
                }
                DicomImageBoxConfiguration dicomImageBoxConfiguration = new DicomImageBoxConfiguration();
                if (iDicomConfigProvider != null) {
                    dicomImageBoxConfiguration.setMagnificationType(magnificationType);
                    if (string != null) {
                        dicomImageBoxConfiguration.setSmoothingType(string);
                    }
                    dicomImageBoxConfiguration.setMaxDensity(iDicomConfigProvider.getSelectedMedium().getMaxDensity());
                    dicomImageBoxConfiguration.setMinDensity(iDicomConfigProvider.getSelectedMedium().getMinDensity());
                    dicomImageBoxConfiguration.setConfigurationInformation(configurationInformation);
                    if (this.realSize) {
                        dicomImageBoxConfiguration.setRequestedDecimateCropBehavior(DecimateCropBehavior.Crop);
                    }
                }
                mapperImageBox.mapperConfigurations().add(dicomImageBoxConfiguration);
                mapperImageBox.setIncludeMappings(iPrintSetting.useDemographics() && !bl);
                if (iPrintSetting.useDemographics() && map != null) {
                    mapperImageBox.setAnnotations(map);
                }
                if (this.columns == 1 && this.rows == 1) {
                    mapperImageBox.setMappingsOutside(true);
                } else {
                    mapperImageBox.setMappingsOutside(false);
                }
                ++n3;
            }
            ++n;
        }
    }

    private boolean isOk(ImageFormat imageFormat, boolean bl) {
        if (!(imageFormat.getImageDisplayFormat() instanceof StandardImageDisplayFormat)) {
            return false;
        }
        StandardImageDisplayFormat standardImageDisplayFormat = (StandardImageDisplayFormat)imageFormat.getImageDisplayFormat();
        if (bl) {
            return standardImageDisplayFormat.getNumberOfColumns() >= this.columns && standardImageDisplayFormat.getNumberOfRows() >= this.rows;
        }
        return standardImageDisplayFormat.getNumberOfColumns() == this.columns && standardImageDisplayFormat.getNumberOfRows() == this.rows;
    }

    @Override
    public ImageFormat chooseFormat(List<ImageFormat> list, boolean bl) {
        ImageFormat imageFormat3;
        ImageFormat imageFormat2 = null;
        if (list.size() == 1) {
            imageFormat2 = list.get(0);
        }
        if (imageFormat2 == null) {
            for (ImageFormat imageFormat3 : list) {
                if (!this.isOk(imageFormat3, false)) continue;
                imageFormat2 = imageFormat3;
            }
        }
        if (imageFormat2 == null) {
            for (ImageFormat imageFormat3 : list) {
                if (!this.isOk(imageFormat3, true)) continue;
                imageFormat2 = imageFormat3;
            }
        }
        if (!bl && imageFormat2 == null) {
            return null;
        }
        if (!this.isOk(imageFormat2, true) && !bl) {
            return null;
        }
        if (imageFormat2 == null) {
            imageFormat2 = list.get(0);
        }
        imageFormat3 = new StandardImageDisplayFormat(this.columns, this.rows);
        imageFormat2.setImageDisplayFormat((ImageDisplayFormat)imageFormat3);
        return imageFormat2;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getName() {
        return "RasterLayout";
    }

    @Override
    public JComponent getUI() {
        if (this.panel == null) {
            this.panel = new RasterPanel(this);
        }
        return this.panel;
    }

    public void setRowCount(int n) {
        if (n == this.rows) {
            return;
        }
        this.rows = n;
        this.deleteTrailingNulls();
        this.listener.redraw();
    }

    public void setColumnCount(int n) {
        if (n == this.columns) {
            return;
        }
        this.columns = n;
        this.deleteTrailingNulls();
        this.listener.redraw();
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public String getCompleteSetting() {
        String string = "";
        if (this.realSize) {
            string = this.zoomRatio != null ? "1:" + this.zoomRatio.toString() : "1:1";
        }
        return String.valueOf(Messages.getString("RasterFormat.Raster")) + " - " + this.rows + "x" + this.columns + "  " + string;
    }

    public boolean isRealSize() {
        return this.realSize;
    }

    public void setRealSize(boolean bl) {
        this.realSize = bl;
        if (!bl) {
            this.zoomRatio = null;
        }
        this.listener.redraw();
    }

    public boolean isRealSizeEnlarged() {
        return this.zoomRatio != null;
    }

    public void setRealSizeEnlarged(boolean bl) {
        this.zoomRatio = bl ? Double.valueOf(1.1) : null;
        this.listener.redraw();
    }

    @Override
    public void registerListener(IPrintConfigurationListener iPrintConfigurationListener) {
        this.listener = iPrintConfigurationListener;
    }

    @Override
    public int getPageCount() {
        int n = this.columns * this.rows;
        float f = (float)this.boxes.size() / (float)n;
        return (int)Math.ceil(f);
    }

    @Override
    public List<IImageBoxInfo> getAllData() {
        return new ArrayList<IImageBoxInfo>(this.boxes);
    }

    @Override
    public List<IImageBoxInfo> getDataOnPage(int n) {
        RasterPage rasterPage = this.getPage(n);
        if (rasterPage == null) {
            return null;
        }
        return rasterPage.getBoxData();
    }

    @Override
    public void createNewPage() {
        int n = this.columns * this.rows;
        int n2 = this.boxes.size() % n;
        if (n2 == 0) {
            n2 = 4;
        }
        int n3 = 0;
        while (n3 < n - n2) {
            this.boxes.add(null);
            ++n3;
        }
    }

    @Override
    public void createEmptyPage() {
        this.boxes.add(null);
    }
}

