/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.config;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.print.formats.IPrintConfig;
import java.awt.Color;

public class PrintConfig
implements IPrintConfig {
    private String defaultMedium = null;
    private String defaultPrinter = null;
    private double footersize;
    private String leftUpperFooter = null;
    private String rightUpperFooter = null;
    private String middleUpperFooter = null;
    private String leftDownFooter = null;
    private String rightDownFooter = null;
    private double footerFontSize;
    private boolean includeMappings = false;
    private double mappingFont;
    private Color mappingColor;
    private static final double GAP_SIZE = 0.2;
    private static final double BORDER_SIZE = 4.0;

    PrintConfig() {
        this.loadData(ConfigurationProviderFactory.getConfig());
    }

    public String getDefaultPrinter() {
        return this.defaultPrinter;
    }

    public boolean includeMappings() {
        return this.includeMappings;
    }

    public void setIncludeMappings(boolean bl) {
        this.includeMappings = bl;
    }

    public Color getMappingColor() {
        return Color.YELLOW;
    }

    public double getMappingFontSize() {
        return this.mappingFont;
    }

    public String getDefaultMedium() {
        return this.defaultMedium;
    }

    public Color getFooterColor() {
        return Color.BLACK;
    }

    @Override
    public double getFooterSize() {
        return this.footersize;
    }

    public String getLeftDownFooter() {
        return this.leftDownFooter;
    }

    public String getLeftUpperFooter() {
        return this.leftUpperFooter;
    }

    public String getMiddleUpperFooter() {
        return this.middleUpperFooter;
    }

    public String getRightDownFooter() {
        return this.rightDownFooter;
    }

    public String getRightUpperFooter() {
        return this.rightUpperFooter;
    }

    public double getFooterFontSize() {
        return this.footerFontSize;
    }

    private void loadData(IConfigurationProvider iConfigurationProvider) {
        IConfigurationProvider iConfigurationProvider2 = iConfigurationProvider.getNode("listtext.print");
        this.defaultMedium = iConfigurationProvider2.getString("default_medium");
        IConfigurationProvider iConfigurationProvider3 = iConfigurationProvider2.getNode("footer");
        if (iConfigurationProvider3.exists("left_upper")) {
            this.leftUpperFooter = iConfigurationProvider3.getString("left_upper");
        }
        if (iConfigurationProvider3.exists("right_upper")) {
            this.rightUpperFooter = iConfigurationProvider3.getString("right_upper");
        }
        if (iConfigurationProvider3.exists("middle_upper")) {
            this.middleUpperFooter = iConfigurationProvider3.getString("middle_upper");
        }
        if (iConfigurationProvider3.exists("left_down")) {
            this.leftDownFooter = iConfigurationProvider3.getString("left_down");
        }
        if (iConfigurationProvider3.exists("right_down")) {
            this.rightDownFooter = iConfigurationProvider3.getString("right_down");
        }
        this.footerFontSize = iConfigurationProvider3.getDouble("font_size");
        this.footersize = iConfigurationProvider3.getDouble("size");
        if (iConfigurationProvider2.exists("mapping.font_size")) {
            this.includeMappings = true;
            this.mappingFont = iConfigurationProvider2.getDouble("mapping.font_size");
            if (iConfigurationProvider2.exists("mapping.font_color")) {
                this.mappingColor = new Color((int)iConfigurationProvider2.getLong("mapping.font_color"));
            } else if (iConfigurationProvider2.exists("mapping.font_color_name")) {
                String string = iConfigurationProvider2.getString("mapping.font_color_name");
                this.mappingColor = Color.getColor(string);
            }
        }
    }

    @Override
    public double getGapWidth() {
        return 0.2;
    }

    @Override
    public double getGapHeight() {
        return 0.2;
    }

    @Override
    public double getBorderBottom() {
        return this.footersize;
    }

    @Override
    public double getBorderTop() {
        return 4.0;
    }

    @Override
    public double getBorderLeft() {
        return 4.0;
    }

    @Override
    public double getBorderRight() {
        return 4.0;
    }
}

