/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.annonations;

import com.agfa.pacs.listtext.lta.print.annonations.LineText;
import com.agfa.pacs.listtext.print.renderer.Annotation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class PageAnnotation
implements Annotation {
    private LineText upperLine;
    private LineText downline;
    private double leftBorder;
    private double rightBorder;
    private double downBorder;
    private double startHeight;
    private double width;
    private double height;
    private Color color;
    private double fontSize;
    private double resolution;

    public PageAnnotation(LineText lineText, LineText lineText2, double d, double d2, double d3, Color color, double d4) {
        this.upperLine = lineText;
        this.downline = lineText2;
        this.leftBorder = d;
        this.rightBorder = d2;
        this.downBorder = d3;
        this.fontSize = d4;
        this.color = color;
    }

    public void layout(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.startHeight = d2 - this.downBorder + 3.0;
    }

    public void render(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.resolution = d;
        Font font = graphics2D.getFont();
        font = font.deriveFont((float)(this.fontSize * d));
        graphics2D.setFont(font);
        graphics2D.setColor(this.color);
        float f = this.getMaxAscent(this.upperLine, graphics2D);
        Line2D.Double double_ = new Line2D.Double(this.leftBorder * d, this.startHeight * d, (this.width - this.rightBorder) * d, this.startHeight * d);
        graphics2D.draw(double_);
        double d2 = this.startHeight * d + (double)f;
        this.renderText(this.upperLine.getString(0), graphics2D, this.leftBorder, d2, Aligment.Left);
        double d3 = (this.width - this.leftBorder - this.rightBorder) / 2.0 + this.leftBorder;
        this.renderText(this.upperLine.getString(1), graphics2D, d3, d2, Aligment.Center);
        this.renderText(this.upperLine.getString(2), graphics2D, this.width - this.rightBorder, d2, Aligment.Right);
        f = this.getMaxAscent(this.downline, graphics2D);
        d2 = d2 + (double)f + 2.0;
        this.renderText(this.downline.getString(0), graphics2D, this.leftBorder, d2, Aligment.Left);
        this.renderText(this.downline.getString(1), graphics2D, d3, d2, Aligment.Center);
        this.renderText(this.downline.getString(2), graphics2D, this.width - this.rightBorder, d2, Aligment.Right);
    }

    private float getMaxAscent(LineText lineText, Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        float f = 0.0f;
        for (String string : lineText) {
            LineMetrics lineMetrics;
            if (string == null || !(f < (lineMetrics = font.getLineMetrics(string, graphics2D.getFontRenderContext())).getAscent())) continue;
            f = lineMetrics.getAscent();
        }
        return f;
    }

    private void renderText(String string, Graphics2D graphics2D, double d, double d2, Aligment aligment) {
        if (string == null) {
            return;
        }
        Font font = graphics2D.getFont();
        if (aligment.equals((Object)Aligment.Left)) {
            graphics2D.drawString(string, (float)(d * this.resolution), (float)d2);
        } else if (aligment.equals((Object)Aligment.Right)) {
            Rectangle2D rectangle2D = font.getStringBounds(string, graphics2D.getFontRenderContext());
            d = d * this.resolution - rectangle2D.getWidth() - 1.0;
            graphics2D.drawString(string, (float)d, (float)d2);
        } else if (aligment.equals((Object)Aligment.Center)) {
            Rectangle2D rectangle2D = font.getStringBounds(string, graphics2D.getFontRenderContext());
            d = d * this.resolution - rectangle2D.getWidth() / 2.0;
            graphics2D.drawString(string, (float)d, (float)d2);
        }
    }

    private static enum Aligment {
        Right,
        Center,
        Left;

    }
}

