/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.dicompm;

import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmSession;
import com.agfa.pacs.listtext.dicomobject.print.BasicImageBox;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmOrientation;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.ImageDisplayFormat;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.StandardImageDisplayFormat;
import com.agfa.pacs.listtext.pixeldata.frame.PixelDataUtilities;
import com.agfa.pacs.listtext.print.AbstractPrintContext;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.dicompm.DicomDisplayFormat;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmBoxConfiguration;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmSessionConfiguration;
import com.agfa.pacs.listtext.print.dicompm.dicom.DicomPrinter;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.mapper.MapperImageBox;
import com.agfa.pacs.listtext.print.renderer.FilmBox;
import com.agfa.pacs.listtext.print.renderer.FilmBoxRenderer;
import com.agfa.pacs.listtext.print.renderer.FilmBoxSheet;
import com.agfa.pacs.listtext.print.renderer.ImageBox;
import com.agfa.pacs.logging.ALogger;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;

public class SingleImageDicomPrintContext
extends AbstractPrintContext {
    private static ALogger log = ALogger.getLogger(SingleImageDicomPrintContext.class);
    private DicomPrinter printer;
    private MapperFilmSession filmSession;
    private IPrintContext.Status status;
    private double progress;
    private boolean cancel;
    private Map<?, ?> renderingHints;

    public SingleImageDicomPrintContext(DicomPrinter dicomPrinter, MapperFilmSession mapperFilmSession) {
        this.printer = dicomPrinter;
        this.filmSession = mapperFilmSession;
        this.cancel = false;
        this.progress = 0.0;
        this.status = IPrintContext.Status.NotStarted;
    }

    public double getProgress() {
        return this.progress;
    }

    public IPrintContext.Status getStatus() {
        return this.status;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isRunning() {
        return this.status == IPrintContext.Status.InProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DicomPrinter dicomPrinter = this.printer;
        synchronized (dicomPrinter) {
            this.status = IPrintContext.Status.InProgress;
            int n = this.filmSession.filmBoxes().size();
            int n2 = 1;
            DicomFilmSessionConfiguration dicomFilmSessionConfiguration = (DicomFilmSessionConfiguration)this.filmSession.getMapperConfiguration(DicomFilmSessionConfiguration.class);
            if (dicomFilmSessionConfiguration != null) {
                this.printer.setPrintColor(dicomFilmSessionConfiguration.getPrintColor());
            }
            BasicFilmSession basicFilmSession = this.createFilmSession(this.filmSession);
            this.printer.beginPrinting();
            this.printer.beginFilmSession(basicFilmSession);
            for (MapperFilmBox mapperFilmBox : this.filmSession.filmBoxes()) {
                this.progress = (double)n2 / (double)n;
                ++n2;
                if (this.cancel) break;
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    FilmBox filmBox = new FilmBox();
                    IDisplayFormat iDisplayFormat = mapperFilmBox.getDisplayFormat();
                    filmBox.setFilmBoxLayout(iDisplayFormat.getFilmBoxLayout());
                    FilmBoxSheet filmBoxSheet = new FilmBoxSheet(filmBox, iDisplayFormat.getFilmSize(), iDisplayFormat.getFilmBoxResolution(), this.filmSession.getZoomRatio(), iDisplayFormat.isRotated(), null, 0, 0);
                    filmBoxSheet.layout();
                    if (this.cancel) break;
                    mapperFilmBox.prepareRendering(true);
                    if (this.cancel) break;
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < mapperFilmBox.imageBoxes().size()) {
                        object3 = (MapperImageBox)mapperFilmBox.imageBoxes().get(n3);
                        object2 = (ImageBox)filmBox.imageBoxes().get(n3);
                        object2.setDicomObjectRenderer(object3.getDicomObjectRenderer());
                        object = object3.getPresentationSizeMode();
                        object2.setIncludeMappings(object3.isIncludeMappings());
                        object2.setMappingsOutside(object3.isMappingsOutside());
                        if (object == PresentationSizeMode.ScaleToFit) {
                            object2.setImageFitting(ImageBox.ImageFitting.Scale);
                        } else if (object == PresentationSizeMode.TrueSize) {
                            object2.setImageFitting(ImageBox.ImageFitting.Crop);
                            bl = true;
                        }
                        ++n3;
                    }
                    if (this.cancel) break;
                    FilmBoxRenderer filmBoxRenderer = filmBoxSheet.createFilmBoxRenderer();
                    if (this.filmSession.getZoomRatio() != null) {
                        filmBoxRenderer.setZoomRatio(this.filmSession.getZoomRatio());
                    }
                    object3 = null;
                    switch (dicomFilmSessionConfiguration.getPrintColor()) {
                        case Gray: {
                            object3 = new BufferedImage(filmBoxRenderer.getPixelWidth(), filmBoxRenderer.getPixelHeight(), 10);
                            break;
                        }
                        case Color: {
                            object3 = new BufferedImage(filmBoxRenderer.getPixelWidth(), filmBoxRenderer.getPixelHeight(), 1);
                        }
                    }
                    object2 = (Graphics2D)((BufferedImage)object3).getGraphics();
                    if (this.renderingHints != null) {
                        ((Graphics2D)object2).addRenderingHints(this.renderingHints);
                    }
                    filmBoxRenderer.setGraphics((Graphics2D)object2, ((BufferedImage)object3).getType());
                    filmBoxRenderer.render(filmBoxSheet);
                    object = this.createBasicFilmBox(mapperFilmBox);
                    this.printer.beginFilmBox((BasicFilmBox)((Object)object));
                    if (this.cancel) break;
                    ReferencedSOP referencedSOP = ((BasicFilmBox)((Object)object)).imageBoxes().get(0);
                    BasicImageBox basicImageBox = this.createBasicImageBox(referencedSOP, (BufferedImage)object3);
                    if (bl) {
                        basicImageBox.setRequestedImageSize(filmBoxRenderer.getPrintingPixelSpacing() * (double)filmBoxRenderer.getPixelWidth());
                    }
                    this.printer.setImageBox(basicImageBox);
                    if (this.cancel) break;
                    this.printer.endFilmBox();
                    this.notifyProgressed(IPrintContext.Status.Succeded, mapperFilmBox);
                }
                catch (Exception exception) {
                    log.error("Film box error", (Throwable)exception);
                    this.notifyProgressed(IPrintContext.Status.Failed, mapperFilmBox);
                }
            }
            this.printer.endFilmSession();
            this.printer.endPrinting();
            this.status = this.cancel ? IPrintContext.Status.Canceled : IPrintContext.Status.Finished;
            this.notifyFinished(this.status);
        }
    }

    private BasicFilmSession createFilmSession(MapperFilmSession mapperFilmSession) {
        BasicFilmSession basicFilmSession = new BasicFilmSession();
        DicomFilmSessionConfiguration dicomFilmSessionConfiguration = (DicomFilmSessionConfiguration)mapperFilmSession.getMapperConfiguration(DicomFilmSessionConfiguration.class);
        if (dicomFilmSessionConfiguration != null) {
            basicFilmSession.setFilmDestination(dicomFilmSessionConfiguration.getFilmDestination());
            basicFilmSession.setFilmSessionLabel(dicomFilmSessionConfiguration.getFilmSessionLabel());
            basicFilmSession.setMediumType(dicomFilmSessionConfiguration.getMediumType());
            basicFilmSession.setMemoryAllocation(dicomFilmSessionConfiguration.getMemoryAllocation());
            basicFilmSession.setNumberOfCopies(dicomFilmSessionConfiguration.getNumberOfCopies());
            basicFilmSession.setOwnerID(dicomFilmSessionConfiguration.getOwnerID());
            basicFilmSession.setPrintPriority(dicomFilmSessionConfiguration.getPrintPriority());
        }
        return basicFilmSession;
    }

    private BasicFilmBox createBasicFilmBox(MapperFilmBox mapperFilmBox) {
        DicomDisplayFormat dicomDisplayFormat;
        BasicFilmBox basicFilmBox = new BasicFilmBox();
        DicomFilmBoxConfiguration dicomFilmBoxConfiguration = (DicomFilmBoxConfiguration)mapperFilmBox.getMapperConfiguration(DicomFilmBoxConfiguration.class);
        if (dicomFilmBoxConfiguration != null) {
            basicFilmBox.setAnnotationDisplayFormatID(dicomFilmBoxConfiguration.getAnnotationDisplayFormatID());
            basicFilmBox.setBorderDensity(dicomFilmBoxConfiguration.getBorderDensity());
            basicFilmBox.setConfigurationInformation(dicomFilmBoxConfiguration.getConfigurationInformation());
            basicFilmBox.setEmptyImageDensity(dicomFilmBoxConfiguration.getEmptyImageDensity());
            basicFilmBox.setIllumination(dicomFilmBoxConfiguration.getIllumination());
            basicFilmBox.setMagnificationType(dicomFilmBoxConfiguration.getMagnificationType());
            basicFilmBox.setMaxDensity(dicomFilmBoxConfiguration.getMaxDensity());
            basicFilmBox.setMinDensity(dicomFilmBoxConfiguration.getMinDensity());
            basicFilmBox.setReflectedAmbientLight(dicomFilmBoxConfiguration.getReflectedAmbientLight());
            basicFilmBox.setSmoothingType(dicomFilmBoxConfiguration.getSmoothingType());
            basicFilmBox.setTrim(dicomFilmBoxConfiguration.getTrim());
        }
        if ((dicomDisplayFormat = (DicomDisplayFormat)mapperFilmBox.getDisplayFormat()) != null) {
            basicFilmBox.setFilmOrientation(FilmOrientation.Portrait);
            basicFilmBox.setFilmSizeID(dicomDisplayFormat.getFilmSizeID());
            basicFilmBox.setImageDisplayFormat((ImageDisplayFormat)new StandardImageDisplayFormat(1, 1));
        }
        return basicFilmBox;
    }

    private BasicImageBox createBasicImageBox(ReferencedSOP referencedSOP, BufferedImage bufferedImage) {
        BasicImageBox basicImageBox = new BasicImageBox(referencedSOP);
        basicImageBox.setImagePosition(1);
        try {
            ImagePixel imagePixel;
            if (basicImageBox.isGray()) {
                imagePixel = PixelDataUtilities.createImagePixel((BufferedImage)bufferedImage, (String)"1.2.840.10008.1.2.1", (int)8);
                basicImageBox.setGrayscaleImage(imagePixel);
            }
            if (basicImageBox.isColor()) {
                imagePixel = PixelDataUtilities.createImagePixel((BufferedImage)bufferedImage, (String)"1.2.840.10008.1.2.1", (int)8);
                basicImageBox.setColorImage(imagePixel);
            }
        }
        catch (PixelDataException pixelDataException) {
            log.error("Rendering problem", (Throwable)pixelDataException);
        }
        return basicImageBox;
    }
}

