/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.print;

import com.agfa.pacs.listtext.dicomobject.NormalizedInformationObject;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.general.SOPCommonModule;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.module.print.ImageBoxPresentationModule;
import com.agfa.pacs.listtext.dicomobject.type.print.ConfigurationInformation;
import com.agfa.pacs.listtext.dicomobject.type.print.DecimateCropBehavior;
import com.agfa.pacs.listtext.dicomobject.type.print.MagnificationType;
import com.agfa.pacs.listtext.dicomobject.type.print.Polarity;
import org.dcm4che3.data.Attributes;

public class BasicImageBox
extends NormalizedInformationObject {
    private ImageBoxPresentationModule ibp;

    public BasicImageBox(ReferencedSOP referencedSOP) {
        this((Attributes)null);
        this.setSOPClassUID(referencedSOP.getSOPClassUID());
        this.setSOPInstanceUID(referencedSOP.getSOPInstanceUID());
    }

    public BasicImageBox(Attributes attributes) {
        super(new Class[]{SOPCommonModule.class, ImageBoxPresentationModule.class}, attributes);
    }

    protected void init(boolean bl) {
        super.init(bl);
        this.ibp = (ImageBoxPresentationModule)this.getModule(ImageBoxPresentationModule.class);
    }

    public void setColorImage(ImagePixel imagePixel) {
        this.ibp.setColorImage(imagePixel);
    }

    public void setConfigurationInformation(ConfigurationInformation configurationInformation) {
        this.ibp.setConfigurationInformation(configurationInformation);
    }

    public void setGrayscaleImage(ImagePixel imagePixel) {
        this.ibp.setGrayscaleImage(imagePixel);
    }

    public void setImagePosition(Integer n) {
        this.ibp.setImagePosition(n);
    }

    public void setMagnificationType(MagnificationType magnificationType) {
        this.ibp.setMagnificationType(magnificationType);
    }

    public void setPolarity(Polarity polarity) {
        this.ibp.setPolarity(polarity);
    }

    public void setRequestedDecimateCropBehavior(DecimateCropBehavior decimateCropBehavior) {
        this.ibp.setRequestedDecimateCropBehavior(decimateCropBehavior);
    }

    public void setRequestedImageSize(Double d) {
        if (d == null) {
            this.ibp.setRequestedImageSize(d);
        } else {
            this.ibp.setRequestedImageSize(Double.valueOf((double)Math.round(d * 10.0) / 10.0));
        }
    }

    public void setSmoothingType(String string) {
        this.ibp.setSmoothingType(string);
    }

    public void setMaxDensity(Integer n) {
        this.ibp.setMaxDensity(n);
    }

    public void setMinDensity(Integer n) {
        this.ibp.setMinDensity(n);
    }

    public Attributes getNSetDicomObject() {
        Attributes attributes = new Attributes();
        if (this.isGray()) {
            this.ibp.writeToGrayNSet(attributes);
        } else {
            this.ibp.writeToColorNSet(attributes);
        }
        return attributes;
    }

    public boolean isColor() {
        return "1.2.840.10008.5.1.1.4.1".equals(this.getSOPClassUID());
    }

    public boolean isGray() {
        return "1.2.840.10008.5.1.1.4".equals(this.getSOPClassUID());
    }
}

