/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail;

import com.agfa.pacs.listtext.lta.thumbnail.IThumbnailLoadingListener;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailLoader;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;

public class ThumbnailLoaderDispatcher
extends Thread {
    private static final ALogger log = ALogger.getLogger(ThumbnailLoaderDispatcher.class);
    private static final int LOADER_COUNT = 3;
    private static final long DEFAULT_TIMEOUT = 5000L;
    private final BlockingQueue<ThumbnailFrame> queue = new LinkedBlockingQueue<ThumbnailFrame>();
    private List<ThumbnailLoader> loaders = new ArrayList<ThumbnailLoader>(3);
    private List<IThumbnailLoadingListener> listener = new ArrayList<IThumbnailLoadingListener>();
    private boolean timedOut = false;

    public ThumbnailLoaderDispatcher() {
        super("Thumbnail Loader Dispatcher");
    }

    @Override
    public void run() {
        this.createAndStartLoaders(3);
        while (!this.timedOut) {
            try {
                ThumbnailFrame thumbnailFrame = this.queue.poll(5000L, TimeUnit.MILLISECONDS);
                if (thumbnailFrame != null) {
                    ThumbnailLoader thumbnailLoader = null;
                    boolean bl = false;
                    for (ThumbnailLoader thumbnailLoader2 : this.loaders) {
                        if (thumbnailLoader2.isQueuedOrLoading(thumbnailFrame)) {
                            bl = true;
                            break;
                        }
                        if (thumbnailLoader != null && thumbnailLoader2.getNumberOfQueuedRequests() >= thumbnailLoader.getNumberOfQueuedRequests()) continue;
                        thumbnailLoader = thumbnailLoader2;
                    }
                    if (thumbnailLoader == null || bl) continue;
                    thumbnailLoader.addToLoadingQueue(thumbnailFrame);
                    continue;
                }
                this.timedOut = true;
            }
            catch (InterruptedException interruptedException) {
                log.warn("Loading thumbnail failed!", (Throwable)interruptedException);
            }
        }
        this.cancelLoaders();
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void clearLoadingQueue() {
        if (log.isDebugEnabled()) {
            log.debug("Thumbnail loading queue cleared");
        }
        this.queue.clear();
    }

    public synchronized void removeFromLoadingQueue(Collection<ThumbnailFrame> collection) {
        for (ThumbnailFrame thumbnailFrame : collection) {
            this.removeFromLoadingQueue(thumbnailFrame);
        }
    }

    public synchronized void addToLoadingQueue(Collection<ThumbnailFrame> collection) {
        for (ThumbnailFrame thumbnailFrame : collection) {
            this.addToLoadingQueue(thumbnailFrame);
        }
    }

    public synchronized boolean addToLoadingQueue(ThumbnailFrame thumbnailFrame) {
        try {
            if (thumbnailFrame != null && !this.isQueued(thumbnailFrame)) {
                this.queue.put(thumbnailFrame);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            log.warn("Adding object into thumbnail loading queue failed!", (Throwable)interruptedException);
        }
        return false;
    }

    public synchronized boolean removeFromLoadingQueue(ThumbnailFrame thumbnailFrame) {
        if (this.queue.contains(thumbnailFrame)) {
            return this.queue.remove(thumbnailFrame);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadingListener(IThumbnailLoadingListener iThumbnailLoadingListener) {
        List<IThumbnailLoadingListener> list = this.listener;
        synchronized (list) {
            if (iThumbnailLoadingListener != null && !this.listener.contains(iThumbnailLoadingListener)) {
                this.listener.add(iThumbnailLoadingListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadingListener(IThumbnailLoadingListener iThumbnailLoadingListener) {
        List<IThumbnailLoadingListener> list = this.listener;
        synchronized (list) {
            if (iThumbnailLoadingListener != null && this.listener.contains(iThumbnailLoadingListener)) {
                this.listener.remove(iThumbnailLoadingListener);
            }
        }
    }

    private boolean isQueued(ThumbnailFrame thumbnailFrame) {
        return this.queue.contains(thumbnailFrame);
    }

    private void createAndStartLoaders(int n) {
        int n2 = 0;
        while (n2 < n) {
            ThumbnailLoader thumbnailLoader = new ThumbnailLoader(this);
            thumbnailLoader.start();
            this.loaders.add(thumbnailLoader);
            ++n2;
        }
    }

    private void cancelLoaders() {
        for (ThumbnailLoader thumbnailLoader : this.loaders) {
            thumbnailLoader.cancel();
        }
        this.loaders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireThumbnailLoaded(ThumbnailFrame thumbnailFrame, Icon icon) {
        List<IThumbnailLoadingListener> list = this.listener;
        synchronized (list) {
            for (IThumbnailLoadingListener iThumbnailLoadingListener : this.listener) {
                iThumbnailLoadingListener.thumbnailLoaded(thumbnailFrame, icon);
            }
        }
    }
}

