/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.lta.thumbnail.IThumbnailLoadingListener;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailLoader;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailLoaderDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.Icon;

public class ThumbnailCache {
    private static ThumbnailCache instance = null;
    private static final int CACHE_SIZE = Product.hasReducedResources() ? 100 : 1000;
    private SortedMap<Long, ThumbnailFrame> timestampMap = new TreeMap<Long, ThumbnailFrame>();
    private Map<ThumbnailFrame, Icon> thumbnailMap = new HashMap<ThumbnailFrame, Icon>();
    private IThumbnailLoadingListener loadingListener = new ThumbnailLoadingListener();
    private List<IThumbnailLoadingListener> cacheListener = new ArrayList<IThumbnailLoadingListener>();
    private ThumbnailLoaderDispatcher loader;

    private ThumbnailCache() {
    }

    public static synchronized ThumbnailCache getInstance() {
        if (instance == null) {
            instance = new ThumbnailCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache() {
        if (this.loader != null) {
            this.loader.clearLoadingQueue();
        }
        Map<ThumbnailFrame, Icon> map = this.thumbnailMap;
        synchronized (map) {
            if (this.thumbnailMap.size() > CACHE_SIZE) {
                try {
                    int n = 0;
                    while (n < CACHE_SIZE / 2) {
                        Long l = this.timestampMap.firstKey();
                        ThumbnailFrame thumbnailFrame = (ThumbnailFrame)this.timestampMap.get(l);
                        this.timestampMap.remove(l);
                        this.thumbnailMap.remove(thumbnailFrame);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    this.timestampMap.clear();
                    this.thumbnailMap.clear();
                }
            }
        }
    }

    public Icon getDefaultThumbnail(ThumbnailFrame thumbnailFrame) {
        return ThumbnailLoader.getDefaultThumbnail(thumbnailFrame.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Icon getThumbnail(ThumbnailFrame thumbnailFrame) {
        Icon icon = null;
        if (thumbnailFrame != null) {
            Map<ThumbnailFrame, Icon> map = this.thumbnailMap;
            synchronized (map) {
                icon = this.thumbnailMap.get(thumbnailFrame);
            }
            if (icon == null) {
                icon = this.getDefaultThumbnail(thumbnailFrame);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestThumbnailLoading(Collection<ThumbnailFrame> collection) {
        ArrayList<ThumbnailFrame> arrayList = new ArrayList<ThumbnailFrame>();
        Map<ThumbnailFrame, Icon> map = this.thumbnailMap;
        synchronized (map) {
            for (ThumbnailFrame thumbnailFrame : collection) {
                Icon icon = this.thumbnailMap.get(thumbnailFrame);
                if (icon != null) continue;
                arrayList.add(thumbnailFrame);
            }
        }
        if (!arrayList.isEmpty()) {
            this.addToLoadingQueue(arrayList);
        }
    }

    public synchronized void cancelThumbnailLoading(Collection<ThumbnailFrame> collection) {
        this.removeFromLoadingQueue(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadingListener(IThumbnailLoadingListener iThumbnailLoadingListener) {
        List<IThumbnailLoadingListener> list = this.cacheListener;
        synchronized (list) {
            if (iThumbnailLoadingListener != null && !this.cacheListener.contains(iThumbnailLoadingListener)) {
                this.cacheListener.add(iThumbnailLoadingListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadingListener(IThumbnailLoadingListener iThumbnailLoadingListener) {
        List<IThumbnailLoadingListener> list = this.cacheListener;
        synchronized (list) {
            if (iThumbnailLoadingListener != null && this.cacheListener.contains(iThumbnailLoadingListener)) {
                this.cacheListener.remove(iThumbnailLoadingListener);
            }
        }
    }

    private void addToLoadingQueue(Collection<ThumbnailFrame> collection) {
        if (this.loader != null && this.loader.isTimedOut()) {
            this.loader = null;
        }
        if (this.loader == null) {
            this.loader = new ThumbnailLoaderDispatcher();
            this.loader.addLoadingListener(this.loadingListener);
            this.loader.start();
        }
        this.loader.addToLoadingQueue(collection);
    }

    private void removeFromLoadingQueue(Collection<ThumbnailFrame> collection) {
        if (this.loader != null) {
            this.loader.removeFromLoadingQueue(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireThumbnailLoaded(ThumbnailFrame thumbnailFrame, Icon icon) {
        List<IThumbnailLoadingListener> list = this.cacheListener;
        synchronized (list) {
            for (IThumbnailLoadingListener iThumbnailLoadingListener : this.cacheListener) {
                iThumbnailLoadingListener.thumbnailLoaded(thumbnailFrame, icon);
            }
        }
    }

    private class ThumbnailLoadingListener
    implements IThumbnailLoadingListener {
        private ThumbnailLoadingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void thumbnailLoaded(ThumbnailFrame thumbnailFrame, Icon icon) {
            Map map = ThumbnailCache.this.thumbnailMap;
            synchronized (map) {
                if (thumbnailFrame != null && icon != null) {
                    ThumbnailCache.this.timestampMap.put(System.nanoTime(), thumbnailFrame);
                    ThumbnailCache.this.thumbnailMap.put(thumbnailFrame, icon);
                }
            }
            ThumbnailCache.this.fireThumbnailLoaded(thumbnailFrame, icon);
        }
    }
}

