/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.thumbnail.IThumbnailLoadingSelector;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailCache;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.lta.thumbnail.plaf.ThumbnailTransferHandler;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.pixeldata.frame.IFrameSelection;
import com.agfa.pacs.listtext.swingx.controls.AbstractComponent;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AbstractThumbnails
extends AbstractComponent
implements IThumbnailLoadingSelector {
    private static ALogger log = ALogger.getLogger(AbstractThumbnails.class);
    public static final String RESET = "RESET";
    public static final String INITIALIZATION_STARTED = "INITIALIZATION_STARTED";
    public static final String INITIALIZATION_FINISHED = "INITIALIZATION_FINISHED";
    private ThumbnailInitializer initializer;
    private FrameComparator frameComparator;
    private DataComparator dataComparator = new DataComparator();
    private SortedSet<ThumbnailFrame> frames;
    private Map<ISeriesInfo, Collection<ThumbnailFrame>> seriesMap;

    public AbstractThumbnails() {
        this.frameComparator = new FrameComparator();
        this.frames = new TreeSet<ThumbnailFrame>(this.frameComparator);
        this.seriesMap = new HashMap<ISeriesInfo, Collection<ThumbnailFrame>>();
    }

    public synchronized void reset() {
        this.resetImpl(true);
        this.firePropertyChange(RESET, false, true);
    }

    public synchronized Collection<IPatientInfo> getPatients() {
        ArrayList<IPatientInfo> arrayList = new ArrayList<IPatientInfo>(1);
        if (this.seriesMap != null) {
            for (ISeriesInfo iSeriesInfo : this.seriesMap.keySet()) {
                IPatientInfo iPatientInfo = iSeriesInfo.getPatient();
                if (arrayList.contains(iPatientInfo)) continue;
                arrayList.add(iPatientInfo);
            }
        }
        return arrayList;
    }

    public synchronized Collection<IStudyInfo> getStudies() {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        for (ISeriesInfo iSeriesInfo : this.seriesMap.keySet()) {
            IStudyInfo iStudyInfo = (IStudyInfo)iSeriesInfo.getTreeParent();
            if (iStudyInfo == null || arrayList.contains(iStudyInfo)) continue;
            arrayList.add(iStudyInfo);
        }
        Collections.sort(arrayList, this.dataComparator);
        return arrayList;
    }

    public synchronized Collection<ISeriesInfo> getSeries(IStudyInfo iStudyInfo) {
        ArrayList<ISeriesInfo> arrayList = new ArrayList<ISeriesInfo>();
        for (ISeriesInfo iSeriesInfo : this.seriesMap.keySet()) {
            if (!CompareUtils.equals((Object)iStudyInfo, (Object)iSeriesInfo.getTreeParent())) continue;
            arrayList.add(iSeriesInfo);
        }
        Collections.sort(arrayList, this.dataComparator);
        return arrayList;
    }

    public synchronized Collection<ThumbnailFrame> getFrames(ISeriesInfo iSeriesInfo) {
        if (this.seriesMap.containsKey(iSeriesInfo)) {
            return Collections.unmodifiableCollection(this.seriesMap.get(iSeriesInfo));
        }
        return Collections.emptyList();
    }

    public synchronized Collection<ThumbnailFrame> getFrames() {
        return Collections.unmodifiableCollection(this.frames);
    }

    public void initialize(List<? extends IDataInfo> list) {
        if (this.initializer != null && !this.initializer.isCancelled()) {
            this.initializer.cancel();
        }
        this.initializer = new ThumbnailInitializer(list);
        this.initializer.start();
    }

    public void initialize(Collection<ThumbnailFrame> collection) {
        if (this.initializer != null && !this.initializer.isCancelled()) {
            this.initializer.cancel();
        }
        this.initializer = new ThumbnailInitializer(collection);
        this.initializer.start();
    }

    public ThumbnailTransferHandler createTransferHandler() {
        return new ThumbnailTransferHandler();
    }

    public abstract void handlePopup(List<IDataInfo> var1, Object var2, Component var3, int var4, int var5);

    protected void resetImpl(boolean bl) {
        if (bl) {
            ThumbnailCache.getInstance().clearCache();
        }
        if (this.frames != null) {
            this.frames.clear();
        }
        if (this.seriesMap != null) {
            this.seriesMap.clear();
        }
    }

    @Override
    public boolean isThumbnailLoadingEnabled(ThumbnailFrame thumbnailFrame) {
        return this.isObjectSupported(thumbnailFrame.getObject());
    }

    protected boolean isObjectSupported(IObjectInfo iObjectInfo) {
        return UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.Image);
    }

    private List<IDataInfo> getSupportedData(List<? extends IDataInfo> list) {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        for (IDataInfo iDataInfo : list) {
            String[] stringArray;
            if (iDataInfo instanceof IObjectInfo) {
                if (!this.isObjectSupported((IObjectInfo)iDataInfo)) continue;
                arrayList.add(iDataInfo);
                continue;
            }
            if (iDataInfo instanceof ISeriesInfo) {
                stringArray = iDataInfo.getAttributes().getString(524384);
                if (stringArray == null) {
                    arrayList.add(iDataInfo);
                    continue;
                }
                if (Modality.KO.dicom().equals(stringArray) || Modality.SR.dicom().equals(stringArray) || Modality.PR.dicom().equals(stringArray)) continue;
                arrayList.add(iDataInfo);
                continue;
            }
            if (iDataInfo instanceof IStudyInfo) {
                stringArray = iDataInfo.getAttributes().getStrings(524385);
                if (stringArray == null) {
                    arrayList.add(iDataInfo);
                    continue;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
                if (arrayList2.isEmpty()) continue;
                boolean bl = arrayList2.remove(Modality.KO.dicom());
                boolean bl2 = arrayList2.remove(Modality.SR.dicom());
                boolean bl3 = arrayList2.remove(Modality.PR.dicom());
                if (arrayList2.isEmpty()) continue;
                if (bl || bl2 || bl3) {
                    arrayList.addAll(this.getSupportedData(DataInfoUtilities.getLevel((IDataInfo)iDataInfo, ISeriesInfo.class)));
                    continue;
                }
                arrayList.add(iDataInfo);
                continue;
            }
            if (!(iDataInfo instanceof IPatientInfo)) continue;
            arrayList.addAll(this.getSupportedData(DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IStudyInfo.class)));
        }
        return arrayList;
    }

    private static class DataComparator
    implements Comparator<IDataInfo> {
        private DataComparator() {
        }

        @Override
        public int compare(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            int n = this.compareStudyDate(iDataInfo, iDataInfo2);
            if (n == 0) {
                n = this.compareSeriesNumber(iDataInfo, iDataInfo2);
            }
            if (n == 0) {
                n = this.compareInstanceNumber(iDataInfo, iDataInfo2);
            }
            if (n == 0) {
                n = iDataInfo.getKey().length() - iDataInfo2.getKey().length();
            }
            if (n == 0) {
                n = iDataInfo.getKey().compareTo(iDataInfo2.getKey());
            }
            return n;
        }

        private int compareStudyDate(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            Date date;
            Date date2 = iDataInfo != null ? iDataInfo.getAttributes().getDate(524320) : null;
            Date date3 = date = iDataInfo2 != null ? iDataInfo2.getAttributes().getDate(524320) : null;
            if (date2 != null && date != null) {
                return date2.compareTo(date);
            }
            if (date2 != null) {
                return -1;
            }
            if (date != null) {
                return 1;
            }
            return 0;
        }

        private int compareSeriesNumber(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            Integer n;
            if (iDataInfo == null && iDataInfo2 == null) {
                return 0;
            }
            if (iDataInfo == null) {
                return 1;
            }
            if (iDataInfo2 == null) {
                return -1;
            }
            String string = iDataInfo.getAttributes().getString(0x20000E);
            String string2 = iDataInfo2.getAttributes().getString(0x20000E);
            if (string != null && string2 != null && string.equals(string2)) {
                return 0;
            }
            Integer n2 = iDataInfo.getAttributes().contains(0x200011) ? Integer.valueOf(iDataInfo.getAttributes().getInt(0x200011, 0)) : null;
            Integer n3 = n = iDataInfo2.getAttributes().contains(0x200011) ? Integer.valueOf(iDataInfo2.getAttributes().getInt(0x200011, 0)) : null;
            if (n2 != null && n != null) {
                return n2.compareTo(n);
            }
            if (n2 != null) {
                return -1;
            }
            if (n != null) {
                return 1;
            }
            return 0;
        }

        private int compareInstanceNumber(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            int n = iDataInfo.getAttributes().getInt(2097171, -1);
            int n2 = iDataInfo2.getAttributes().getInt(2097171, -1);
            if (n != -1 && n2 != -1) {
                return new Integer(n).compareTo(n2);
            }
            if (n != -1) {
                return -1;
            }
            if (n2 != -1) {
                return 1;
            }
            return 0;
        }
    }

    private static class FrameComparator
    implements Comparator<ThumbnailFrame> {
        private DataComparator objectInfoComparator = new DataComparator();

        private FrameComparator() {
        }

        @Override
        public int compare(ThumbnailFrame thumbnailFrame, ThumbnailFrame thumbnailFrame2) {
            IObjectInfo iObjectInfo;
            IObjectInfo iObjectInfo2 = thumbnailFrame.getObject();
            int n = this.objectInfoComparator.compare((IDataInfo)iObjectInfo2, (IDataInfo)(iObjectInfo = thumbnailFrame2.getObject()));
            if (n == 0) {
                Integer n2 = thumbnailFrame.getFrameNumber();
                Integer n3 = thumbnailFrame2.getFrameNumber();
                if (n2 != null && n3 != null) {
                    return n2.compareTo(n3);
                }
                if (n2 != null) {
                    return -1;
                }
                if (n3 != null) {
                    return 1;
                }
                return 0;
            }
            return n;
        }
    }

    private class ThumbnailInitializer
    extends Thread {
        private List<? extends IDataInfo> data;
        private Collection<ThumbnailFrame> frames;
        private boolean cancelled;

        public ThumbnailInitializer(List<? extends IDataInfo> list) {
            super("Thumbnail Initializer");
            this.data = list;
            this.cancelled = false;
        }

        public ThumbnailInitializer(Collection<ThumbnailFrame> collection) {
            super("Thumbnail Initializer");
            this.frames = collection;
            this.cancelled = false;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                try {
                    try {
                        AbstractThumbnails.this.firePropertyChange(AbstractThumbnails.INITIALIZATION_STARTED, false, true);
                        if (this.data != null || this.frames != null) {
                            Object object;
                            ISeriesInfo iSeriesInfo;
                            Object object2;
                            Object object32;
                            Object object4;
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            if (this.frames == null) {
                                object4 = null;
                                object32 = null;
                                object2 = null;
                                if (!this.cancelled) {
                                    object4 = DataInfoUtilities.findLowestNodes(this.data);
                                }
                                if (!this.cancelled) {
                                    object32 = AbstractThumbnails.this.getSupportedData(object4);
                                }
                                if (!this.cancelled) {
                                    object2 = AbstractThumbnails.this.getSupportedData(DataInfoUtilities.getLevel((Collection)object32, IObjectInfo.class));
                                }
                                this.frames = new ArrayList<ThumbnailFrame>();
                                if (object2 != null) {
                                    iSeriesInfo = object2.iterator();
                                    while (iSeriesInfo.hasNext()) {
                                        object = (IObjectInfo)iSeriesInfo.next();
                                        if (!hashMap.containsKey(object.getSeriesUID())) {
                                            hashMap.put(object.getSeriesUID(), object.getSeries());
                                        }
                                        this.frames.addAll(this.createFrames((IObjectInfo)object));
                                    }
                                }
                            } else {
                                object4 = new ArrayList();
                                object32 = this.frames.iterator();
                                while (object32.hasNext()) {
                                    object2 = object32.next();
                                    if (!AbstractThumbnails.this.isObjectSupported(((ThumbnailFrame)object2).getObject())) {
                                        object32.remove();
                                        continue;
                                    }
                                    object = ((ThumbnailFrame)object2).getObject().getSeries();
                                    if (object4.contains(object)) continue;
                                    object4.add(object);
                                }
                                object4 = DataInfoUtilities.getLevel((Collection)DataInfoUtilities.mergeDuplicates(object4), (Level)Level.Series);
                                object2 = object4.iterator();
                                while (object2.hasNext()) {
                                    object32 = (ISeriesInfo)object2.next();
                                    hashMap.put(object32.getSeriesUID(), object32);
                                }
                            }
                            if (this.cancelled) break block25;
                            object4 = AbstractThumbnails.this;
                            synchronized (object4) {
                                AbstractThumbnails.this.resetImpl(true);
                                AbstractThumbnails.this.frames.addAll(this.frames);
                                for (Object object32 : AbstractThumbnails.this.frames) {
                                    if (this.cancelled) continue;
                                    object = ((ThumbnailFrame)object32).getObject().getTreeParent().getKey();
                                    iSeriesInfo = (ISeriesInfo)hashMap.get(object);
                                    if (!AbstractThumbnails.this.seriesMap.containsKey(iSeriesInfo)) {
                                        AbstractThumbnails.this.seriesMap.put(iSeriesInfo, new ArrayList());
                                    }
                                    ((Collection)AbstractThumbnails.this.seriesMap.get(iSeriesInfo)).add(object32);
                                }
                                if (!this.cancelled && log.isDebugEnabled()) {
                                    log.debug("Thumbnail view initialized (" + this.frames.size() + " thumbnail frames)");
                                }
                                break block25;
                            }
                        }
                        log.debug("Thumbnail view initialized (0 thumbnail frames)");
                    }
                    catch (Exception exception) {
                        log.error("Initializing thumbnail view failed!", (Throwable)exception);
                        if (!this.cancelled) {
                            AbstractThumbnails.this.firePropertyChange(AbstractThumbnails.INITIALIZATION_FINISHED, false, true);
                        }
                    }
                }
                finally {
                    if (!this.cancelled) {
                        AbstractThumbnails.this.firePropertyChange(AbstractThumbnails.INITIALIZATION_FINISHED, false, true);
                    }
                }
            }
        }

        private List<ThumbnailFrame> createFrames(IObjectInfo iObjectInfo) {
            ArrayList<ThumbnailFrame> arrayList = null;
            if (iObjectInfo instanceof IFrameSelection) {
                arrayList = new ArrayList<ThumbnailFrame>();
                int[] nArray = ((IFrameSelection)iObjectInfo).getContainedFrames();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    arrayList.add(new ThumbnailFrame(iObjectInfo, n3));
                    ++n2;
                }
            } else {
                int n = iObjectInfo.getAttributes().getInt(0x280008, 0);
                if (UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.Multiframe) && n > 1) {
                    arrayList = new ArrayList(n);
                    int n4 = 0;
                    while (n4 < n) {
                        arrayList.add(new ThumbnailFrame(iObjectInfo, n4));
                        ++n4;
                    }
                } else {
                    arrayList = new ArrayList(1);
                    arrayList.add(new ThumbnailFrame(iObjectInfo, null));
                }
            }
            return arrayList;
        }
    }
}

